/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.base;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityDivineTameable
extends TamableAnimal
implements NeutralMob {
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(EntityDivineTameable.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(EntityDivineTameable.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    @Nullable
    private UUID persistentAngerTarget;
    protected final float healthIncrease;

    protected EntityDivineTameable(EntityType<? extends TamableAnimal> type, Level worldIn, float healthIncrease) {
        super(type, worldIn);
        this.healthIncrease = healthIncrease;
        this.m_7105_(false);
    }

    public boolean isMeat(ItemStack item) {
        return item.getFoodProperties((LivingEntity)this) != null && item.getFoodProperties((LivingEntity)this).m_38746_();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((EntityDivineTameable)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public float m_5610_(BlockPos pos, LevelReader reader) {
        return 0.0f;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        Entity entity = source.m_7639_();
        if (!this.m_9236_().m_5776_()) {
            this.m_21839_(false);
        }
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (this.m_21824_()) {
            AttributeInstance attribute = this.m_21051_(Attributes.f_22276_);
            attribute.m_22100_(attribute.m_22135_() * (double)this.healthIncrease);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_("CollarColor", (byte)this.getCollarColor().m_41060_());
        this.m_21678_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("CollarColor", 99)) {
            this.setCollarColor(DyeColor.m_41053_((int)tag.m_128451_("CollarColor")));
        }
        this.m_147285_(this.m_9236_(), tag);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
    }

    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor color) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)color.m_41060_());
    }

    public boolean m_6898_(ItemStack item) {
        return this.isMeat(item);
    }

    protected boolean isTamingFood(ItemStack item) {
        return this.isMeat(item);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (this.m_9236_().m_5776_()) {
            return this.m_21830_((LivingEntity)player) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            InteractionResult actionresulttype;
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                this.m_5634_(item.getFoodProperties(itemstack, (LivingEntity)this).m_38744_());
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            if (item instanceof DyeItem) {
                DyeItem dyeitem = (DyeItem)item;
                if (this.m_21830_((LivingEntity)player)) {
                    DyeColor dyecolor = dyeitem.m_41089_();
                    if (dyecolor != this.getCollarColor()) {
                        this.setCollarColor(dyecolor);
                        if (!player.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return super.m_6071_(player, hand);
                }
            }
            if ((!(actionresulttype = super.m_6071_(player, hand)).m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)player)) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
        } else {
            if (this.isTamingFood(itemstack) && !this.m_21660_() && !player.m_7500_()) {
                itemstack.m_41774_(1);
                if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                    this.m_21828_(player);
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    this.m_21839_(true);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
                return InteractionResult.SUCCESS;
            }
            if (player.m_7500_()) {
                this.m_21828_(player);
            }
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_7757_(LivingEntity entity, LivingEntity entity1) {
        if (!(entity instanceof Creeper) && !(entity instanceof Ghast)) {
            if (entity instanceof EntityDivineTameable) {
                EntityDivineTameable pet = (EntityDivineTameable)entity;
                return !pet.m_21824_() || pet.m_269323_() != entity1;
            }
            if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                return false;
            }
            if (entity instanceof AbstractHorse && ((AbstractHorse)entity).m_30614_()) {
                return false;
            }
            return !(entity instanceof TamableAnimal) || !((TamableAnimal)entity).m_21824_();
        }
        return false;
    }

    public boolean m_6573_(Player player) {
        return !this.m_21660_() && super.m_6573_(player);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int p_30404_) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID p_30400_) {
        this.persistentAngerTarget = p_30400_;
    }

    public AgeableMob m_142606_(ServerLevel s, AgeableMob a) {
        return null;
    }

    public boolean m_7848_(Animal animal) {
        return false;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.m_21824_();
    }
}

