/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineFlyingMob;
import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.entities.projectile.EntityShooterBullet;
import divinerpg.enums.BulletType;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.util.WeightedRandom;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class EntityExperiencedCori
extends EntityDivineFlyingMob
implements RangedAttackMob {
    private WeightedRandom<EntityType<? extends EntityDivineMonster>> coriTypePool = new WeightedRandom();
    private ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);

    public EntityExperiencedCori(EntityType<? extends EntityDivineFlyingMob> type, Level worldIn) {
        super((EntityType<? extends EntityDivineMonster>)type, worldIn);
        this.f_21364_ = 2000;
        this.coriTypePool.addItem((EntityType<? extends EntityDivineMonster>)((EntityType)EntityRegistry.WEAK_CORI.get()), 4);
        this.coriTypePool.addItem((EntityType<? extends EntityDivineMonster>)((EntityType)EntityRegistry.ADVANCED_CORI.get()), 1);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 4.0625f;
    }

    public void m_6504_(LivingEntity entity, float range) {
        if (this.m_6084_() && this.m_5448_() != null && !this.m_9236_().f_46443_) {
            double tx = this.m_5448_().m_20185_() - this.m_20185_();
            double ty = this.m_5448_().m_20188_() - this.m_20188_();
            double tz = this.m_5448_().m_20189_() - this.m_20189_();
            EntityShooterBullet e = new EntityShooterBullet((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.SHOOTER_BULLET.get()), (LivingEntity)this, this.m_9236_(), BulletType.EXPERIENCED_CORI_SHOT);
            double horizontalDistance = Math.sqrt(tx * tx + tz * tz);
            e.m_6686_(tx, ty, tz, 1.6f, 0.0f);
            e.m_20334_(tx / horizontalDistance * (double)1.6f, ty / horizontalDistance * (double)1.6f, tz / horizontalDistance * (double)1.6f);
            this.m_9236_().m_7967_((Entity)e);
        }
    }

    public boolean m_5912_() {
        return true;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.f_21345_.m_25352_(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 40, 64.0f));
    }

    public int m_5792_() {
        return 1;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.CORI_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SoundRegistry.CORI_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.CORI_HURT.get();
    }

    public boolean m_6785_(double dist) {
        return false;
    }

    public BossEvent.BossBarColor getBarColor() {
        return BossEvent.BossBarColor.WHITE;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6451_(this.getBarColor());
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_8119_() {
        super.m_8119_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    @Override
    public void m_8024_() {
        super.m_8024_();
        if (this.m_6084_() && this.f_21363_ % (20 * (10 + this.f_19796_.m_188503_(10))) == 0) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.m_20185_() + (double)this.f_19796_.m_188503_(8), this.m_20186_(), this.m_20189_() + (double)this.f_19796_.m_188503_(8));
            EntityType<? extends EntityDivineMonster> selectedCoriType = this.coriTypePool.selectRandomItem(new Random());
            if (selectedCoriType != null) {
                selectedCoriType.m_20592_((ServerLevel)this.m_9236_(), ItemStack.f_41583_, null, (BlockPos)pos, MobSpawnType.MOB_SUMMONED, true, false);
            }
        }
    }
}

