/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.projectile.EntityShooterBullet;
import divinerpg.entities.vanilla.overworld.EntityWhale;
import divinerpg.enums.BulletType;
import divinerpg.registries.EntityRegistry;
import divinerpg.util.DamageSources;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class EntityKitra
extends EntityWhale
implements RangedAttackMob {
    private ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS);

    public EntityKitra(EntityType<? extends EntityWhale> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new RangedAttackGoal((RangedAttackMob)this, (double)0.27f, 100, 32.0f));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public BossEvent.BossBarColor getBarColor() {
        return BossEvent.BossBarColor.WHITE;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6451_(this.getBarColor());
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_6504_(LivingEntity entity, float f) {
        if (this.m_6084_() && this.m_5448_() != null && !this.m_9236_().f_46443_) {
            EntityShooterBullet e = new EntityShooterBullet((EntityType)EntityRegistry.SHOOTER_BULLET.get(), (LivingEntity)this, this.m_9236_(), BulletType.BONE_BOMB){

                @Override
                public void m_5790_(EntityHitResult result) {
                    if (!(result.m_82443_() instanceof EntityKitra)) {
                        super.m_5790_(result);
                    }
                }

                @Override
                public void m_6532_(HitResult result) {
                    super.m_6532_(result);
                    if (result.m_6662_() != HitResult.Type.MISS) {
                        for (int i = 0; i < 64; ++i) {
                            double motionX = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                            double motionY = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                            double motionZ = (this.f_19796_.m_188500_() - 0.5) * 2.0;
                            EntityShooterBullet e = new EntityShooterBullet((EntityType)EntityRegistry.SHOOTER_BULLET.get(), (LivingEntity)this.m_19749_(), this.m_9236_(), BulletType.BONE_FRAGMENT){

                                @Override
                                public void m_5790_(EntityHitResult result) {
                                    if (!(result.m_82443_() instanceof EntityKitra)) {
                                        super.m_5790_(result);
                                    }
                                }

                                @Override
                                public void m_8119_() {
                                    super.m_8119_();
                                    this.f_19794_ = this.m_20069_();
                                }
                            };
                            e.m_5602_(this.m_19749_());
                            e.m_146884_(result.m_82450_());
                            e.m_6686_(motionX, motionY, motionZ, 1.0f, 0.0f);
                            this.m_9236_().m_7967_((Entity)e);
                        }
                        this.m_6074_();
                    }
                }

                @Override
                public void m_8119_() {
                    super.m_8119_();
                    this.f_19794_ = this.m_20069_();
                    double radius = (double)this.m_20205_() * 1.5;
                    AABB aabb = new AABB(this.m_20185_() - radius, this.m_20186_() - radius, this.m_20189_() - radius, this.m_20185_() + radius, this.m_20186_() + radius, this.m_20189_() + radius);
                    BlockPos.m_121921_((AABB)aabb).forEach(blockPos -> {
                        BlockState blockState = this.m_9236_().m_8055_(blockPos);
                        if (blockState.m_204336_(BlockTags.f_13047_)) {
                            this.m_9236_().m_46961_(blockPos, true);
                        }
                    });
                }
            };
            double dx = this.m_5448_().m_20185_() - this.m_20185_();
            double dy = this.m_5448_().m_20186_() - this.m_20186_();
            double dz = this.m_5448_().m_20189_() - this.m_20189_();
            e.m_5602_((Entity)this);
            e.m_6686_(dx, dy, dz, 1.5f, 0.8f);
            e.m_6034_(this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 1.5, this.m_20182_().f_82481_);
            this.m_9236_().m_7967_((Entity)e);
            this.m_6475_(this.m_269291_().m_269425_(), 10.0f);
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            double speed = this.m_21051_(Attributes.f_22279_).m_22135_();
            double motionX = (dx /= distance) * speed;
            double motionY = (dy /= distance) * speed;
            double motionZ = (dz /= distance) * speed;
            this.m_20334_(this.m_20184_().f_82479_ + motionX, this.m_20184_().f_82480_ + motionY, this.m_20184_().f_82481_ + motionZ);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        if (!this.m_9236_().m_5776_() && this.f_19796_.m_188503_(500) == 0) {
            double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0;
            double y = this.m_20186_();
            double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0;
            BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
            BlockState state = this.m_9236_().m_8055_(pos);
            if (state.m_60819_().m_205070_(FluidTags.f_13131_)) {
                List<EntityType> fishEntities = Arrays.asList(EntityType.f_20516_, (EntityType)EntityRegistry.SHARK.get(), (EntityType)EntityRegistry.AEQUOREA.get(), EntityType.f_147034_);
                EntityType randomFishEntity = fishEntities.get(this.m_9236_().m_213780_().m_188503_(fishEntities.size()));
                if (this.m_9236_().m_45772_(randomFishEntity.m_20585_(x, y, z).m_82406_(0.0625))) {
                    randomFishEntity.m_262496_((ServerLevel)this.m_9236_(), pos, MobSpawnType.REINFORCEMENT);
                }
            } else if (state.m_60795_() && this.m_9236_().m_45772_(((EntityType)EntityRegistry.ALICANTO.get()).m_20585_(x, y, z))) {
                ((EntityType)EntityRegistry.ALICANTO.get()).m_262496_((ServerLevel)this.m_9236_(), pos, MobSpawnType.REINFORCEMENT);
            }
        }
        for (Player player : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(16.0))) {
            if (player.m_5833_() || player.m_7500_() || !player.m_6084_() || this.f_19796_.m_188503_(500) != 0) continue;
            player.m_7292_(this.getRandomNegativeEffect());
        }
        for (Boat boat : this.m_9236_().m_45976_(Boat.class, this.m_20191_().m_82400_(4.0))) {
            boat.m_6469_(this.m_269291_().m_269264_(), 100.0f);
        }
        if (this.m_6084_()) {
            AABB box = this.m_20191_().m_82400_(1.5);
            BlockPos.m_121990_((BlockPos)new BlockPos((int)box.f_82288_, (int)box.f_82289_, (int)box.f_82290_), (BlockPos)new BlockPos((int)box.f_82291_, (int)box.f_82292_, (int)box.f_82293_)).forEach(blockPos -> {
                BlockState state = this.m_9236_().m_8055_(blockPos);
                if (state.m_204336_(BlockTags.f_13047_)) {
                    if (blockPos.m_123342_() == this.m_9236_().m_5736_()) {
                        this.m_9236_().m_46597_(blockPos, Blocks.f_49990_.m_49966_());
                    } else {
                        this.m_9236_().m_46961_(blockPos, false);
                    }
                    this.m_5496_(SoundEvents.f_11983_, 1.0f, 1.0f);
                }
            });
        }
    }

    private MobEffectInstance getRandomNegativeEffect() {
        List<MobEffect> negativeEffects = Arrays.asList(MobEffects.f_19610_, MobEffects.f_19612_, MobEffects.f_19614_, MobEffects.f_19615_, MobEffects.f_19594_, MobEffects.f_19604_, MobEffects.f_19599_, MobEffects.f_19613_, MobEffects.f_19590_);
        MobEffect negativeEffect = negativeEffects.get(this.f_19796_.m_188503_(negativeEffects.size()));
        int duration = 20 * (this.f_19796_.m_188503_(60) + 30);
        int amplifier = this.f_19796_.m_188503_(2);
        return new MobEffectInstance(negativeEffect, duration, amplifier);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268515_) || source == DamageSources.source(this.m_9236_(), DamageSources.ARCANA) || source.m_276093_(DamageTypes.f_268724_) || source.m_276093_(DamageTypes.f_268565_) || source.m_276093_(DamageTypes.f_268450_) || source.m_276093_(DamageTypes.f_268482_) || source.m_276093_(DamageTypes.f_268530_) || source.m_276093_(DamageTypes.f_268493_)) {
            return super.m_6469_(source, amount);
        }
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }
}

