/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.boss;

import divinerpg.entities.base.EntityDivineFlyingMob;
import divinerpg.entities.projectile.EntityShooterBullet;
import divinerpg.enums.BulletType;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.SoundRegistry;
import java.util.EnumSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityTheWatcher
extends EntityDivineFlyingMob
implements RangedAttackMob {
    private ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(EntityTheWatcher.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int explosionStrength = 1;

    public EntityTheWatcher(EntityType<? extends EntityDivineFlyingMob> type, Level worldIn) {
        super(type, worldIn, 6.0f, 10.0f, 25.0f);
        this.f_21364_ = 5000;
        this.f_21342_ = new MoveHelperController(this);
    }

    public boolean m_5825_() {
        return true;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 3.0f;
    }

    public boolean canSpawn(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return this.m_9236_().m_46472_() == Level.f_46428_;
    }

    @Override
    protected void m_8099_() {
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 40, 20.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomFlyGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new LookAroundGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new FireballAttackGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, p_213812_1_ -> Math.abs(p_213812_1_.m_20186_() - this.m_20186_()) <= 4.0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public int getFireballStrength() {
        return this.explosionStrength;
    }

    protected boolean isDespawnPeaceful() {
        return true;
    }

    public void m_6504_(LivingEntity entity, float range) {
        if (this.m_6084_() && this.m_5448_() != null) {
            EntityShooterBullet projectile = new EntityShooterBullet((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.SHOOTER_BULLET.get()), (LivingEntity)this, this.m_9236_(), BulletType.THE_WATCHER_SHOT);
            double d0 = this.m_5448_().m_20185_() - this.m_20185_();
            double d1 = this.m_5448_().m_20227_(0.3333333333333333) - projectile.m_20186_();
            double d2 = this.m_5448_().m_20189_() - this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            projectile.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.m_9236_().m_46791_().m_19028_() * 4);
            this.m_9236_().m_7967_((Entity)projectile);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_7639_() instanceof LargeFireball && source.m_7640_() instanceof Player) {
            super.m_6469_(source, 1000.0f);
            return true;
        }
        return super.m_6469_(source, amount);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)SoundRegistry.GROWL_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.GROWL_HURT.get();
    }

    protected float m_6121_() {
        return 5.0f;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("ExplosionPower", this.explosionStrength);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("ExplosionPower", 99)) {
            this.explosionStrength = compound.m_128451_("ExplosionPower");
        }
    }

    public BossEvent.BossBarColor getBarColor() {
        return BossEvent.BossBarColor.YELLOW;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6451_(this.getBarColor());
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_8119_() {
        super.m_8119_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    static class MoveHelperController
    extends MoveControl {
        private final EntityTheWatcher mob;
        private int floatDuration;

        public MoveHelperController(EntityTheWatcher ent) {
            super((Mob)ent);
            this.mob = ent;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.mob.m_217043_().m_188503_(5) + 2;
                Vec3 vector3d = new Vec3(this.f_24975_ - this.mob.m_20185_(), this.f_24976_ - this.mob.m_20186_(), this.f_24977_ - this.mob.m_20189_());
                double d0 = vector3d.m_82553_();
                if (this.canReach(vector3d = vector3d.m_82541_(), (int)Math.ceil(d0))) {
                    this.mob.m_20256_(this.mob.m_20184_().m_82549_(vector3d.m_82490_(0.1)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3 vec, int ticks) {
            AABB axisalignedbb = this.mob.m_20191_();
            for (int i = 1; i < ticks; ++i) {
                axisalignedbb = axisalignedbb.m_82383_(vec);
                if (this.mob.m_9236_().m_45756_((Entity)this.mob, axisalignedbb)) continue;
                return false;
            }
            return true;
        }
    }

    static class RandomFlyGoal
    extends Goal {
        private final EntityTheWatcher mob;

        public RandomFlyGoal(EntityTheWatcher entity) {
            this.mob = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            MoveControl movementcontroller = this.mob.m_21566_();
            if (!movementcontroller.m_24995_()) {
                return true;
            }
            double d0 = movementcontroller.m_25000_() - this.mob.m_20185_();
            double d3 = d0 * d0 + (d1 = movementcontroller.m_25001_() - this.mob.m_20186_()) * d1 + (d2 = movementcontroller.m_25002_() - this.mob.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource random = this.mob.m_217043_();
            double d0 = this.mob.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.mob.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.mob.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            this.mob.m_21566_().m_6849_(d0, d1, d2, 1.0);
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final EntityTheWatcher mob;

        public LookAroundGoal(EntityTheWatcher ent) {
            this.mob = ent;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.mob.m_5448_() == null) {
                Vec3 vector3d = this.mob.m_20184_();
                this.mob.f_20883_ = this.mob.f_19857_ = -((float)Math.atan2(vector3d.f_82479_, vector3d.f_82481_)) * 57.295776f;
            } else {
                LivingEntity livingentity = this.mob.m_5448_();
                if (livingentity.m_20280_((Entity)this.mob) < 4096.0) {
                    double d1 = livingentity.m_20185_() - this.mob.m_20185_();
                    double d2 = livingentity.m_20189_() - this.mob.m_20189_();
                    this.mob.f_20883_ = this.mob.f_19857_ = -((float)Math.atan2(d1, d2)) * 57.295776f;
                }
            }
        }
    }

    static class FireballAttackGoal
    extends Goal {
        private final EntityTheWatcher mob;
        public int chargeTime;

        public FireballAttackGoal(EntityTheWatcher ent) {
            this.mob = ent;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null;
        }

        public void m_8056_() {
            this.chargeTime = 0;
        }

        public void m_8041_() {
            this.mob.setAttacking(false);
        }

        public void m_8037_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity.m_20280_((Entity)this.mob) < 4096.0 && this.mob.m_142582_((Entity)livingentity)) {
                Level world = this.mob.m_9236_();
                ++this.chargeTime;
                if (this.chargeTime == 10 && !this.mob.m_20067_()) {
                    world.m_5898_(null, 1015, this.mob.m_20183_(), 0);
                }
                if (this.chargeTime == 20) {
                    Vec3 vector3d = this.mob.m_20252_(1.0f);
                    double d2 = livingentity.m_20185_() - (this.mob.m_20185_() + vector3d.f_82479_ * 4.0);
                    double d3 = livingentity.m_20227_(0.5) - (0.5 + this.mob.m_20227_(0.5));
                    double d4 = livingentity.m_20189_() - (this.mob.m_20189_() + vector3d.f_82481_ * 4.0);
                    if (!this.mob.m_20067_()) {
                        world.m_5898_(null, 1016, this.mob.m_20183_(), 0);
                    }
                    EntityShooterBullet shot = new EntityShooterBullet((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.SHOOTER_BULLET.get()), livingentity, world, BulletType.THE_WATCHER_SHOT);
                    shot.m_6686_(d2, d3, d4, 1.0f, 1.0f);
                    shot.m_6034_(this.mob.m_20185_() + vector3d.f_82479_ * 4.0, this.mob.m_20227_(0.5) + 0.5, shot.m_20189_() + vector3d.f_82481_ * 4.0);
                    world.m_7967_((Entity)shot);
                    this.chargeTime = -40;
                }
            } else if (this.chargeTime > 0) {
                --this.chargeTime;
            }
            this.mob.setAttacking(this.chargeTime > 10);
        }
    }
}

