/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.iceika;

import divinerpg.entities.ai.FactionTargetGoal;
import divinerpg.entities.base.EntityDivineMerchant;
import divinerpg.entities.base.FactionEntity;
import divinerpg.registries.ItemRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public abstract class EntityIceikaNPC
extends EntityDivineMerchant
implements FactionEntity {
    public static final TagKey<Structure> WHALE_SKULL = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("divinerpg", "whale_skull"));
    protected static final EntityDataAccessor<Integer> ITEM = SynchedEntityData.m_135353_(EntityIceikaNPC.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected boolean important = false;

    public static Item getItem(int i) {
        return switch (i) {
            case 1 -> (Item)ItemRegistry.oxdrite_pickaxe.get();
            case 2 -> (Item)ItemRegistry.icicle_bane.get();
            case 3 -> (Item)ItemRegistry.icicle_bow.get();
            case 4 -> (Item)ItemRegistry.frozen_maul.get();
            case 5 -> (Item)ItemRegistry.frost_sword.get();
            case 6 -> (Item)ItemRegistry.frostking_sword.get();
            case 7 -> (Item)ItemRegistry.frost_cannon.get();
            case 8 -> (Item)ItemRegistry.fractite_cannon.get();
            case 9 -> (Item)ItemRegistry.glacier_sword.get();
            case 10 -> (Item)ItemRegistry.serenade_of_ice.get();
            case 11 -> (Item)ItemRegistry.sabear_sabre.get();
            case 12 -> (Item)ItemRegistry.blue_armor_pouch.get();
            default -> null;
        };
    }

    public EntityIceikaNPC(EntityType<? extends EntityDivineMerchant> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
    }

    protected abstract TagKey<Structure> getRaidTargets();

    protected abstract MobEffect getTargetEffect();

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        if (!(this instanceof RangedAttackMob)) {
            this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        }
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, new FactionTargetGoal((Mob)this, this.getFaction(), true, !(this instanceof RangedAttackMob)));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected PathNavigation m_6037_(Level level) {
        GroundPathNavigation nav = new GroundPathNavigation((Mob)this, level);
        nav.m_26477_(true);
        nav.m_148214_(true);
        return nav;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ITEM, (Object)0);
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        super.m_213945_(random, difficulty);
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)EntityIceikaNPC.getItem((Integer)this.f_19804_.m_135370_(ITEM))));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        RandomSource random = level.m_213780_();
        this.m_213945_(random, difficulty);
        this.m_213946_(random, difficulty);
        return data;
    }

    public void setUnimportant() {
        this.important = false;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.getFaction().getReputation(player) > 5) {
            return super.m_6071_(player, hand);
        }
        this.m_216990_(SoundEvents.f_12507_);
        return InteractionResult.FAIL;
    }

    public void m_6667_(DamageSource source) {
        this.modifyReputationOnDeath(source);
        super.m_6667_(source);
    }

    @Override
    public void modifyReputationOnDeath(DamageSource source) {
        if (this.important && this.m_9236_() instanceof ServerLevel) {
            LivingEntity entity;
            Entity entity2;
            if (source.m_7640_() != null && (entity2 = source.m_7640_()) instanceof LivingEntity) {
                entity = (LivingEntity)entity2;
                entity.m_7292_(new MobEffectInstance(this.getTargetEffect(), -1, 0, false, false, true));
            }
            if (source.m_7639_() != null && (entity2 = source.m_7639_()) instanceof LivingEntity) {
                entity = (LivingEntity)entity2;
                entity.m_7292_(new MobEffectInstance(this.getTargetEffect(), -1, 0, false, false, true));
            }
        }
        FactionEntity.super.modifyReputationOnDeath(source);
    }

    @Override
    public boolean m_6469_(DamageSource source, float f) {
        this.modifyReputationOnHurt(source, f);
        return super.m_6469_(source, f);
    }

    protected boolean m_8028_() {
        return false;
    }

    @Override
    public boolean m_6785_(double d) {
        return false;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Important")) {
            this.important = tag.m_128471_("Important");
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Important", this.important);
    }

    @Override
    public String[] getChatMessages() {
        return new String[0];
    }

    @Override
    protected void m_8058_(MerchantOffer offer) {
        super.m_8058_(offer);
        Player player = this.m_7962_();
        if (player != null && offer.m_45383_()) {
            this.getFaction().modifyReputation(player, 1);
        }
    }
}

