/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.iceika;

import divinerpg.block_entities.block.RobbinHutBlockEntity;
import divinerpg.block_entities.block.RobbinNestBlockEntity;
import divinerpg.blocks.iceika.BlockRobbinHut;
import divinerpg.entities.base.EntityDivineFlyingMob;
import divinerpg.entities.base.EntityDivineMonster;
import divinerpg.entities.boss.EntityKitra;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.util.Utils;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityRobbin
extends EntityDivineFlyingMob {
    private int tiredTicks = 0;
    public boolean wantsNest = false;
    private static final EntityDataAccessor<Integer> ITEM = SynchedEntityData.m_135353_(EntityRobbin.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public ItemStack mouthPiece = ItemStack.f_41583_;

    public EntityRobbin(EntityType<? extends EntityDivineFlyingMob> entityType, Level world) {
        super((EntityType<? extends EntityDivineMonster>)entityType, world);
        this.f_21342_ = new RobbinMoveControl(this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ITEM, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("MouthPiece", (Tag)this.mouthPiece.m_41739_(new CompoundTag()));
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("MouthPiece")) {
            this.setMouthPiece(ItemStack.m_41712_((CompoundTag)tag.m_128469_("MouthPiece")));
        }
    }

    public int getItemID() {
        return (Integer)this.f_19804_.m_135370_(ITEM);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new FollowWhaleGoal());
        this.f_21345_.m_25352_(2, (Goal)new GoalRideWhaleWhenTired());
        this.f_21345_.m_25352_(6, (Goal)new RobbinRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, EntityKitra.class, 6.0f));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.46f;
    }

    public boolean m_7296_(int i) {
        return i > 6;
    }

    public boolean isTired() {
        return this.tiredTicks > 1200;
    }

    public void setMouthPiece(ItemStack item) {
        if (item == null) {
            item = ItemStack.f_41583_;
        }
        this.mouthPiece = item;
        this.f_19804_.m_135381_(ITEM, (Object)Item.m_41393_((Item)item.m_41720_()));
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        if (!this.mouthPiece.m_41619_()) {
            this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.mouthPiece));
        }
    }

    protected float m_6118_() {
        return 0.22f * this.m_20098_() + this.m_285755_();
    }

    @Override
    public void reachTarget() {
        BlockEntity block2;
        Path path = this.m_21573_().m_26570_();
        BlockPos targetPos = path.m_77406_();
        BlockState target = this.m_9236_().m_8055_(targetPos);
        if (target.m_60713_((Block)BlockRegistry.robbinHut.get()) && BlockRobbinHut.hasSpace((ServerLevel)this.m_9236_(), targetPos)) {
            RobbinHutBlockEntity block2 = (RobbinHutBlockEntity)this.m_9236_().m_7702_(targetPos);
            CompoundTag tag = new CompoundTag();
            this.m_20223_(tag);
            if (block2.robbin1 == null) {
                block2.robbin1 = tag;
            } else {
                block2.robbin2 = tag;
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else if (target.m_60713_((Block)BlockRegistry.robbinNest.get()) && (block2 = this.m_9236_().m_7702_(targetPos)) instanceof RobbinNestBlockEntity) {
            RobbinNestBlockEntity nest = (RobbinNestBlockEntity)block2;
            if (this.wantsNest && !nest.getItem().m_150930_((Item)ItemRegistry.robbin_egg.get())) {
                if (!nest.m_7983_()) {
                    this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), (double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.1, (double)targetPos.m_123343_() + 0.5, nest.getItem()));
                }
                nest.setItem(((Item)ItemRegistry.robbin_egg.get()).m_7968_());
                this.m_9236_().m_245803_((Entity)this, targetPos, SoundEvents.f_11695_, SoundSource.NEUTRAL, 0.5f, 1.5f);
            } else if (nest.m_7983_() && !this.mouthPiece.m_41619_()) {
                nest.setItem(this.mouthPiece);
                this.m_9236_().m_245803_((Entity)this, targetPos, SoundEvents.f_11695_, SoundSource.NEUTRAL, 0.5f, 1.5f);
                this.setMouthPiece(ItemStack.f_41583_);
            }
        } else {
            List items = this.m_9236_().m_45976_(ItemEntity.class, new AABB(targetPos.m_7918_(-1, -1, -1), targetPos.m_7918_(1, 1, 1)));
            if (items.size() > 0) {
                this.setMouthPiece(((ItemEntity)items.get(0)).m_32055_());
                this.m_9236_().m_245803_((Entity)this, targetPos, SoundEvents.f_12019_, SoundSource.NEUTRAL, 0.5f, 1.0f);
                ((ItemEntity)items.get(0)).m_146870_();
            }
        }
    }

    @Override
    protected void m_8024_() {
        Path path = this.m_21573_().m_26570_();
        if (path == null && this.tiredTicks % 10 == 0) {
            if (this.isTired()) {
                EntityKitra nearbyWhale = (EntityKitra)this.m_9236_().m_45963_(EntityKitra.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20191_().m_82400_(32.0));
                if (nearbyWhale == null) {
                    BlockPos pos;
                    int z;
                    int y;
                    int x;
                    for (x = this.m_20183_().m_123341_() - 5; x < this.m_20183_().m_123341_() + 5; ++x) {
                        for (y = this.m_20183_().m_123342_() - 5; y < this.m_20183_().m_123342_() + 5; ++y) {
                            for (z = this.m_20183_().m_123343_() - 5; z < this.m_20183_().m_123343_() + 5; ++z) {
                                pos = new BlockPos(x, y, z);
                                if (this.m_9236_().m_151570_(pos) || !this.m_9236_().m_8055_(pos).m_60713_((Block)BlockRegistry.robbinHut.get())) continue;
                                this.m_21573_().m_26519_((double)x, (double)y, (double)z, 1.0);
                                return;
                            }
                        }
                    }
                    for (x = this.m_20183_().m_123341_() - 5; x < this.m_20183_().m_123341_() + 5; ++x) {
                        for (y = this.m_20183_().m_123342_() - 5; y < this.m_20183_().m_123342_() + 5; ++y) {
                            for (z = this.m_20183_().m_123343_() - 5; z < this.m_20183_().m_123343_() + 5; ++z) {
                                pos = new BlockPos(x, y, z);
                                if (this.m_9236_().m_151570_(pos) || !this.m_9236_().m_8055_(pos).m_60783_((BlockGetter)this.m_9236_(), pos, Direction.UP)) continue;
                                BlockPos.MutableBlockPos mut = pos.m_122032_();
                                while (this.m_9236_().m_151570_((BlockPos)mut.m_122173_(Direction.UP)) || this.m_9236_().m_8055_((BlockPos)mut).m_60783_((BlockGetter)this.m_9236_(), pos, Direction.UP) && ++y < this.m_20183_().m_123342_() + 7) {
                                }
                                this.m_21573_().m_26519_((double)x, (double)y, (double)z, 1.0);
                                return;
                            }
                        }
                    }
                } else {
                    this.pathfindPos = nearbyWhale.m_20182_();
                }
            } else if (this.wantsNest || !this.mouthPiece.m_41619_()) {
                for (int x = this.m_20183_().m_123341_() - 5; x < this.m_20183_().m_123341_() + 5; ++x) {
                    for (int y = this.m_20183_().m_123342_() - 5; y < this.m_20183_().m_123342_() + 5; ++y) {
                        for (int z = this.m_20183_().m_123343_() - 5; z < this.m_20183_().m_123343_() + 5; ++z) {
                            RobbinNestBlockEntity nest;
                            BlockEntity blockEntity;
                            BlockPos pos = new BlockPos(x, y, z);
                            if (this.m_9236_().m_151570_(pos) || !this.m_9236_().m_8055_(pos).m_60713_((Block)BlockRegistry.robbinNest.get()) || !((blockEntity = this.m_9236_().m_7702_(pos)) instanceof RobbinNestBlockEntity) || !(nest = (RobbinNestBlockEntity)blockEntity).m_7983_() && (!this.wantsNest || nest.getItem().m_150930_((Item)ItemRegistry.robbin_egg.get()))) continue;
                            this.m_21573_().m_26519_((double)x, (double)y, (double)z, 1.0);
                        }
                    }
                }
            } else {
                List items = this.m_9236_().m_6249_((Entity)this, new AABB(this.m_20183_().m_7918_(-5, -5, -5), this.m_20183_().m_7918_(5, 5, 5)), entity -> entity instanceof ItemEntity);
                if (items.size() > 0) {
                    ItemEntity nearest = (ItemEntity)items.get(0);
                    for (Entity e : items) {
                        if (!(this.m_20270_(e) < this.m_20270_((Entity)nearest))) continue;
                        nearest = (ItemEntity)e;
                    }
                    this.m_21573_().m_5624_((Entity)nearest, 1.0);
                }
            }
        }
        if (this.m_20068_()) {
            ++this.tiredTicks;
            super.m_8024_();
            if (this.m_20096_()) {
                this.m_20242_(false);
                return;
            }
        } else if (this.tiredTicks > 0) {
            --this.tiredTicks;
        } else if (this.f_19796_.m_188499_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.2, 0.0));
            this.m_20242_(true);
        }
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return this.mouthPiece.m_41619_();
    }

    static class RobbinMoveControl
    extends MoveControl {
        private int jumpDelay;

        RobbinMoveControl(EntityRobbin entity) {
            super((Mob)entity);
        }

        void setWantedMovement(double speedModifier) {
            this.f_24978_ = speedModifier;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.f_24974_.m_20096_()) {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.f_24974_.f_19796_.m_188503_(10) + 1;
                        this.f_24974_.m_21569_().m_24901_();
                    } else {
                        this.f_24974_.f_20900_ = 0.0f;
                        this.f_24974_.f_20902_ = 0.0f;
                        this.f_24974_.m_7910_(0.0f);
                    }
                } else {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                }
            }
        }
    }

    class FollowWhaleGoal
    extends Goal {
        private static final double FOLLOW_DISTANCE = 32.0;
        private static final double CIRCLE_RADIUS = 5.0;
        private EntityKitra targetWhale;

        FollowWhaleGoal() {
        }

        public boolean m_8036_() {
            if (this.targetWhale == null || !this.targetWhale.m_6084_()) {
                this.targetWhale = (EntityKitra)EntityRobbin.this.m_9236_().m_45963_(EntityKitra.class, TargetingConditions.f_26872_, (LivingEntity)EntityRobbin.this, EntityRobbin.this.m_20185_(), EntityRobbin.this.m_20186_(), EntityRobbin.this.m_20189_(), EntityRobbin.this.m_20191_().m_82400_(32.0));
            }
            return this.targetWhale != null;
        }

        public void m_8056_() {
            EntityRobbin.this.m_21573_().m_26573_();
        }

        public void m_8037_() {
            double distanceToWhale = EntityRobbin.this.m_20270_((Entity)this.targetWhale);
            if (distanceToWhale <= 32.0) {
                double angleToWhale = Math.atan2(this.targetWhale.m_20189_() - EntityRobbin.this.m_20189_(), this.targetWhale.m_20185_() - EntityRobbin.this.m_20185_());
                EntityRobbin.this.pathfindPos = new Vec3(this.targetWhale.m_20185_() + 5.0 * Math.cos(angleToWhale), this.targetWhale.m_20186_() + 5.0, this.targetWhale.m_20189_() + 5.0 * Math.sin(angleToWhale));
            } else {
                EntityRobbin.this.pathfindPos = this.targetWhale.m_20182_();
            }
        }

        public void m_8041_() {
            EntityRobbin.this.m_21573_().m_26573_();
        }
    }

    public class GoalRideWhaleWhenTired
    extends Goal {
        private EntityKitra whale;
        private int rideTime;

        public GoalRideWhaleWhenTired() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (EntityRobbin.this.isTired()) {
                this.whale = (EntityKitra)EntityRobbin.this.m_9236_().m_45963_(EntityKitra.class, TargetingConditions.f_26872_, (LivingEntity)EntityRobbin.this, EntityRobbin.this.m_20185_(), EntityRobbin.this.m_20186_(), EntityRobbin.this.m_20189_(), EntityRobbin.this.m_20191_().m_82400_(16.0));
                return this.whale != null && EntityRobbin.this.m_20270_((Entity)this.whale) < 3.0f && this.whale.m_20197_().size() == 0;
            }
            return false;
        }

        public void m_8056_() {
            EntityRobbin.this.m_20329_((Entity)this.whale);
            this.rideTime = 0;
        }

        public void m_8041_() {
            EntityRobbin.this.m_8127_();
            this.whale = null;
            this.rideTime = 0;
        }

        public boolean m_8045_() {
            return EntityRobbin.this.isTired() && this.whale != null && !this.whale.m_20069_() && this.rideTime < 200;
        }

        public void m_8037_() {
            ++this.rideTime;
            if (EntityRobbin.this.m_20069_()) {
                this.m_8041_();
            }
        }
    }

    class RobbinRandomStrollGoal
    extends WaterAvoidingRandomStrollGoal {
        public RobbinRandomStrollGoal(PathfinderMob mob, double speedModifier) {
            super(mob, speedModifier);
        }

        public boolean m_8036_() {
            return !EntityRobbin.this.m_20068_() && EntityRobbin.this.m_21573_().m_26570_() == null && super.m_8036_();
        }

        public boolean m_8045_() {
            return !EntityRobbin.this.m_20068_() && super.m_8045_();
        }

        public void m_8037_() {
            super.m_8037_();
            Path path = EntityRobbin.this.m_21573_().m_26570_();
            if (path != null) {
                double distanceX = (double)path.m_77400_().m_123341_() - EntityRobbin.this.m_20185_();
                double distanceZ = (double)path.m_77400_().m_123343_() - EntityRobbin.this.m_20189_();
                EntityRobbin.this.f_19857_ = Utils.rotlerp(EntityRobbin.this.f_19857_, (float)(Mth.m_14136_((double)distanceZ, (double)distanceX) * 180.0 / Math.PI) - 90.0f, 90.0f);
            }
        }
    }
}

