/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.iceika;

import com.mojang.serialization.Codec;
import divinerpg.entities.base.EntityDivineMonster;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarrotBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityWolpertinger
extends EntityDivineMonster {
    private int jumpTicks;
    private int jumpDuration;
    private int jumpDelayTicks;
    private boolean wasOnGround;

    public EntityWolpertinger(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.f_21343_ = new WolpertingerJumpControl(this);
        this.f_21342_ = new WolpertingerMoveControl(this);
        this.setSpeedModifier(0.0);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.75f;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.m_9236_()));
        this.f_21345_.m_25352_(1, (Goal)new WolpertingerPanicGoal(this, 2.2));
        this.f_21345_.m_25352_(4, new WolpertingerAvoidEntityGoal<Player>(this, Player.class, 8.0f, 2.2, 2.2));
        this.f_21345_.m_25352_(4, new WolpertingerAvoidEntityGoal<Wolf>(this, Wolf.class, 10.0f, 2.2, 2.2));
        this.f_21345_.m_25352_(4, new WolpertingerAvoidEntityGoal<Monster>(this, Monster.class, 4.0f, 2.2, 2.2));
        this.f_21345_.m_25352_(5, (Goal)new RaidGardenGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
    }

    protected float m_6118_() {
        if (!(this.f_19862_ || this.f_21342_.m_24995_() && this.f_21342_.m_25001_() > this.m_20186_() + 0.5)) {
            Path path = this.f_21344_.m_26570_();
            if (path != null && !path.m_77392_()) {
                Vec3 vec3 = path.m_77380_((Entity)this);
                if (vec3.f_82480_ > this.m_20186_() + 0.5) {
                    return 0.5f;
                }
            }
            return this.f_21342_.m_24999_() <= 0.6 ? 0.2f : 0.3f;
        }
        return 0.5f;
    }

    protected void m_6135_() {
        double d1;
        super.m_6135_();
        double d0 = this.f_21342_.m_24999_();
        if (d0 > 0.0 && (d1 = this.m_20184_().m_165925_()) < 0.01) {
            this.m_19920_(0.1f, new Vec3(0.0, 0.0, 1.0));
        }
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)1);
        }
    }

    public float getJumpCompletion(float p_29736_) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + p_29736_) / (float)this.jumpDuration;
    }

    public void setSpeedModifier(double p_29726_) {
        this.m_21573_().m_26517_(p_29726_);
        this.f_21342_.m_6849_(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_(), p_29726_);
    }

    public void m_6862_(boolean p_29732_) {
        super.m_6862_(p_29732_);
        if (p_29732_) {
            this.m_5496_(this.getJumpSound(), this.m_6121_(), ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void startJumping() {
        this.m_6862_(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    public void m_8024_() {
        if (this.jumpDelayTicks > 0) {
            --this.jumpDelayTicks;
        }
        if (this.m_20096_()) {
            WolpertingerJumpControl Wolpertinger$Wolpertingerjumpcontrol;
            if (!this.wasOnGround) {
                this.m_6862_(false);
                this.checkLandingDelay();
            }
            if (!(Wolpertinger$Wolpertingerjumpcontrol = (WolpertingerJumpControl)this.f_21343_).wantJump()) {
                if (this.f_21342_.m_24995_() && this.jumpDelayTicks == 0) {
                    Path path = this.f_21344_.m_26570_();
                    Vec3 vec3 = new Vec3(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_());
                    if (path != null && !path.m_77392_()) {
                        vec3 = path.m_77380_((Entity)this);
                    }
                    this.facePoint(vec3.f_82479_, vec3.f_82481_);
                    this.startJumping();
                }
            } else if (!Wolpertinger$Wolpertingerjumpcontrol.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.m_20096_();
    }

    public boolean m_5843_() {
        return false;
    }

    private void facePoint(double p_29687_, double p_29688_) {
        this.m_146922_((float)(Mth.m_14136_((double)(p_29688_ - this.m_20189_()), (double)(p_29687_ - this.m_20185_())) * 57.2957763671875) - 90.0f);
    }

    private void enableJumpControl() {
        ((WolpertingerJumpControl)this.f_21343_).setCanJump(true);
    }

    private void disableJumpControl() {
        ((WolpertingerJumpControl)this.f_21343_).setCanJump(false);
    }

    private void setLandingDelay() {
        this.jumpDelayTicks = this.f_21342_.m_24999_() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.setLandingDelay();
        this.disableJumpControl();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.m_6862_(false);
        }
    }

    public void m_7380_(CompoundTag p_29697_) {
        super.m_7380_(p_29697_);
    }

    public void m_7378_(CompoundTag p_29684_) {
        super.m_7378_(p_29684_);
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.f_12354_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12297_;
    }

    protected SoundEvent m_7975_(DamageSource p_29715_) {
        return SoundEvents.f_12353_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12352_;
    }

    public boolean m_7327_(Entity p_29659_) {
        return p_29659_.m_6469_(p_29659_.m_9236_().m_269111_().m_269333_((LivingEntity)this), 3.0f);
    }

    public SoundSource m_5720_() {
        return SoundSource.NEUTRAL;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance instance, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        Variant Wolpertinger$variant = EntityWolpertinger.getRandomWolpertingerVariant((LevelAccessor)level, this.m_20183_());
        data = new WolpertingerGroupData(Wolpertinger$variant);
        return data;
    }

    private static Variant getRandomWolpertingerVariant(LevelAccessor p_262699_, BlockPos p_262700_) {
        int i = p_262699_.m_213780_().m_188503_(100);
        return i < 50 ? Variant.BROWN : (i < 90 ? Variant.SALT : Variant.BLACK);
    }

    public void m_7822_(byte p_29663_) {
        if (p_29663_ == 1) {
            this.m_20076_();
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.m_7822_(p_29663_);
        }
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public static class WolpertingerJumpControl
    extends JumpControl {
        private final EntityWolpertinger Wolpertinger;
        private boolean canJump;

        public WolpertingerJumpControl(EntityWolpertinger p_186229_) {
            super((Mob)p_186229_);
            this.Wolpertinger = p_186229_;
        }

        public boolean wantJump() {
            return this.f_24897_;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean p_29759_) {
            this.canJump = p_29759_;
        }

        public void m_8124_() {
            if (this.f_24897_) {
                this.Wolpertinger.startJumping();
                this.f_24897_ = false;
            }
        }
    }

    static class WolpertingerMoveControl
    extends MoveControl {
        private final EntityWolpertinger Wolpertinger;
        private double nextJumpSpeed;

        public WolpertingerMoveControl(EntityWolpertinger p_29766_) {
            super((Mob)p_29766_);
            this.Wolpertinger = p_29766_;
        }

        public void m_8126_() {
            if (this.Wolpertinger.m_20096_() && !this.Wolpertinger.f_20899_ && !((WolpertingerJumpControl)this.Wolpertinger.f_21343_).wantJump()) {
                this.Wolpertinger.setSpeedModifier(0.0);
            } else if (this.m_24995_()) {
                this.Wolpertinger.setSpeedModifier(this.nextJumpSpeed);
            }
            super.m_8126_();
        }

        public void m_6849_(double p_29769_, double p_29770_, double p_29771_, double p_29772_) {
            if (this.Wolpertinger.m_20069_()) {
                p_29772_ = 1.5;
            }
            super.m_6849_(p_29769_, p_29770_, p_29771_, p_29772_);
            if (p_29772_ > 0.0) {
                this.nextJumpSpeed = p_29772_;
            }
        }
    }

    static class WolpertingerPanicGoal
    extends PanicGoal {
        private final EntityWolpertinger Wolpertinger;

        public WolpertingerPanicGoal(EntityWolpertinger p_29775_, double p_29776_) {
            super((PathfinderMob)p_29775_, p_29776_);
            this.Wolpertinger = p_29775_;
        }

        public void m_8037_() {
            super.m_8037_();
            this.Wolpertinger.setSpeedModifier(this.f_25685_);
        }
    }

    static class WolpertingerAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        public WolpertingerAvoidEntityGoal(EntityWolpertinger p_29743_, Class<T> p_29744_, float p_29745_, double p_29746_, double p_29747_) {
            super((PathfinderMob)p_29743_, p_29744_, p_29745_, p_29746_, p_29747_);
        }

        public boolean m_8036_() {
            return super.m_8036_();
        }
    }

    static class RaidGardenGoal
    extends MoveToBlockGoal {
        private final EntityWolpertinger Wolpertinger;
        private boolean wantsToRaid;
        private boolean canRaid;

        public RaidGardenGoal(EntityWolpertinger p_29782_) {
            super((PathfinderMob)p_29782_, (double)0.7f, 16);
            this.Wolpertinger = p_29782_;
        }

        public boolean m_8036_() {
            if (this.f_25600_ <= 0) {
                if (!ForgeEventFactory.getMobGriefingEvent((Level)this.Wolpertinger.m_9236_(), (Entity)this.Wolpertinger)) {
                    return false;
                }
                this.canRaid = false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            return this.canRaid && super.m_8045_();
        }

        public void m_8037_() {
            super.m_8037_();
            this.Wolpertinger.m_21563_().m_24950_((double)this.f_25602_.m_123341_() + 0.5, (double)(this.f_25602_.m_123342_() + 1), (double)this.f_25602_.m_123343_() + 0.5, 10.0f, (float)this.Wolpertinger.m_8132_());
            if (this.m_25625_()) {
                Level level = this.Wolpertinger.m_9236_();
                BlockPos blockpos = this.f_25602_.m_7494_();
                BlockState blockstate = level.m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (this.canRaid && block instanceof CarrotBlock) {
                    int i = (Integer)blockstate.m_61143_((Property)CarrotBlock.f_52244_);
                    if (i == 0) {
                        level.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 2);
                        level.m_46953_(blockpos, true, (Entity)this.Wolpertinger);
                    } else {
                        level.m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)CarrotBlock.f_52244_, (Comparable)Integer.valueOf(i - 1)), 2);
                        level.m_46796_(2001, blockpos, Block.m_49956_((BlockState)blockstate));
                    }
                }
                this.canRaid = false;
                this.f_25600_ = 10;
            }
        }

        protected boolean m_6465_(LevelReader p_29785_, BlockPos p_29786_) {
            BlockState blockstate = p_29785_.m_8055_(p_29786_);
            if (blockstate.m_60713_(Blocks.f_50093_) && this.wantsToRaid && !this.canRaid && (blockstate = p_29785_.m_8055_(p_29786_.m_7494_())).m_60734_() instanceof CarrotBlock && ((CarrotBlock)blockstate.m_60734_()).m_52307_(blockstate)) {
                this.canRaid = true;
                return true;
            }
            return false;
        }
    }

    public static enum Variant implements StringRepresentable
    {
        BROWN(0, "brown"),
        WHITE(1, "white"),
        BLACK(2, "black"),
        WHITE_SPLOTCHED(3, "white_splotched"),
        GOLD(4, "gold"),
        SALT(5, "salt"),
        EVIL(99, "evil");

        private static final IntFunction<Variant> BY_ID;
        public static final Codec<Variant> CODEC;
        final int id;
        private final String name;

        private Variant(int p_262657_, String p_262679_) {
            this.id = p_262657_;
            this.name = p_262679_;
        }

        public String m_7912_() {
            return this.name;
        }

        public int id() {
            return this.id;
        }

        public static Variant byId(int p_262665_) {
            return BY_ID.apply(p_262665_);
        }

        static {
            BY_ID = ByIdMap.m_262845_(Variant::id, (Object[])Variant.values(), (Object)((Object)BROWN));
            CODEC = StringRepresentable.m_216439_(Variant::values);
        }
    }

    public static class WolpertingerGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final Variant variant;

        public WolpertingerGroupData(Variant p_262662_) {
            super(1.0f);
            this.variant = p_262662_;
        }
    }
}

