/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile;

import divinerpg.enums.ArrowType;
import divinerpg.registries.ParticleRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class EntityDivineArrow
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ARROW_ID = SynchedEntityData.m_135353_(EntityDivineArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public double damageMin;
    public double damageMax;
    private ArrowType arrowType;

    public EntityDivineArrow(EntityType<? extends AbstractArrow> type, Level world) {
        super(type, world);
    }

    public EntityDivineArrow(EntityType<? extends AbstractArrow> type, Level world, ArrowType arrowType, double x, double y, double z) {
        this(type, world);
        this.arrowType = arrowType;
        this.setArrowId((byte)arrowType.ordinal());
        this.m_36781_(arrowType.getBaseDamage());
        this.m_6034_(x, y, z);
    }

    public EntityDivineArrow(EntityType<? extends AbstractArrow> type, Level world, ArrowType arrowType, LivingEntity shooter) {
        this(type, world, arrowType, shooter.f_19854_, shooter.f_19855_ + (double)shooter.m_20192_() - 0.1, shooter.f_19856_);
        this.m_36781_(arrowType.getBaseDamage());
        this.m_5602_((Entity)shooter);
    }

    public EntityDivineArrow(EntityType<? extends AbstractArrow> type, Level worldIn, ArrowType arrowType, LivingEntity shooter, LivingEntity target, float velocity, float inaccuracy) {
        this(type, worldIn, arrowType, shooter);
        this.m_36781_(arrowType.getBaseDamage());
        Vec3 vector3d = this.m_20252_(1.0f);
        double d0 = target.m_20185_() - (this.m_20185_() + vector3d.f_82479_ * 4.0);
        double d1 = target.m_20227_(0.5) - (0.5 + this.m_20227_(0.5));
        double d2 = target.m_20189_() - (this.m_20189_() + vector3d.f_82481_ * 4.0);
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.m_6686_(d0, d1 + d3 * 0.2, d2, velocity, inaccuracy);
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
        this.m_5602_((Entity)shooter);
    }

    protected ItemStack m_7941_() {
        if (this.arrowType.getArrowSupplier() != null) {
            return new ItemStack((ItemLike)this.arrowType.getArrowSupplier());
        }
        return new ItemStack((ItemLike)Items.f_41852_);
    }

    public void m_8119_() {
        super.m_8119_();
        double f = (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) / 4.0;
        if (this.arrowType == ArrowType.ETERNAL_ARCHER_FLAME_ARROW) {
            double x = this.f_19854_ + f;
            double y = this.f_19855_ + f;
            double z = this.f_19856_ + f;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.0, 0.0);
        } else if (this.arrowType == ArrowType.ETERNAL_ARCHER_WITHER_ARROW) {
            double x = this.f_19854_ + f;
            double y = this.f_19855_ + f;
            double z = this.f_19856_ + f;
            this.m_9236_().m_7106_((ParticleOptions)ParticleRegistry.BLACK_FLAME.get(), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!(entity instanceof EnderMan)) {
                if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.BLIND) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, this.arrowType.effectSec * 20, 0));
                }
                if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.FLAME) {
                    livingEntity.m_20254_(this.arrowType.effectSec);
                }
                if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.NAUSEA) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, this.arrowType.effectSec * 20, 0));
                }
                if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.POISON) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, this.arrowType.effectSec * 20, 3));
                }
                if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.SLOW) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, this.arrowType.effectSec * 20, 2));
                }
                if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.WITHER) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, this.arrowType.effectSec * 20, 2));
                }
            }
        }
        super.m_5790_(result);
    }

    protected void m_7761_(LivingEntity entity) {
        if (this.getArrowType().getArrowSpecial() == ArrowType.ArrowSpecial.EXPLODE && !this.m_9236_().f_46443_) {
            if (this.arrowType == ArrowType.SNOWSTORM_ARROW) {
                this.m_9236_().m_255391_((Entity)this, this.f_19854_, this.f_19855_, this.f_19856_, 3.0f, false, Level.ExplosionInteraction.NONE);
            } else {
                this.m_9236_().m_255391_((Entity)this, this.f_19854_, this.f_19855_, this.f_19856_, 3.0f, false, Level.ExplosionInteraction.TNT);
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ARROW_ID, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("projectileId", this.getArrowId());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setArrowId(compound.m_128445_("projectileId"));
        this.arrowType = ArrowType.getArrowFromId(this.getArrowId());
    }

    private byte getArrowId() {
        return (Byte)this.f_19804_.m_135370_(ARROW_ID);
    }

    private void setArrowId(byte projectileId) {
        this.f_19804_.m_135381_(ARROW_ID, (Object)projectileId);
    }

    public ArrowType getArrowType() {
        if (this.arrowType == null) {
            this.arrowType = ArrowType.getArrowFromId(this.getArrowId());
        }
        return this.arrowType;
    }

    public ResourceLocation getTexture() {
        return this.getArrowType().getTexture();
    }
}

