/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.entities.projectile;

import com.google.common.collect.Maps;
import divinerpg.registries.ParticleRegistry;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class EntityFrostCloud
extends Entity {
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(EntityFrostCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final Map<Entity, Integer> reapplicationDelayMap = Maps.newHashMap();
    private int duration = 600;
    private int reapplicationDelay = 10;
    private float radiusPerTick;
    private LivingEntity owner;
    private UUID ownerUniqueId;

    public EntityFrostCloud(EntityType<EntityFrostCloud> type, Level world) {
        super(type, world);
        this.f_19794_ = true;
    }

    public EntityFrostCloud(EntityType<EntityFrostCloud> type, Level world, double x, double y, double z) {
        this(type, world);
        this.m_6034_(x, y, z);
    }

    public boolean m_5825_() {
        return true;
    }

    public float m_6143_() {
        return 3.0f;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(3.0f));
    }

    public int getDuration() {
        return this.duration;
    }

    @Nullable
    public LivingEntity getOwner() {
        ServerLevel world;
        Level level;
        if (this.owner == null && this.ownerUniqueId != null && (level = this.m_9236_()) instanceof ServerLevel && (level = (world = (ServerLevel)level).m_8791_(this.ownerUniqueId)) instanceof LivingEntity) {
            LivingEntity living;
            this.owner = living = (LivingEntity)level;
        }
        return this.owner;
    }

    public float getRadius() {
        return ((Float)this.f_19804_.m_135370_(RADIUS)).floatValue();
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (RADIUS.equals(key)) {
            this.setRadius(this.getRadius());
        }
        super.m_7350_(key);
    }

    public void m_8119_() {
        block8: {
            float f;
            block7: {
                super.m_8119_();
                f = this.getRadius();
                if (!this.m_9236_().m_5776_()) break block7;
                float f5 = (float)Math.PI * f * f;
                for (float k1 = 0.0f; k1 < f5; k1 += 1.0f) {
                    float f6 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                    float f7 = Mth.m_14116_((float)this.f_19796_.m_188501_()) * f;
                    float f8 = Mth.m_14089_((float)f6) * f7;
                    float f9 = Mth.m_14031_((float)f6) * f7;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleRegistry.FROST.get(), this.f_19854_ + (double)f8, this.f_19855_, this.f_19856_ + (double)f9, (0.5 - this.f_19796_.m_188500_()) * 0.15, (double)0.01f, (0.5 - this.f_19796_.m_188500_()) * 0.15);
                }
                break block8;
            }
            if (this.f_19797_ >= this.duration) {
                this.m_6074_();
                return;
            }
            if (this.radiusPerTick != 0.0f) {
                if ((f += this.radiusPerTick) < 0.5f) {
                    this.m_6074_();
                    return;
                }
                this.setRadius(f);
            }
            if (this.f_19797_ % 5 != 0) break block8;
            Iterator<Map.Entry<Entity, Integer>> iterator = this.reapplicationDelayMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Entity, Integer> entry = iterator.next();
                if (this.f_19797_ < entry.getValue()) continue;
                iterator.remove();
            }
            List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_((double)f));
            if (!list.isEmpty()) {
                for (LivingEntity entity : list) {
                    double d1;
                    double d0;
                    double d2;
                    if (this.reapplicationDelayMap.containsKey(entity) || !entity.m_5801_() || !((d2 = (d0 = entity.f_19854_ - this.f_19854_) * d0 + (d1 = entity.f_19856_ - this.f_19856_) * d1) <= (double)(f * f))) continue;
                    this.reapplicationDelayMap.put((Entity)entity, this.f_19797_ + this.reapplicationDelay);
                    if (entity.m_21224_() || !entity.m_142079_()) continue;
                    entity.m_6469_(entity.m_9236_().m_269111_().m_269425_(), 1.5f);
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 0, false, false, false));
                }
            }
        }
    }

    public void setDuration(int durationIn) {
        this.duration = durationIn;
    }

    public void setOwner(@Nullable LivingEntity ownerIn) {
        this.owner = ownerIn;
        this.ownerUniqueId = ownerIn == null ? null : ownerIn.m_20148_();
    }

    public void setRadius(float radiusIn) {
        this.m_6034_(this.f_19854_, this.f_19855_, this.f_19856_);
        if (!this.m_9236_().m_5776_()) {
            this.f_19804_.m_135381_(RADIUS, (Object)Float.valueOf(radiusIn));
        }
    }

    public void setRadiusPerTick(float radiusPerTickIn) {
        this.radiusPerTick = radiusPerTickIn;
    }

    protected void m_7378_(CompoundTag compound) {
        this.f_19797_ = compound.m_128451_("Age");
        this.duration = compound.m_128451_("Duration");
        this.reapplicationDelay = compound.m_128451_("ReapplicationDelay");
        this.radiusPerTick = compound.m_128457_("RadiusPerTick");
        this.setRadius(compound.m_128457_("Radius"));
        this.ownerUniqueId = compound.m_128342_("OwnerUUID");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Age", this.f_19797_);
        compound.m_128405_("Duration", this.duration);
        compound.m_128405_("ReapplicationDelay", this.reapplicationDelay);
        compound.m_128350_("RadiusPerTick", this.radiusPerTick);
        compound.m_128350_("Radius", this.getRadius());
        if (this.ownerUniqueId != null) {
            compound.m_128362_("OwnerUUID", this.ownerUniqueId);
        }
    }
}

