/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.enums;

import divinerpg.registries.BlockRegistry;
import divinerpg.registries.ItemRegistry;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public enum ArmorStats implements ArmorMaterial
{
    ANGELIC(3, 8, 6, 3, 2.0f, 0.0f, 35, 10, SoundEvents.f_11673_, (Item)ItemRegistry.shadow_stone.get()),
    REALMITE(2, 6, 6, 2, 0.0f, 0.0f, 16, 9, SoundEvents.f_11677_, (Item)ItemRegistry.realmite_ingot.get()),
    SKELEMAN(2, 7, 6, 3, 0.0f, 0.0f, 21, 9, SoundEvents.f_11675_, Items.f_42500_),
    ARLEMITE(3, 7, 6, 3, 1.5f, 0.0f, 32, 10, SoundEvents.f_11677_, (Item)ItemRegistry.arlemite_ingot.get()),
    JACK_O_MAN(2, 7, 6, 3, 0.0f, 0.0f, 21, 9, SoundEvents.f_11675_, Blocks.f_50133_.m_5456_()),
    RUPEE(3, 8, 6, 3, 2.0f, 0.02f, 35, 11, SoundEvents.f_11676_, (Item)ItemRegistry.rupee_ingot.get()),
    RED_RUPEE(3, 8, 6, 3, 2.0f, 0.02f, 35, 11, SoundEvents.f_11676_, (Item)ItemRegistry.rupee_ingot.get()),
    YELLOW_RUPEE(3, 8, 6, 3, 2.0f, 0.02f, 35, 11, SoundEvents.f_11676_, (Item)ItemRegistry.rupee_ingot.get()),
    GREEN_RUPEE(3, 8, 6, 3, 2.0f, 0.02f, 35, 11, SoundEvents.f_11676_, (Item)ItemRegistry.rupee_ingot.get()),
    BLUE_RUPEE(3, 8, 6, 3, 2.0f, 0.02f, 35, 11, SoundEvents.f_11676_, (Item)ItemRegistry.rupee_ingot.get()),
    GRAY_RUPEE(3, 8, 6, 3, 2.0f, 0.02f, 35, 11, SoundEvents.f_11676_, (Item)ItemRegistry.rupee_ingot.get()),
    AQUASTRIVE(2, 7, 6, 2, 0.0f, 0.0f, 18, 9, SoundEvents.f_11677_, (Item)ItemRegistry.aquatic_ingot.get()),
    KRAKEN(2, 7, 6, 3, 0.0f, 0.0f, 20, 9, SoundEvents.f_11680_, (Item)ItemRegistry.kraken_skin.get()),
    WITHER_REAPER(2, 7, 6, 3, 0.0f, 0.0f, 21, 9, SoundEvents.f_11672_, Items.f_42500_),
    INFERNO(3, 8, 6, 3, 2.0f, 0.0f, 34, 10, SoundEvents.f_11673_, (Item)ItemRegistry.molten_stone.get()),
    CORRUPTED(3, 9, 7, 3, 3.0f, 0.05f, 40, 15, SoundEvents.f_11673_, (Item)ItemRegistry.corrupted_stone.get()),
    JUNGLE(3, 8, 6, 3, 2.0f, 0.0f, 33, 10, SoundEvents.f_11673_, (Item)ItemRegistry.jungle_stone.get()),
    TERRAN(3, 8, 6, 3, 2.0f, 0.0f, 34, 10, SoundEvents.f_11673_, (Item)ItemRegistry.terran_stone.get()),
    ENDER(4, 7, 9, 3, 3.0f, 0.12f, SoundEvents.f_11673_),
    RED_ENDER(4, 7, 9, 3, 3.0f, 0.12f, SoundEvents.f_11673_),
    YELLOW_ENDER(4, 7, 9, 3, 3.0f, 0.12f, SoundEvents.f_11673_),
    GREEN_ENDER(4, 7, 9, 3, 3.0f, 0.12f, SoundEvents.f_11673_),
    BLUE_ENDER(4, 7, 9, 3, 3.0f, 0.12f, SoundEvents.f_11673_),
    GRAY_ENDER(4, 7, 9, 3, 3.0f, 0.12f, SoundEvents.f_11673_),
    FROZEN(3, 8, 6, 3, 2.0f, 0.0f, 33, 10, SoundEvents.f_11673_, (Item)ItemRegistry.ice_stone.get()),
    TORRIDITE(3, 8, 6, 3, 2.0f, 0.0f, 34, 10, SoundEvents.f_11679_, (Item)ItemRegistry.torridite_chunk.get()),
    SENG_FUR(2, 7, 6, 2, 0.0f, 0.0f, 17, 15, SoundEvents.f_11678_, (Item)ItemRegistry.seng_fur.get()),
    SANTA(2, 7, 6, 2, 0.0f, 0.0f, 17, 15, SoundEvents.f_11678_, (Item)ItemRegistry.seng_fur.get()),
    SHADOW(3, 8, 6, 3, 2.0f, 0.0f, 35, 10, SoundEvents.f_11673_, (Item)ItemRegistry.shadow_stone.get()),
    VEMOS(4, 9, 7, 3, 3.0f, 0.12f, 43, 15, SoundEvents.f_11679_, (Item)ItemRegistry.arcanium.get()),
    ELITE_REALMITE(3, 9, 7, 3, 3.0f, 0.1f, 39, 16, SoundEvents.f_11679_, ((Block)BlockRegistry.realmiteBlock.get()).m_5456_()),
    BEDROCK(4, 9, 7, 3, 3.0f, 0.12f, SoundEvents.f_11679_),
    DIVINE(4, 9, 7, 4, 3.0f, 0.13f, SoundEvents.f_11673_),
    EDEN(4, 9, 8, 4, 3.0f, 0.14f, 45, 20, SoundEvents.f_11676_, (Item)ItemRegistry.eden_gem.get()),
    KORMA(4, 9, 7, 3, 3.0f, 0.12f, 41, 15, SoundEvents.f_11679_, (Item)ItemRegistry.arcanium.get()),
    WILDWOOD(5, 9, 8, 4, 3.5f, 0.15f, 46, 21, SoundEvents.f_11673_, (Item)ItemRegistry.wildwood_gem.get()),
    APALACHIA(5, 9, 8, 5, 3.5f, 0.16f, 47, 22, SoundEvents.f_11673_, (Item)ItemRegistry.apalachia_gem.get()),
    SKYTHERN(5, 9, 8, 5, 4.0f, 0.18f, 48, 23, SoundEvents.f_11673_, (Item)ItemRegistry.skythern_gem.get()),
    MORTUM(5, 10, 8, 5, 4.0f, 0.19f, 49, 24, SoundEvents.f_11673_, (Item)ItemRegistry.mortum_gem.get()),
    HALITE(5, 10, 8, 5, 4.5f, 0.2f, 50, 25, SoundEvents.f_11673_, (Item)ItemRegistry.mortum_gem.get()),
    AWAKENED_HALITE(5, 10, 9, 5, 4.5f, 0.21f, 51, 26, SoundEvents.f_11679_, (Item)ItemRegistry.arcanium.get()),
    DEGRADED(3, 5, 4, 2, 2.0f, 0.0f, 25, 15, SoundEvents.f_11677_),
    FINISHED(3, 6, 5, 3, 3.0f, 0.0f, 30, 15, SoundEvents.f_11677_),
    GLISTENING(4, 7, 6, 3, 4.0f, 0.0f, 35, 15, SoundEvents.f_11677_),
    DEMONIZED(4, 7, 6, 3, 5.0f, 0.0f, 40, 15, SoundEvents.f_11677_),
    TORMENTED(4, 7, 6, 3, 6.0f, 0.0f, 45, 15, SoundEvents.f_11677_);

    final String textureLocation;
    final String name;
    final SoundEvent equipSound;
    final Ingredient repairIngredient;
    final int headArmor;
    final int chestArmor;
    final int legsArmor;
    final int feetArmor;
    final int durability;
    final int enchantability;
    final float toughness;
    final float knockbackResistance;

    private ArmorStats(int headArmor, int chestArmor, int legsArmor, int feetArmor, float toughness, float resistance, SoundEvent equipSound) {
        this(null, null, headArmor, chestArmor, legsArmor, feetArmor, toughness, resistance, 0, 0, equipSound, null);
    }

    private ArmorStats(int headArmor, int chestArmor, int legsArmor, int feetArmor, float toughness, float resistance, int durability, int enchantability, SoundEvent equipSound) {
        this(null, null, headArmor, chestArmor, legsArmor, feetArmor, toughness, resistance, durability, enchantability, equipSound, null);
    }

    private ArmorStats(int headArmor, int chestArmor, int legsArmor, int feetArmor, float toughness, float resistance, int durability, @Nullable int enchantability, SoundEvent equipSound, Item repairIngredient) {
        this(null, null, headArmor, chestArmor, legsArmor, feetArmor, toughness, resistance, durability, enchantability, equipSound, repairIngredient);
    }

    private ArmorStats(String customTextureLocation, String name, int headArmor, int chestArmor, int legsArmor, int feetArmor, float toughness, float resistance, @Nullable int durability, @Nullable int enchantability, SoundEvent equipSound, Item repairIngredient) {
        String nonnullName = name == null ? this.toString().toLowerCase() : name;
        this.textureLocation = customTextureLocation == null ? "drpg_" + nonnullName + "armor" : customTextureLocation;
        this.name = "divinerpg:" + nonnullName;
        this.headArmor = headArmor;
        this.chestArmor = chestArmor;
        this.legsArmor = legsArmor;
        this.feetArmor = feetArmor;
        this.toughness = toughness;
        this.knockbackResistance = resistance;
        this.durability = durability;
        this.enchantability = enchantability;
        this.equipSound = equipSound == null ? SoundEvents.f_11675_ : equipSound;
        this.repairIngredient = repairIngredient == null ? Ingredient.f_43901_ : Ingredient.m_43929_((ItemLike[])new ItemLike[]{repairIngredient});
    }

    public String getTextureLocation() {
        return this.textureLocation;
    }

    public int m_266425_(ArmorItem.Type type) {
        if (type == ArmorItem.Type.HELMET) {
            return this.durability * 11;
        }
        if (type == ArmorItem.Type.CHESTPLATE) {
            return this.durability * 16;
        }
        if (type == ArmorItem.Type.LEGGINGS) {
            return this.durability * 15;
        }
        return this.durability * 13;
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.equipSound;
    }

    public Ingredient m_6230_() {
        return this.repairIngredient;
    }

    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    public int m_7366_(ArmorItem.Type type) {
        return switch (type) {
            case ArmorItem.Type.HELMET -> this.headArmor;
            case ArmorItem.Type.CHESTPLATE -> this.chestArmor;
            case ArmorItem.Type.LEGGINGS -> this.legsArmor;
            default -> this.feetArmor;
        };
    }
}

