/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.enums;

import divinerpg.registries.ParticleRegistry;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;

public enum BulletType {
    TOMATO_SHOT(0.5f, BulletType.ItemLoc("tomato")),
    SHURIKEN_SHOT(4.0f, BulletType.ItemLoc("shuriken")),
    VILE_STORM_SHOT(7.0f, BulletType.ItemLoc("vile_storm"), BulletDamageType.PHYSIC, BulletSpecial.POISON, 3, 2),
    SNOWFLAKE_SHURIKEN_SHOT(7.0f, BulletType.ItemLoc("snowflake_shuriken"), BulletDamageType.PHYSIC, BulletSpecial.SLOW, 3, 2),
    GRENADE(6.0f, BulletType.ProjectileLoc("grenade"), BulletDamageType.PHYSIC, BulletSpecial.EXPLODE, 3, 0),
    EDEN_SLICER_SHOT(8.0f, BulletType.ItemLoc("eden_slicer")),
    WILDWOOD_SLICER_SHOT(10.0f, BulletType.ItemLoc("wildwood_slicer")),
    APALACHIA_SLICER_SHOT(12.0f, BulletType.ItemLoc("apalachia_slicer")),
    SKYTHERN_SLICER_SHOT(14.0f, BulletType.ItemLoc("skythern_slicer")),
    MORTUM_SLICER_SHOT(16.0f, BulletType.ItemLoc("mortum_slicer")),
    HALITE_SLICER_SHOT(18.0f, BulletType.ItemLoc("halite_slicer")),
    SERENADE_OF_DEATH_SHOT(7.0f, BulletType.ProjectileLoc("serenade_of_death"), BulletDamageType.MAGIC, BulletSpecial.POISON, 3, 2),
    SERENADE_OF_ICE_SHOT(0.0f, BulletType.ProjectileLoc("serenade_of_ice"), BulletDamageType.NONE, BulletSpecial.SLOW, 3, 5),
    CRAB_ANCHOR_SHOT(3.0f, BulletType.ProjectileLoc("crab_anchor")),
    SHARK_ANCHOR_SHOT(4.0f, BulletType.ProjectileLoc("shark_anchor")),
    BOWHEAD_ANCHOR_SHOT(5.0f, BulletType.ProjectileLoc("bowhead_anchor")),
    LIOPLEURODON_ANCHOR_SHOT(6.0f, BulletType.ProjectileLoc("liopleurodon_anchor")),
    SOUND_OF_MUSIC_SHOT(9.0f, BulletType.ProjectileLoc("sound_of_music"), BulletDamageType.MAGIC, BulletSpecial.MUSIC),
    SOUND_OF_CAROLS_SHOT(11.0f, BulletType.ProjectileLoc("sound_of_carols"), BulletDamageType.MAGIC, BulletSpecial.MUSIC),
    SOUND_OF_WHALES_SHOT(13.0f, BulletType.ProjectileLoc("sound_of_whales"), BulletDamageType.MAGIC, BulletSpecial.MUSIC),
    SCYTHE_SHOT(6.0f, BulletType.ProjectileLoc("scythe"), BulletDamageType.MAGIC),
    MEGA_SCYTHE_SHOT(18.0f, BulletType.ProjectileLoc("scythe"), BulletDamageType.MAGIC),
    CYCLOPSIAN_STAFF_SHOT(3.0f, BulletType.ItemLoc("cyclops_eye_shards")),
    MAELSTROM_SHOT(12.0f, BulletType.ProjectileLoc("maelstrom"), (SimpleParticleType)ParticleRegistry.APALACHIA_PORTAL.get(), BulletDamageType.MAGIC),
    ATTRACTOR_SHOT(0.0f, BulletType.ProjectileLoc("arcana_shot"), BulletDamageType.NONE, BulletSpecial.PULL),
    REFLECTOR_SHOT(0.0f, BulletType.ProjectileLoc("arcana_shot"), BulletDamageType.NONE, BulletSpecial.PUSH),
    CAPTAINS_SPARKLER_SHOT(13.0f, BulletType.ProjectileLoc("sparkler"), BulletDamageType.ARCANA, BulletSpecial.RAINBOW),
    GENERALS_STAFF_SPRAY(13.0f, BulletType.ProjectileLoc("generals_staff"), (SimpleParticleType)ParticleRegistry.WILDWOOD_PORTAL.get(), BulletSpecial.NONE),
    GENERALS_STAFF_SHOT(13.0f, BulletType.ProjectileLoc("generals_staff"), (SimpleParticleType)ParticleRegistry.WILDWOOD_PORTAL.get(), GENERALS_STAFF_SPRAY, 4),
    STAR(13.0f, BulletType.ProjectileLoc("starlight"), (SimpleParticleType)ParticleRegistry.EDEN_PORTAL.get(), BulletSpecial.SKY),
    METEOR(15.0f, BulletType.ProjectileLoc("meteor"), (SimpleParticleType)ParticleRegistry.MORTUM_PORTAL.get(), BulletSpecial.SKY),
    CRABCLAW_CANNON_SHOT(4.0f, BulletType.ProjectileLoc("crab_anchor")),
    FROSTCLAW_CANNON_SHOT(7.0f, BulletType.ProjectileLoc("frostclaw_cannon")),
    BOWHEAD_CANNON_SHOT(6.0f, BulletType.ProjectileLoc("bowhead_anchor")),
    FROST_CANNON_SHOT(6.0f, BulletType.ProjectileLoc("frost_cannon")),
    FRACTITE_CANNON_SHOT(8.0f, BulletType.ProjectileLoc("fractite_cannon")),
    GHAST_CANNON_SHOT(11.0f, BulletType.ProjectileLoc("ghast_cannon"), BulletDamageType.MAGIC),
    GOLDEN_FURY_SHOT(17.0f, BulletType.VanillaItemLoc("gold_nugget")),
    ARCANITE_BLASTER(13.0f, BulletType.ProjectileLoc("blaster_shot"), BulletDamageType.ARCANA),
    CORRUPTED_BULLET(10.0f, BulletType.ItemLoc("corrupted_bullet")),
    EDEN_BLITZ_SHOT(10.0f, BulletType.ProjectileLoc("eden_blitz"), (SimpleParticleType)ParticleRegistry.EDEN_PORTAL.get(), BulletDamageType.PHYSIC),
    WILDWOOD_BLITZ_SHOT(12.0f, BulletType.ProjectileLoc("wildwood_blitz"), (SimpleParticleType)ParticleRegistry.WILDWOOD_PORTAL.get(), BulletDamageType.PHYSIC),
    APALACHIA_BLITZ_SHOT(14.0f, BulletType.ProjectileLoc("apalachia_blitz"), (SimpleParticleType)ParticleRegistry.APALACHIA_PORTAL.get(), BulletDamageType.PHYSIC),
    SKYTHERN_BLITZ_SHOT(16.0f, BulletType.ProjectileLoc("skythern_blitz"), (SimpleParticleType)ParticleRegistry.SKYTHERN_PORTAL.get(), BulletDamageType.PHYSIC),
    MORTUM_BLITZ_SHOT(18.0f, BulletType.ProjectileLoc("mortum_blitz"), (SimpleParticleType)ParticleRegistry.MORTUM_PORTAL.get(), BulletDamageType.PHYSIC),
    HALITE_BLITZ_SHOT(20.0f, BulletType.ProjectileLoc("halite_blitz"), (SimpleParticleType)ParticleRegistry.HALITE_PORTAL.get(), BulletDamageType.PHYSIC),
    EDEN_PHASER_SHOT(8.0f, BulletType.ProjectileLoc("eden_phaser"), (SimpleParticleType)ParticleRegistry.EDEN_PORTAL.get(), BulletDamageType.MAGIC),
    WILDWOOD_PHASER_SHOT(10.0f, BulletType.ProjectileLoc("wildwood_phaser"), (SimpleParticleType)ParticleRegistry.WILDWOOD_PORTAL.get(), BulletDamageType.MAGIC),
    APALACHIA_PHASER_SHOT(12.0f, BulletType.ProjectileLoc("apalachia_phaser"), (SimpleParticleType)ParticleRegistry.APALACHIA_PORTAL.get(), BulletDamageType.MAGIC),
    SKYTHERN_PHASER_SHOT(14.0f, BulletType.ProjectileLoc("skythern_phaser"), (SimpleParticleType)ParticleRegistry.SKYTHERN_PORTAL.get(), BulletDamageType.MAGIC),
    MORTUM_PHASER_SHOT(16.0f, BulletType.ProjectileLoc("mortum_phaser"), (SimpleParticleType)ParticleRegistry.MORTUM_PORTAL.get(), BulletDamageType.MAGIC),
    HALITE_PHASER_SHOT(18.0f, BulletType.ProjectileLoc("halite_phaser"), (SimpleParticleType)ParticleRegistry.HALITE_PORTAL.get(), BulletDamageType.MAGIC),
    CAVE_ROCK(6.0f, BulletType.ProjectileLoc("cave_rock"), BulletDamageType.PHYSIC),
    WEAK_CORI_SHOT(20.0f, BulletType.ProjectileLoc("cori_shot"), BulletDamageType.PHYSIC),
    MAGE_SHOT(10.0f, BulletType.blank(), (SimpleParticleType)ParticleRegistry.WILDWOOD_PORTAL.get(), BulletDamageType.PHYSIC),
    SPELLBINDER_SHOT(12.0f, BulletType.blank(), (SimpleParticleType)ParticleRegistry.APALACHIA_PORTAL.get(), BulletDamageType.PHYSIC),
    ADVANCED_CORI_SHOT(30.0f, BulletType.ProjectileLoc("cori_shot"), BulletDamageType.PHYSIC),
    MYSTIC_SHOT(13.0f, BulletType.blank(), (SimpleParticleType)ParticleRegistry.SKYTHERN_PORTAL.get(), BulletDamageType.PHYSIC),
    SORCERER_SHOT(14.0f, BulletType.blank(), (SimpleParticleType)ParticleRegistry.MORTUM_PORTAL.get(), BulletDamageType.PHYSIC),
    MANDRAGORA_SHOT(4.0f, BulletType.ProjectileLoc("mandragora_projectile"), BulletDamageType.PHYSIC),
    KAZROTIC_SHOT(0.0f, BulletType.ProjectileLoc("kazrotic_shot"), BulletDamageType.NONE, BulletSpecial.MOB_EXPLODE, 3, 0),
    ZORAGON_BOMB(0.0f, BulletType.ProjectileLoc("zoragon_bomb"), BulletDamageType.NONE, BulletSpecial.MOB_EXPLODE, 3, 0),
    THE_WATCHER_SHOT(4.0f, BulletType.ProjectileLoc("watcher_shot"), BulletDamageType.PHYSIC, BulletSpecial.MOB_EXPLODE, 5, 0),
    KING_OF_SCORCHERS_SHOT(14.0f, BulletType.ProjectileLoc("king_of_scorchers_shot"), BulletDamageType.NONE, BulletSpecial.FLAME, 0, 8),
    KING_OF_SCORCHERS_METEOR(0.0f, BulletType.ProjectileLoc("king_of_scorchers_meteor"), BulletDamageType.NONE, BulletSpecial.MOB_EXPLODE, 3, 0),
    BONE_FRAGMENT(6.0f, BulletType.ProjectileLoc("bone_fragment")),
    BONE_BOMB(16.0f, BulletType.ProjectileLoc("bone_bomb")),
    SUNSTORM(12.0f, BulletType.blank(), (SimpleParticleType)ParticleRegistry.EDEN_PORTAL.get(), BulletDamageType.PHYSIC),
    EXPERIENCED_CORI_SHOT(80.0f, BulletType.ProjectileLoc("cori_shot"), BulletDamageType.PHYSIC),
    TWILIGHT_DEMON_BLACK_SHOT(16.0f, BulletType.ProjectileLoc("twilight_demon_shot"), (SimpleParticleType)ParticleRegistry.MORTUM_PORTAL.get(), BulletDamageType.PHYSIC),
    TWILIGHT_DEMON_RED_SHOT(16.0f, BulletType.ProjectileLoc("twilight_demon_shot"), (SimpleParticleType)ParticleRegistry.TWILIGHT_PORTAL.get(), BulletDamageType.PHYSIC),
    SOUL_FIEND_SHOT(0.0f, BulletType.blank(), BulletDamageType.NONE),
    KAROS_BOMB(0.0f, BulletType.ProjectileLoc("zoragon_bomb"), BulletDamageType.NONE, BulletSpecial.EXPLODE, 3, 0),
    LUNA_SPARKLER(12.0f, BulletType.blank(), (SimpleParticleType)ParticleRegistry.APALACHIA_PORTAL.get(), BulletDamageType.PHYSIC),
    RAGLOK_BOMB(0.0f, BulletType.ProjectileLoc("raglok_bomb"), BulletDamageType.NONE, BulletSpecial.MOB_EXPLODE, 3, 0),
    WRECK_SHOT(15.0f, BulletType.ProjectileLoc("wreck_shot"), BulletDamageType.PHYSIC),
    WRECK_STRONG_SHOT(40.0f, BulletType.ProjectileLoc("wreck_shot"), BulletDamageType.PHYSIC),
    WRECK_BOUNCING_SHOT(35.0f, BulletType.ProjectileLoc("wreck_bouncing_projectile"), BulletDamageType.PHYSIC, BulletSpecial.BOUNCE),
    WRECK_EXPLOSIVE_SHOT(0.0f, BulletType.ProjectileLoc("wreck_explosive_projectile"), BulletDamageType.NONE, BulletSpecial.MOB_EXPLODE, 3, 0),
    TEAKER_CANNON_SHOT(3.0f, BulletType.ProjectileLoc("cannon")),
    AMTHIRMIS_CANNON_SHOT(5.0f, BulletType.ProjectileLoc("cannon")),
    DARVEN_CANNON_SHOT(8.0f, BulletType.ProjectileLoc("cannon")),
    CERMILE_CANNON_SHOT(12.0f, BulletType.ProjectileLoc("cannon")),
    PARDIMAL_CANNON_SHOT(15.0f, BulletType.ProjectileLoc("cannon")),
    QUADROTIC_CANNON_SHOT(19.0f, BulletType.ProjectileLoc("cannon")),
    KAROS_CANNON_SHOT(21.0f, BulletType.ProjectileLoc("cannon")),
    HELIOSIS_CANNON_SHOT(28.0f, BulletType.ProjectileLoc("cannon")),
    ARKSIANE_CANNON_SHOT(36.0f, BulletType.ProjectileLoc("cannon")),
    EVERSIGHT_SHOT(42.0f, BulletType.ProjectileLoc("eversight"), BulletDamageType.PHYSIC),
    TEAKER_STAFF_SHOT(3.0f, BulletType.ProjectileLoc("bouncing_projectile"), BulletDamageType.ARCANA, BulletSpecial.BOUNCE),
    AMTHIRMIS_STAFF_SHOT(5.0f, BulletType.ProjectileLoc("bouncing_projectile"), BulletDamageType.ARCANA, BulletSpecial.BOUNCE),
    DARVEN_STAFF_SHOT(8.0f, BulletType.ProjectileLoc("bouncing_projectile"), BulletDamageType.ARCANA, BulletSpecial.BOUNCE),
    CERMILE_STAFF_SHOT(12.0f, BulletType.ProjectileLoc("bouncing_projectile"), BulletDamageType.ARCANA, BulletSpecial.BOUNCE),
    PARDIMAL_STAFF_SHOT(15.0f, BulletType.ProjectileLoc("bouncing_projectile"), BulletDamageType.ARCANA, BulletSpecial.BOUNCE),
    QUADROTIC_STAFF_SHOT(19.0f, BulletType.ProjectileLoc("bouncing_projectile"), BulletDamageType.ARCANA, BulletSpecial.BOUNCE),
    KAROS_STAFF_SHOT(21.0f, BulletType.ProjectileLoc("bouncing_projectile"), BulletDamageType.ARCANA, BulletSpecial.BOUNCE),
    HELIOSIS_STAFF_SHOT(28.0f, BulletType.ProjectileLoc("bouncing_projectile"), BulletDamageType.ARCANA, BulletSpecial.BOUNCE),
    ARKSIANE_STAFF_SHOT(36.0f, BulletType.ProjectileLoc("bouncing_projectile"), BulletDamageType.ARCANA, BulletSpecial.BOUNCE),
    EVERNIGHT_SHOT(115.0f, BulletType.ProjectileLoc("evernight"), BulletDamageType.ARCANA, BulletSpecial.BOUNCE),
    TEAKER_DISK(4.0f, BulletType.ItemLoc("teaker_disk"), BulletDamageType.PHYSIC, BulletSpecial.RETURN),
    AMTHIRMIS_DISK(6.0f, BulletType.ItemLoc("amthirmis_disk"), BulletDamageType.PHYSIC, BulletSpecial.RETURN),
    DARVEN_DISK(9.0f, BulletType.ItemLoc("darven_disk"), BulletDamageType.PHYSIC, BulletSpecial.RETURN),
    CERMILE_DISK(13.0f, BulletType.ItemLoc("cermile_disk"), BulletDamageType.PHYSIC, BulletSpecial.RETURN),
    PARDIMAL_DISK(16.0f, BulletType.ItemLoc("pardimal_disk"), BulletDamageType.PHYSIC, BulletSpecial.RETURN),
    QUADROTIC_DISK(20.0f, BulletType.ItemLoc("quadrotic_disk"), BulletDamageType.PHYSIC, BulletSpecial.RETURN),
    KAROS_DISK(22.0f, BulletType.ItemLoc("karos_disk"), BulletDamageType.PHYSIC, BulletSpecial.RETURN),
    HELIOSIS_DISK(29.0f, BulletType.ItemLoc("heliosis_disk"), BulletDamageType.PHYSIC, BulletSpecial.RETURN),
    ARKSIANE_DISK(37.0f, BulletType.ItemLoc("arksiane_disk"), BulletDamageType.PHYSIC, BulletSpecial.RETURN),
    TEAKER_DISSIPATOR(4.0f, BulletType.ItemLoc("teaker_dissipator"), BulletDamageType.PHYSIC, BulletSpecial.RETURN),
    AMTHIRMIS_DISSIPATOR(6.0f, BulletType.ItemLoc("amthirmis_dissipator"), BulletDamageType.PHYSIC, BulletSpecial.RETURN),
    DARVEN_DISSIPATOR(9.0f, BulletType.ItemLoc("darven_dissipator"), BulletDamageType.PHYSIC, BulletSpecial.RETURN),
    CERMILE_DISSIPATOR(13.0f, BulletType.ItemLoc("cermile_dissipator"), BulletDamageType.PHYSIC, BulletSpecial.RETURN),
    PARDIMAL_DISSIPATOR(16.0f, BulletType.ItemLoc("pardimal_dissipator"), BulletDamageType.PHYSIC, BulletSpecial.RETURN),
    QUADROTIC_DISSIPATOR(20.0f, BulletType.ItemLoc("quadrotic_dissipator"), BulletDamageType.PHYSIC, BulletSpecial.RETURN),
    KAROS_DISSIPATOR(22.0f, BulletType.ItemLoc("karos_dissipator"), BulletDamageType.PHYSIC, BulletSpecial.RETURN),
    HELIOSIS_DISSIPATOR(29.0f, BulletType.ItemLoc("heliosis_dissipator"), BulletDamageType.PHYSIC, BulletSpecial.RETURN),
    ARKSIANE_DISSIPATOR(37.0f, BulletType.ItemLoc("arksiane_dissipator"), BulletDamageType.PHYSIC, BulletSpecial.RETURN);

    private final BulletSpecial bulletSpecial;
    private final BulletDamageType bulletDamageType;
    private final ResourceLocation texture;
    private SimpleParticleType particle;
    public BulletType sprayBullet;
    private final float damage;
    public int effectPower;
    public int effectSec;

    private BulletType(float damage, ResourceLocation texture) {
        this.damage = damage;
        this.texture = texture;
        this.bulletDamageType = BulletDamageType.PHYSIC;
        this.bulletSpecial = BulletSpecial.NONE;
    }

    private BulletType(float damage, ResourceLocation texture, BulletDamageType type) {
        this.damage = damage;
        this.texture = texture;
        this.bulletDamageType = type;
        this.bulletSpecial = BulletSpecial.NONE;
    }

    private BulletType(float damage, ResourceLocation texture, SimpleParticleType particle, BulletDamageType type) {
        this.damage = damage;
        this.texture = texture;
        this.particle = particle;
        this.bulletDamageType = type;
        this.bulletSpecial = BulletSpecial.NONE;
    }

    private BulletType(float damage, ResourceLocation texture, BulletDamageType type, BulletSpecial special, int power, int sec) {
        this.damage = damage;
        this.texture = texture;
        this.bulletDamageType = type;
        this.bulletSpecial = special;
        this.effectPower = power;
        this.effectSec = sec;
    }

    private BulletType(float damage, ResourceLocation texture, BulletDamageType type, BulletSpecial special) {
        this.damage = damage;
        this.texture = texture;
        this.bulletDamageType = type;
        this.bulletSpecial = special;
    }

    private BulletType(float damage, ResourceLocation texture, SimpleParticleType particle, BulletSpecial special) {
        this.damage = damage;
        this.texture = texture;
        this.particle = particle;
        this.bulletDamageType = BulletDamageType.ARCANA;
        this.bulletSpecial = special;
    }

    private BulletType(float damage, ResourceLocation texture, SimpleParticleType particle, BulletType type, int amount) {
        this.damage = damage;
        this.texture = texture;
        this.particle = particle;
        this.bulletDamageType = BulletDamageType.ARCANA;
        this.bulletSpecial = BulletSpecial.SPLIT;
        this.sprayBullet = type;
        this.effectPower = amount;
    }

    public static BulletType getBulletFromOrdinal(int ordinal) {
        if (ordinal < 0 || ordinal > BulletType.values().length) {
            ordinal = 0;
        }
        return BulletType.values()[ordinal];
    }

    private static ResourceLocation ProjectileLoc(String name) {
        return new ResourceLocation("divinerpg", "textures/projectiles/" + name + ".png");
    }

    private static ResourceLocation blank() {
        return new ResourceLocation("minecraft:textures/particle/generic_0.png");
    }

    public static ResourceLocation ItemLoc(String name) {
        return new ResourceLocation("divinerpg", "textures/item/" + name + ".png");
    }

    private static ResourceLocation VanillaItemLoc(String name) {
        return new ResourceLocation("minecraft:textures/item/" + name + ".png");
    }

    public float getDamage() {
        return this.damage;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public SimpleParticleType getParticle() {
        return this.particle;
    }

    public BulletSpecial getBulletSpecial() {
        return this.bulletSpecial;
    }

    public BulletDamageType getBulletDamageType() {
        return this.bulletDamageType;
    }

    public static enum BulletDamageType {
        NONE,
        PHYSIC,
        MAGIC,
        ARCANA;

    }

    public static enum BulletSpecial {
        NONE,
        BLIND,
        BOUNCE,
        EXPLODE,
        MOB_EXPLODE,
        FLAME,
        MUSIC,
        NAUSEA,
        POISON,
        PULL,
        PUSH,
        RAINBOW,
        RETURN,
        SKY,
        SLOW,
        SPLIT,
        WITHER;

    }
}

