/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import divinerpg.registries.BlockRegistry;
import divinerpg.registries.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GlacialWallTotemEvent {
    @SubscribeEvent
    public void onPlayerHurt(LivingDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (player.f_36093_.m_8020_(40).m_150930_((Item)ItemRegistry.glacial_wall_totem.get()) && (double)player.m_21223_() <= (double)player.m_21233_() * 0.2) {
                this.deployIcicleBarrier(player);
                player.f_36093_.m_8020_(40).m_41774_(1);
                Level level = player.m_9236_();
                BlockPos playerPos = player.m_20183_();
                level.m_5594_(null, playerPos, SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    private void deployIcicleBarrier(Player player) {
        Level level = player.m_9236_();
        BlockPos playerPos = player.m_20183_();
        int radius = 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = 0; y <= 4; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos blockPos = playerPos.m_7918_(x, y, z);
                    boolean isOnEdge = Math.abs(x) == radius || Math.abs(z) == radius || y == 0 || y == 4;
                    boolean isAir = level.m_8055_(blockPos).m_60795_();
                    if (!isOnEdge || !isAir) continue;
                    level.m_46597_(blockPos, ((Block)BlockRegistry.icicle.get()).m_49966_());
                }
            }
        }
        AABB box = new AABB(playerPos.m_7918_(-radius, 1, -radius), playerPos.m_7918_(radius, 4, radius));
        level.m_45976_(LivingEntity.class, box).stream().filter(entity -> entity != player && !(entity instanceof Player) && entity instanceof Mob).forEach(entity -> {
            double xDist = player.m_20185_() - entity.m_20185_();
            double zDist = player.m_20189_() - entity.m_20189_();
            double pushStrength = 3.0;
            entity.m_5997_(xDist * pushStrength, 0.5, zDist * pushStrength);
        });
    }
}

