/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.registries.ItemRegistry;
import divinerpg.util.ArmorInfo;
import divinerpg.util.IFullSetInfo;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemDivineArmor
extends ArmorItem
implements IFullSetInfo {
    public ArmorMaterial mat;
    public ArmorInfo armorInfo;
    public final MobEffect[] supportedEffects;
    public final int[] amplifier;

    public ItemDivineArmor(ArmorMaterial materialIn, ArmorItem.Type slot) {
        super(materialIn, slot, new Item.Properties());
        this.mat = materialIn;
        this.supportedEffects = null;
        this.amplifier = null;
    }

    public ItemDivineArmor(ArmorMaterial materialIn, ArmorItem.Type slot, ArmorInfo armorInfo) {
        super(materialIn, slot, new Item.Properties());
        this.mat = materialIn;
        this.armorInfo = armorInfo;
        this.supportedEffects = null;
        this.amplifier = null;
    }

    public ItemDivineArmor(ArmorMaterial materialIn, ArmorItem.Type slot, ArmorInfo armorInfo, Item.Properties properties) {
        super(materialIn, slot, properties);
        this.mat = materialIn;
        this.armorInfo = armorInfo;
        this.supportedEffects = null;
        this.amplifier = null;
    }

    public ItemDivineArmor(ArmorMaterial materialIn, ArmorItem.Type slot, ArmorInfo armorInfo, Item.Properties properties, MobEffect ... effects) {
        super(materialIn, slot, properties);
        this.mat = materialIn;
        this.armorInfo = armorInfo;
        this.supportedEffects = effects;
        this.amplifier = null;
    }

    public ItemDivineArmor(ArmorMaterial materialIn, ArmorItem.Type slot, ArmorInfo armorInfo, MobEffect ... effects) {
        super(materialIn, slot, new Item.Properties());
        this.mat = materialIn;
        this.armorInfo = armorInfo;
        this.supportedEffects = effects;
        this.amplifier = null;
    }

    public ItemDivineArmor(Rarity rarity, ArmorMaterial materialIn, ArmorItem.Type slot, ArmorInfo armorInfo, MobEffect ... effects) {
        super(materialIn, slot, new Item.Properties().m_41497_(rarity));
        this.mat = materialIn;
        this.armorInfo = armorInfo;
        this.supportedEffects = effects;
        this.amplifier = null;
    }

    public ItemDivineArmor(ArmorMaterial materialIn, ArmorItem.Type slot, ArmorInfo armorInfo, int[] amplifier, MobEffect ... effects) {
        super(materialIn, slot, new Item.Properties());
        this.mat = materialIn;
        this.armorInfo = armorInfo;
        this.supportedEffects = effects;
        this.amplifier = amplifier;
    }

    public ItemDivineArmor(Rarity rarity, ArmorMaterial materialIn, ArmorItem.Type slot, ArmorInfo armorInfo, int[] amplifier, MobEffect ... effects) {
        super(materialIn, slot, new Item.Properties().m_41497_(rarity));
        this.mat = materialIn;
        this.armorInfo = armorInfo;
        this.supportedEffects = effects;
        this.amplifier = amplifier;
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return stack.m_41720_() == ItemRegistry.seng_fur_boots.get() || stack.m_41720_() == ItemRegistry.santa_boots.get();
    }

    public int m_6473_() {
        return this.mat.m_6646_();
    }

    @Override
    public Component getFullSetPerks() {
        if (this.armorInfo == null) {
            return null;
        }
        return this.armorInfo.FullSetPerks;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.armorInfo != null) {
            tooltip.addAll(this.armorInfo.asString());
        }
        if (!this.m_41465_()) {
            stack.m_41784_().m_128379_("Unbreakable", true);
        }
    }
}

