/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.capability.Arcana;
import divinerpg.capability.ArcanaProvider;
import divinerpg.entities.projectile.EntityBouncingProjectile;
import divinerpg.entities.projectile.EntityDisk;
import divinerpg.entities.projectile.EntityParticleBullet;
import divinerpg.entities.projectile.EntityShooterBullet;
import divinerpg.enums.BulletType;
import divinerpg.items.base.ItemMod;
import divinerpg.items.base.ItemModShotgun;
import divinerpg.items.base.ItemModThrowable;
import divinerpg.items.vethea.ItemVetheanDisk;
import divinerpg.registries.EntityRegistry;
import divinerpg.util.DamageSources;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemModRanged
extends ItemMod {
    private Item ammoSupplier;
    protected BulletType bulletType;
    protected String entityType;
    public SoundEvent sound;
    public int onUseDamage;
    public int projectileAmount;

    public ItemModRanged(Rarity rarity, String entityType, BulletType bulletType, SoundEvent sound, int uses, int delay, Item ammo, int arcanaConsuming) {
        super(new Item.Properties().m_41503_(uses).m_41497_(rarity));
        this.ammoSupplier = ammo;
        this.arcanaConsumedUse = arcanaConsuming;
        this.bulletType = bulletType;
        this.cooldown = delay;
        this.entityType = entityType;
        this.sound = sound;
    }

    public ItemModRanged(String entityType, BulletType bulletType, SoundEvent sound, int uses, int delay, Item ammo, int arcanaConsuming) {
        super(new Item.Properties().m_41503_(uses));
        this.ammoSupplier = ammo;
        this.arcanaConsumedUse = arcanaConsuming;
        this.bulletType = bulletType;
        this.cooldown = delay;
        this.entityType = entityType;
        this.sound = sound;
    }

    public ItemModRanged(Rarity rarity, BulletType bulletType, int delay) {
        super(new Item.Properties().m_41497_(rarity));
        this.bulletType = bulletType;
        this.cooldown = delay;
        this.sound = SoundEvents.f_11687_;
    }

    public ItemModRanged(BulletType bulletType, SoundEvent sound, Item ammoSupplier, int uses, int delay, int arcanaConsuming) {
        this(null, bulletType, sound, uses, delay, ammoSupplier, arcanaConsuming);
    }

    public ItemModRanged(BulletType bulletType, SoundEvent sound, Item ammoSupplier, int uses, int delay) {
        this(null, bulletType, sound, uses, delay, ammoSupplier, 0);
    }

    public ItemModRanged(BulletType bulletType, SoundEvent sound, int uses, int delay) {
        this(bulletType, sound, null, uses, delay);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        InteractionResultHolder<ItemStack> ammo = this.tryFindAmmo(player);
        InteractionResultHolder<Arcana> checkArcana = this.tryCheckArcana(player);
        if (ammo.m_19089_() == InteractionResult.SUCCESS && checkArcana.m_19089_() == InteractionResult.SUCCESS) {
            ItemStack ammoStack;
            Arcana arcana;
            this.doPreUsageEffects(world, player);
            if (!world.f_46443_) {
                this.spawnEntity(world, player, stack, this.bulletType, this.entityType);
            }
            if ((arcana = (Arcana)checkArcana.m_19095_()) != null) {
                arcana.modifyAmount((LivingEntity)player, -this.arcanaConsumedUse);
            }
            if ((ammoStack = (ItemStack)ammo.m_19095_()) != null) {
                ammoStack.m_41774_(1);
            }
            if (!player.m_7500_()) {
                stack.m_41622_(1, (LivingEntity)player, ctx -> ctx.m_21190_(player.m_7655_()));
            }
            player.m_36335_().m_41524_((Item)this, this.cooldown);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            this.doPostUsageEffects(world, player);
            if (this instanceof ItemModThrowable || this instanceof ItemVetheanDisk) {
                player.m_5496_(this.sound != null ? this.sound : SoundEvents.f_11687_, 0.5f, 0.4f / (player.m_217043_().m_188501_() * 0.4f + 0.8f));
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            player.m_5496_(this.sound != null ? this.sound : SoundEvents.f_11687_, 1.0f, 1.0f);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private boolean needsAmmo() {
        return this.ammoSupplier != null;
    }

    private boolean isAmmo(@Nullable ItemStack stack) {
        return stack != null && stack.m_41720_() == this.ammoSupplier;
    }

    private ItemStack findAmmo(Player player) {
        if (this.isAmmo(player.m_21120_(InteractionHand.OFF_HAND))) {
            return player.m_21120_(InteractionHand.OFF_HAND);
        }
        if (this.isAmmo(player.m_21120_(InteractionHand.MAIN_HAND))) {
            return player.m_21120_(InteractionHand.MAIN_HAND);
        }
        for (int i = 0; i < player.f_36093_.m_6643_(); ++i) {
            ItemStack itemstack = player.f_36093_.m_8020_(i);
            if (!this.isAmmo(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    protected InteractionResultHolder<ItemStack> tryFindAmmo(Player player) {
        ItemStack stack = null;
        InteractionResult result = InteractionResult.SUCCESS;
        if (!player.m_7500_() && this.needsAmmo() && ((stack = this.findAmmo(player)) == null || stack.m_41613_() < 1)) {
            result = InteractionResult.FAIL;
        }
        return new InteractionResultHolder(result, stack);
    }

    protected InteractionResultHolder<Arcana> tryCheckArcana(Player player) {
        Arcana arcana = null;
        InteractionResult result = InteractionResult.SUCCESS;
        if (this.arcanaConsumedUse > 0 && ((arcana = (Arcana)player.getCapability(ArcanaProvider.ARCANA).orElse(null)) == null || arcana.getAmount(player.m_9236_().m_5776_()) < (float)this.arcanaConsumedUse)) {
            result = InteractionResult.FAIL;
        }
        return new InteractionResultHolder(result, arcana);
    }

    protected void spawnEntity(Level world, Player player, ItemStack stack, BulletType bulletType, String entityType) {
        ThrowableProjectile bullet;
        if (entityType != null) {
            try {
                bullet = (ThrowableProjectile)((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation("divinerpg", entityType))).m_20615_(world);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        } else {
            bullet = bulletType.getBulletSpecial() == BulletType.BulletSpecial.BOUNCE ? new EntityBouncingProjectile((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.BOUNCING_PROJECTILE.get()), (LivingEntity)player, world, bulletType) : (bulletType.getBulletSpecial() == BulletType.BulletSpecial.RETURN ? new EntityDisk((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.DISK.get()), (LivingEntity)player, world, bulletType) : (bulletType.getParticle() != ParticleTypes.f_123795_ ? new EntityParticleBullet((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.PARTICLE_BULLET.get()), world, (LivingEntity)player, bulletType) : new EntityShooterBullet((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.SHOOTER_BULLET.get()), (LivingEntity)player, world, bulletType)));
        }
        bullet.m_37251_((Entity)player, player.f_19858_, player.f_19857_, 0.0f, 1.5f, 0.5f);
        world.m_7967_((Entity)bullet);
    }

    protected void doPreUsageEffects(Level world, Player player) {
        if (this.onUseDamage > 0) {
            player.m_6469_(DamageSources.source(world, DamageSources.ARCANA), (float)this.onUseDamage);
        }
    }

    protected void doPostUsageEffects(Level world, Player player) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.bulletType != null) {
            if (!(this instanceof ItemModShotgun)) {
                if (this.bulletType.getBulletDamageType() == BulletType.BulletDamageType.ARCANA) {
                    tooltip.add(LocalizeUtils.arcanaDam((int)this.bulletType.getDamage()));
                }
                if (this.bulletType.getBulletDamageType() == BulletType.BulletDamageType.MAGIC) {
                    tooltip.add(LocalizeUtils.magicDam((int)this.bulletType.getDamage()));
                }
                if (this.bulletType.getBulletDamageType() == BulletType.BulletDamageType.PHYSIC) {
                    tooltip.add(LocalizeUtils.rangedDam((int)this.bulletType.getDamage()));
                }
            }
            if (this.bulletType.getBulletSpecial() == BulletType.BulletSpecial.BOUNCE) {
                tooltip.add(LocalizeUtils.bouncingShots());
            }
            if (this.bulletType.getBulletSpecial() == BulletType.BulletSpecial.POISON) {
                tooltip.add(LocalizeUtils.poison(this.bulletType.effectSec));
            }
            if (this.bulletType.getBulletSpecial() == BulletType.BulletSpecial.PULL) {
                tooltip.add(LocalizeUtils.pull());
            }
            if (this.bulletType.getBulletSpecial() == BulletType.BulletSpecial.PUSH) {
                tooltip.add(LocalizeUtils.push());
            }
            if (this.bulletType.getBulletSpecial() == BulletType.BulletSpecial.RETURN) {
                tooltip.add(LocalizeUtils.returnsToSender());
            }
            if (this.bulletType.getBulletSpecial() == BulletType.BulletSpecial.SKY) {
                tooltip.add(LocalizeUtils.skyShots(this.projectileAmount));
            }
            if (this.bulletType == BulletType.METEOR || this.bulletType.getBulletSpecial() == BulletType.BulletSpecial.EXPLODE) {
                tooltip.add(LocalizeUtils.explosiveShots());
            }
            if (this.bulletType.getBulletSpecial() == BulletType.BulletSpecial.SLOW) {
                tooltip.add(LocalizeUtils.slow(this.bulletType.effectSec));
            }
            if (this.bulletType.getBulletSpecial() == BulletType.BulletSpecial.SPLIT) {
                tooltip.add(LocalizeUtils.splitShots(this.bulletType.effectPower + 1));
            }
        }
        if (this.onUseDamage > 0) {
            tooltip.add(LocalizeUtils.onUseDam(this.onUseDamage));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (!(this instanceof ItemModThrowable)) {
            tooltip.add(this.needsAmmo() ? LocalizeUtils.ammo(this.ammoSupplier) : LocalizeUtils.infiniteAmmo());
            if (!this.m_41465_()) {
                stack.m_41784_().m_128379_("Unbreakable", true);
            }
        }
    }
}

