/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.items.base;

import divinerpg.entities.projectile.EntityShooterBullet;
import divinerpg.enums.BulletType;
import divinerpg.items.base.ItemModRanged;
import divinerpg.registries.EntityRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemModShotgun
extends ItemModRanged {
    public ItemModShotgun(BulletType bulletType, SoundEvent sound, int uses, int delay, Item ammoSupplier, int arcanaConsuming, int projectileAmount) {
        super(bulletType, sound, ammoSupplier, uses, delay, arcanaConsuming);
        this.projectileAmount = projectileAmount;
    }

    @Override
    protected void spawnEntity(Level world, Player player, ItemStack stack, BulletType bulletType, String entityType) {
        RandomSource rand = world.f_46441_;
        for (int i = 0; i < this.projectileAmount; ++i) {
            EntityShooterBullet entity = new EntityShooterBullet((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.SHOOTER_BULLET.get()), (LivingEntity)player, world, bulletType);
            entity.m_37251_((Entity)player, player.f_19858_ + (rand.m_188501_() - 0.5f) * 3.5f, player.f_19857_ + (rand.m_188501_() - 0.5f) * 3.5f, 0.0f, 1.5f, 1.0f);
            entity.m_6027_(entity.m_20185_() + (rand.m_188500_() - 0.5), entity.m_20186_() + (rand.m_188500_() - 0.5), entity.m_20189_() + (rand.m_188500_() - 0.5));
            world.m_7967_((Entity)entity);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (this.bulletType.getBulletDamageType() == BulletType.BulletDamageType.PHYSIC) {
            tooltip.add(LocalizeUtils.rangedDam(this.projectileAmount + "x" + (int)this.bulletType.getDamage()));
        }
        if (this.bulletType.getBulletDamageType() == BulletType.BulletDamageType.ARCANA) {
            tooltip.add(LocalizeUtils.arcanaDam(this.projectileAmount + "x" + (int)this.bulletType.getDamage()));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

