/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import divinerpg.registries.RecipeRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class InfusionTableRecipe
implements Recipe<Container> {
    public final ItemStack input;
    public final ItemStack template;
    public final ItemStack output;
    public final int count;
    private final ResourceLocation id;

    public InfusionTableRecipe(ResourceLocation id, ItemStack input, ItemStack template, ItemStack output, int count) {
        this.id = id;
        this.input = input;
        this.template = template;
        this.output = output;
        this.count = count;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return ItemStack.m_41656_((ItemStack)this.input, (ItemStack)inv.m_8020_(0)) && ItemStack.m_41656_((ItemStack)this.template, (ItemStack)inv.m_8020_(1)) && inv.m_8020_(0).m_41613_() == this.count;
    }

    public int getCount() {
        return this.count;
    }

    public ItemStack m_5874_(Container inv, RegistryAccess access) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int p_194133_1_, int p_194133_2_) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.output;
    }

    public NonNullList<Ingredient> getTemplate() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.input}));
        return ingredients;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeRegistry.Serailizers.INFUSION_TABLE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Type
    implements RecipeType<InfusionTableRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "infusion_table";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<InfusionTableRecipe> {
        int count = 1;

        public InfusionTableRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ItemStack inputItem;
            if (json.get("input").isJsonObject()) {
                inputItem = ShapedRecipe.m_151274_((JsonObject)json.getAsJsonObject("input"));
            } else {
                ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"input"));
                Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
                if (item == null) {
                    throw new JsonSyntaxException("Unknown item '" + String.valueOf(id) + "'");
                }
                this.count = !json.has("count") ? 1 : GsonHelper.m_13927_((JsonObject)json, (String)"count");
                inputItem = new ItemStack((ItemLike)item, this.count);
            }
            ItemStack template = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"template"), (boolean)false);
            ItemStack output = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"), (boolean)false);
            return new InfusionTableRecipe(recipeId, inputItem, template, output, inputItem.m_41613_());
        }

        @Nullable
        public InfusionTableRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buffer) {
            ItemStack input = buffer.m_130267_();
            ItemStack template = buffer.m_130267_();
            ItemStack output = buffer.m_130267_();
            int count = buffer.readInt();
            return new InfusionTableRecipe(resourceLocation, input, template, output, count);
        }

        public void toNetwork(FriendlyByteBuf buffer, InfusionTableRecipe recipe) {
            buffer.m_130055_(recipe.input);
            buffer.m_130055_(recipe.template);
            buffer.m_130055_(recipe.output);
            buffer.writeInt(recipe.count);
        }
    }
}

