/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.registries;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.ParticleRegistry;
import divinerpg.util.DamageSources;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class FluidRegistry {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"divinerpg");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"divinerpg");
    public static final RegistryObject<FluidType> SMOLDERING_TAR = FLUID_TYPES.register("smoldering_tar_fluid_type", () -> new FluidType(FluidType.Properties.create().canSwim(false).canHydrate(false).canDrown(true).density(1153).viscosity(8000).temperature(1100).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11783_)){

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){
                private static final ResourceLocation STILL = new ResourceLocation("divinerpg", "block/liquid_tar_still");
                private static final ResourceLocation FLOW = new ResourceLocation("divinerpg", "block/liquid_tar_flow");

                public ResourceLocation getStillTexture() {
                    return STILL;
                }

                public ResourceLocation getFlowingTexture() {
                    return FLOW;
                }

                public int getTintColor() {
                    return -1350565932;
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    int color = this.getTintColor();
                    return new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    nearDistance = -8.0f;
                    farDistance = 4.0f;
                    if (farDistance > renderDistance) {
                        farDistance = renderDistance;
                        shape = FogShape.CYLINDER;
                    }
                    RenderSystem.setShaderFogStart((float)nearDistance);
                    RenderSystem.setShaderFogEnd((float)farDistance);
                    RenderSystem.setShaderFogShape((FogShape)shape);
                }
            });
        }
    });
    public static final RegistryObject<FlowingFluid> SMOLDERING_TAR_FLUID = FLUIDS.register("smoldering_tar_still", () -> new ForgeFlowingFluid.Source(FluidRegistry.fluidProperties()){

        public int m_6719_(LevelReader level) {
            return level.m_6042_().f_63857_() ? 4 : 2;
        }

        public int m_6713_(LevelReader level) {
            return level.m_6042_().f_63857_() ? 1 : 2;
        }

        public int m_6718_(LevelReader level) {
            return level.m_6042_().f_63857_() ? 30 : 50;
        }

        public int m_6886_(Level level, BlockPos pos, FluidState state1, FluidState state2) {
            int i = this.m_6718_((LevelReader)level);
            if (!(state1.m_76178_() || state2.m_76178_() || ((Boolean)state1.m_61143_((Property)f_75947_)).booleanValue() || ((Boolean)state2.m_61143_((Property)f_75947_)).booleanValue() || !(state2.m_76155_((BlockGetter)level, pos) > state1.m_76155_((BlockGetter)level, pos)) || level.m_213780_().m_188503_(4) == 0)) {
                i *= 4;
            }
            return i;
        }

        public void m_213811_(Level level, BlockPos pos, FluidState state, RandomSource random) {
            BlockPos blockpos = pos.m_7494_();
            if (level.m_8055_(blockpos).m_60795_() && !level.m_8055_(blockpos).m_60804_((BlockGetter)level, blockpos)) {
                if (random.m_188503_(100) == 0) {
                    double f = 0.5 + random.m_188500_() / 4.0 * (double)(random.m_188499_() ? 1 : -1);
                    double d0 = (double)pos.m_123341_() + f;
                    double d1 = (double)pos.m_123342_() + 0.9;
                    double d2 = (double)pos.m_123343_() + f;
                    level.m_7106_((ParticleOptions)ParticleRegistry.TAR.get(), d0, d1, d2, 0.0, 0.005, 0.0);
                    level.m_7785_(d0, d1, d2, SoundEvents.f_12032_, SoundSource.BLOCKS, 0.2f + random.m_188501_() * 0.2f, 0.9f + random.m_188501_() * 0.15f, false);
                }
                if (random.m_188503_(200) == 0) {
                    level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12030_, SoundSource.BLOCKS, 0.2f + random.m_188501_() * 0.2f, 0.9f + random.m_188501_() * 0.15f, false);
                }
            }
        }

        private void fizz(LevelAccessor level, BlockPos pos) {
            level.m_46796_(1501, pos, 0);
        }

        protected void m_7456_(LevelAccessor level, BlockPos pos, BlockState state) {
            this.fizz(level, pos);
        }
    });
    public static final RegistryObject<Fluid> SMOLDERING_TAR_FLUID_FLOWING = FLUIDS.register("smoldering_tar_flowing", () -> new ForgeFlowingFluid.Flowing(FluidRegistry.fluidProperties()){

        private void fizz(LevelAccessor level, BlockPos pos) {
            level.m_46796_(1501, pos, 0);
        }

        protected void m_7456_(LevelAccessor level, BlockPos pos, BlockState state) {
            this.fizz(level, pos);
        }

        protected void m_6364_(LevelAccessor level, BlockPos pos, BlockState blockState, Direction dir, FluidState fluidState) {
            if (dir == Direction.DOWN) {
                FluidState fluidstate = level.m_6425_(pos);
                if (this.m_76145_().m_205070_(FluidTags.f_13132_) && fluidstate.m_205070_(FluidTags.f_13131_)) {
                    if (blockState.m_60734_() instanceof LiquidBlock) {
                        level.m_7731_(pos, ForgeEventFactory.fireFluidPlaceBlockEvent((LevelAccessor)level, (BlockPos)pos, (BlockPos)pos, (BlockState)Blocks.f_50069_.m_49966_()), 3);
                    }
                    this.fizz(level, pos);
                    return;
                }
            }
            super.m_6364_(level, pos, blockState, dir, fluidState);
        }
    });
    public static final RegistryObject<LiquidBlock> SMOLDERING_TAR_BLOCK = BlockRegistry.BLOCKS.register("smoldering_tar", () -> new LiquidBlock((Supplier)SMOLDERING_TAR_FLUID, BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_279557_).m_280170_().m_278166_(PushReaction.DESTROY).m_60977_().m_284180_(MapColor.f_283927_).m_60910_().m_60978_(100.0f).m_222994_()){

        public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
            if (entity.isInFluidType()) {
                entity.m_7601_(state, new Vec3(0.4, 0.4, 0.4));
                entity.m_20254_(12);
                if ((entity instanceof LivingEntity && !entity.m_5825_() && !((LivingEntity)entity).m_21023_(MobEffects.f_19607_) || !(entity instanceof LivingEntity) && !entity.m_5825_()) && entity.m_6469_(DamageSources.source(level, DamageSources.TAR), 4.0f)) {
                    entity.m_5496_(SoundEvents.f_11909_, 0.4f, 2.0f + entity.f_19796_.m_188501_() * 0.4f);
                }
            }
        }
    });

    private static ForgeFlowingFluid.Properties fluidProperties() {
        return new ForgeFlowingFluid.Properties(SMOLDERING_TAR, SMOLDERING_TAR_FLUID, SMOLDERING_TAR_FLUID_FLOWING).block(SMOLDERING_TAR_BLOCK).bucket(ItemRegistry.smoldering_tar_bucket);
    }
}

