/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.util;

import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class TileInventoryHelper
implements Container {
    private final ItemStackHandler chestContents;
    private Predicate<Player> canPlayerAccessInventoryLambda = x -> true;
    private Notify markDirtyNotificationLambda;
    private final Notify openInventoryNotificationLambda;
    private final Notify closeInventoryNotificationLambda;

    private TileInventoryHelper(int size) {
        this.markDirtyNotificationLambda = () -> {};
        this.openInventoryNotificationLambda = () -> {};
        this.closeInventoryNotificationLambda = () -> {};
        this.chestContents = new ItemStackHandler(size);
    }

    private TileInventoryHelper(int size, Predicate<Player> canPlayerAccessInventoryLambda, Notify markDirtyNotificationLambda) {
        this.markDirtyNotificationLambda = () -> {};
        this.openInventoryNotificationLambda = () -> {};
        this.closeInventoryNotificationLambda = () -> {};
        this.chestContents = new ItemStackHandler(size);
        this.canPlayerAccessInventoryLambda = canPlayerAccessInventoryLambda;
        this.markDirtyNotificationLambda = markDirtyNotificationLambda;
    }

    public static TileInventoryHelper createForBlockEntity(int size, Predicate<Player> canPlayerAccessInventoryLambda, Notify markDirtyNotificationLambda) {
        return new TileInventoryHelper(size, canPlayerAccessInventoryLambda, markDirtyNotificationLambda);
    }

    public static TileInventoryHelper createForClientSideContainer(int size) {
        return new TileInventoryHelper(size);
    }

    public CompoundTag serializeNBT() {
        return this.chestContents.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.chestContents.deserializeNBT(nbt);
    }

    public boolean m_6542_(Player player) {
        return this.canPlayerAccessInventoryLambda.test(player);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return this.chestContents.isItemValid(index, stack);
    }

    public void m_6596_() {
        this.markDirtyNotificationLambda.invoke();
    }

    public void m_5856_(Player player) {
        this.openInventoryNotificationLambda.invoke();
    }

    public void m_5785_(Player player) {
        this.closeInventoryNotificationLambda.invoke();
    }

    public int m_6643_() {
        return this.chestContents.getSlots();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.chestContents.getSlots(); ++i) {
            if (this.chestContents.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return this.chestContents.getStackInSlot(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return this.chestContents.extractItem(index, count, false);
    }

    public ItemStack m_8016_(int index) {
        int maxPossibleItemStackSize = this.chestContents.getSlotLimit(index);
        return this.chestContents.extractItem(index, maxPossibleItemStackSize, false);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.chestContents.setStackInSlot(index, stack);
    }

    public void m_6211_() {
        for (int i = 0; i < this.chestContents.getSlots(); ++i) {
            this.chestContents.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    @FunctionalInterface
    public static interface Notify {
        public void invoke();
    }
}

