/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.pond;

import divinerpg.world.ConfiguredFeatureKeys;
import divinerpg.world.feature.config.RuleTestConfig;
import divinerpg.world.placement.Surface;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.registries.ForgeRegistries;

public class GeothermalPond
extends Feature<RuleTestConfig> {
    public GeothermalPond() {
        super(RuleTestConfig.CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<RuleTestConfig> context) {
        return this.place((RuleTestConfig)context.m_159778_(), context.m_159774_(), null, context.m_225041_(), context.m_159777_());
    }

    public boolean place(RuleTestConfig config, WorldGenLevel level, ChunkGenerator g, RandomSource random, BlockPos pos) {
        if (this.canSustain(config.rules, level, random, pos)) {
            ArrayList<BlockPos> list = new ArrayList<BlockPos>();
            this.generate(list, config.rules, level, random, pos);
            if (list.isEmpty()) {
                return false;
            }
            for (BlockPos p : list) {
                this.decorate(list, config.rules, level, random, p);
            }
            return true;
        }
        return false;
    }

    public final boolean rule(List<RuleTest> rules, RandomSource random, BlockState state) {
        if (rules.isEmpty() && this.standardRule(state)) {
            return true;
        }
        for (RuleTest test : rules) {
            if (!test.m_213865_(state, random)) continue;
            return true;
        }
        return false;
    }

    public boolean standardRule(BlockState state) {
        return state.m_204336_(BlockTags.f_144276_) || state.m_204336_(BlockTags.f_144279_) || state.m_204336_(BlockTags.f_13047_);
    }

    protected boolean canSustain(List<RuleTest> rules, WorldGenLevel level, RandomSource random, BlockPos pos) {
        return Surface.hasSpace(level, pos.m_7494_()) && !Surface.hasSpace(level, pos.m_7495_()) && this.rule(rules, random, level.m_8055_(pos));
    }

    protected void generate(ArrayList<BlockPos> positions, List<RuleTest> rules, WorldGenLevel level, RandomSource random, BlockPos pos) {
        if ((positions.isEmpty() || Math.sqrt(Math.pow(pos.m_123341_() - positions.get(0).m_123341_(), 2.0) + Math.pow(pos.m_123343_() - positions.get(0).m_123343_(), 2.0)) < 8.0) && (double)random.m_188501_() < 0.8) {
            this.m_5974_((LevelWriter)level, pos, Blocks.f_49990_.m_49966_());
            positions.add(pos);
            BlockPos north = pos.m_122012_();
            BlockPos south = pos.m_122019_();
            BlockPos east = pos.m_122029_();
            BlockPos west = pos.m_122024_();
            if (!positions.contains(north) && this.canSustain(rules, level, random, north)) {
                this.generate(positions, rules, level, random, north);
            }
            if (!positions.contains(east) && this.canSustain(rules, level, random, east)) {
                this.generate(positions, rules, level, random, east);
            }
            if (!positions.contains(south) && this.canSustain(rules, level, random, south)) {
                this.generate(positions, rules, level, random, south);
            }
            if (!positions.contains(west) && this.canSustain(rules, level, random, west)) {
                this.generate(positions, rules, level, random, west);
            }
        }
    }

    protected void decorate(ArrayList<BlockPos> positions, List<RuleTest> rules, WorldGenLevel level, RandomSource random, BlockPos pos) {
        BlockPos north = pos.m_122012_();
        BlockPos south = pos.m_122019_();
        BlockPos east = pos.m_122029_();
        BlockPos west = pos.m_122024_();
        if (positions.contains(north) && positions.contains(east) && positions.contains(south) && positions.contains(west)) {
            this.genDeep(rules, level, random, pos);
        } else {
            this.genShallow(rules, level, random, pos);
            this.tryGenEdge(rules, level, random, north);
            this.tryGenEdge(rules, level, random, east);
            this.tryGenEdge(rules, level, random, south);
            this.tryGenEdge(rules, level, random, west);
        }
    }

    protected void tryGenEdge(List<RuleTest> rules, WorldGenLevel level, RandomSource random, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (!state.m_61145_((Property)BlockStateProperties.f_61362_).orElseGet(() -> state.m_60713_(Blocks.f_49990_)).booleanValue()) {
            this.genEdge(rules, level, random, pos);
        }
    }

    protected void genDeep(List<RuleTest> rules, WorldGenLevel level, RandomSource random, BlockPos pos) {
        pos = pos.m_7495_();
        this.m_5974_((LevelWriter)level, pos, Blocks.f_49990_.m_49966_());
        if ((double)random.m_188501_() < 0.1) {
            ((ConfiguredFeature)ConfiguredFeatureKeys.getConfiguredFeature(level, ConfiguredFeatureKeys.THERMAL_VENT).m_203334_()).m_224953_(level, null, random, pos);
        }
        if (this.rule(rules, random, level.m_8055_(pos.m_7495_()))) {
            if (random.m_188501_() < 0.4f) {
                this.m_5974_((LevelWriter)level, pos.m_7495_(), Blocks.f_49994_.m_49966_());
            } else if (random.m_188501_() < 0.3f) {
                this.m_5974_((LevelWriter)level, pos.m_7495_(), Blocks.f_50129_.m_49966_());
            } else if (random.m_188501_() < 0.2f) {
                pos = pos.m_7495_();
                this.m_5974_((LevelWriter)level, pos, Blocks.f_50450_.m_49966_());
                pos = pos.m_7495_();
                if (Surface.hasSpace(level, pos) || this.rule(rules, random, level.m_8055_(pos))) {
                    this.m_5974_((LevelWriter)level, pos, ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "coalstone"))).m_49966_());
                }
            } else if (random.m_188501_() < 0.2f) {
                this.m_5974_((LevelWriter)level, pos.m_7495_(), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "coalstone"))).m_49966_());
            } else if (random.m_188501_() < 0.05f) {
                this.m_5974_((LevelWriter)level, pos.m_7495_(), Blocks.f_50080_.m_49966_());
            } else {
                this.m_5974_((LevelWriter)level, pos.m_7495_(), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "frozen_gravel"))).m_49966_());
            }
        }
    }

    protected void genShallow(List<RuleTest> rules, WorldGenLevel level, RandomSource random, BlockPos pos) {
        pos = pos.m_7495_();
        if (random.m_188501_() < 0.3f) {
            this.m_5974_((LevelWriter)level, pos, Blocks.f_50129_.m_49966_());
        } else if (random.m_188501_() < 0.4f) {
            this.m_5974_((LevelWriter)level, pos, Blocks.f_49994_.m_49966_());
        } else {
            this.m_5974_((LevelWriter)level, pos, ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "frozen_gravel"))).m_49966_());
        }
    }

    protected void genEdge(List<RuleTest> rules, WorldGenLevel level, RandomSource random, BlockPos pos) {
        if (random.m_188501_() < 0.4f) {
            this.m_5974_((LevelWriter)level, pos, Blocks.f_50129_.m_49966_());
        } else if (random.m_188501_() < 0.3f) {
            this.m_5974_((LevelWriter)level, pos, Blocks.f_49994_.m_49966_());
        } else if (random.m_188501_() < 0.1f) {
            this.m_5974_((LevelWriter)level, pos, ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "frozen_gravel"))).m_49966_());
        } else {
            this.m_5974_((LevelWriter)level, pos, ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "cobbled_frozen_stone"))).m_49966_());
        }
    }
}

