/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.structurelike;

import divinerpg.registries.StructureRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.registries.ForgeRegistries;

public class ArcanaDungeon
extends Feature<NoneFeatureConfiguration> {
    public static NormalNoise dungeonNoise;
    public static long seed;
    public static StructureTemplate doorway;
    public static StructureTemplate entranceRoom;
    public static StructureTemplate stairs;
    public static StructureTemplate stairsTop;
    public static StructureTemplate[] doors;
    public static Room[] adaptiveRooms;
    public static Room[] corners;
    public static Room[] junctions;
    public static Room[] crossroads;
    public static Room[] deadends;
    public static Room[] hallways;
    public static Room[] hidden;
    public static VerticalRoom[] verticalRooms;
    public static BigRoom[] bigRooms;

    public ArcanaDungeon() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        return this.place(null, context.m_159774_(), null, context.m_225041_(), context.m_159777_());
    }

    public boolean place(NoneFeatureConfiguration c, WorldGenLevel level, ChunkGenerator g, RandomSource random, BlockPos pos) {
        long newSeed;
        if (doorway == null) {
            StructureTemplateManager manager = level.m_6018_().m_7654_().m_236738_();
            BlockState degraded = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "degraded_bricks"))).m_49966_();
            BlockState ancientBrick = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "ancient_bricks"))).m_49966_();
            BlockState sludge = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "soul_stone"))).m_49966_();
            BlockState ancient = ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "ancient_stone"))).m_49966_();
            doorway = manager.m_230359_(new ResourceLocation("divinerpg", "arcana/doors/doorway"));
            entranceRoom = manager.m_230359_(new ResourceLocation("divinerpg", "arcana/entrance_room"));
            stairs = manager.m_230359_(new ResourceLocation("divinerpg", "arcana/stairs"));
            stairsTop = manager.m_230359_(new ResourceLocation("divinerpg", "arcana/stairs_top"));
            doors = new StructureTemplate[]{manager.m_230359_(new ResourceLocation("divinerpg", "arcana/doors/ancient_brick")), manager.m_230359_(new ResourceLocation("divinerpg", "arcana/doors/degraded_brick")), manager.m_230359_(new ResourceLocation("divinerpg", "arcana/doors/soul_sludge")), manager.m_230359_(new ResourceLocation("divinerpg", "arcana/doors/soul_stone"))};
            adaptiveRooms = new Room[]{new Room(manager, "arcana/any/degraded_maze", degraded), new Room(manager, "arcana/any/heat_trap_column", ancient), new Room(manager, "arcana/any/hollow_column", sludge), new Room(manager, "arcana/any/maze", degraded), new Room(manager, "arcana/any/checker", degraded), new Room(manager, "arcana/any/pillars", ancientBrick), new Room(manager, "arcana/any/pillars2", degraded), new Room(manager, "arcana/any/razorback", ancientBrick), new Room(manager, "arcana/any/three_squares", ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "soul_stone"))).m_49966_()), new Room(manager, "arcana/any/zelus_farm", degraded), new Room(manager, "arcana/any/serpentine", ancientBrick)};
            crossroads = new Room[]{new Room(manager, "arcana/crossroads/delta_crossroads", ancientBrick), new Room(manager, "arcana/crossroads/extraction_crossroads", null), new Room(manager, "arcana/crossroads/heat_trap_crossroads", null), new Room(manager, "arcana/crossroads/heat_trap_crossroads_arcanium", null), new Room(manager, "arcana/crossroads/ramp_crossroads", ancientBrick), new Room(manager, "arcana/crossroads/maze_crossroads", null)};
            deadends = new Room[]{new Room(manager, "arcana/deadend/captain_merik_forge", ancientBrick), new Room(manager, "arcana/deadend/datticon_workshop", degraded), new Room(manager, "arcana/deadend/hill_dead_end", null), new Room(manager, "arcana/deadend/lava_dead_end", degraded), new Room(manager, "arcana/deadend/lord_vatticus_study", degraded), new Room(manager, "arcana/deadend/tar_dead_end_arcanium", degraded), new Room(manager, "arcana/deadend/war_general_chamber", ancientBrick), new Room(manager, "arcana/deadend/roamer_chamber", null)};
            hallways = new Room[]{new Room(manager, "arcana/hallway/dungeon_prison", degraded), new Room(manager, "arcana/hallway/dungeon_prison_broken", degraded), new Room(manager, "arcana/hallway/heat_trap_hallway", null), new Room(manager, "arcana/hallway/leorna_garden", ancientBrick), new Room(manager, "arcana/hallway/tar_hallway", degraded), new Room(manager, "arcana/hallway/utility_hallway", ancientBrick), new Room(manager, "arcana/hallway/v_hallway", degraded)};
            junctions = new Room[]{new Room(manager, "arcana/junction/degraded_junction", degraded), new Room(manager, "arcana/junction/heat_trap_junction", null), new Room(manager, "arcana/junction/metal", sludge), new Room(manager, "arcana/junction/mound_junction", ancient), new Room(manager, "arcana/junction/serpentine_junction", ancientBrick), new Room(manager, "arcana/junction/trident_junction", ancientBrick), new Room(manager, "arcana/junction/utility_room_junction", degraded), new Room(manager, "arcana/junction/v_junction", ancientBrick)};
            corners = new Room[]{new Room(manager, "arcana/corner/kazari_prison", degraded), new Room(manager, "arcana/corner/delta_corner", ancientBrick), new Room(manager, "arcana/corner/heat_trap_corner", degraded), junctions[2], new Room(manager, "arcana/corner/blocky_corner", degraded)};
            hidden = new Room[]{new Room(manager, "arcana/hidden/secret_garden", ancientBrick), new Room(manager, "arcana/hidden/power_core", null)};
            verticalRooms = new VerticalRoom[]{new VerticalRoom(manager, "arcana/vertical/ramp_hallway", ancientBrick, null), new VerticalRoom(manager, "arcana/vertical/any/staircase", degraded, null), new VerticalRoom(manager, "arcana/vertical/any/spiral_staircase", ancientBrick, null), new VerticalRoom(manager, "arcana/vertical/any/pyramid", ancientBrick, doors[1]), new VerticalRoom(manager, "arcana/vertical/living_statue_corner", null, doors[2])};
            bigRooms = new BigRoom[]{new BigRoom(manager, "arcana/big/library"), new BigRoom(manager, "arcana/big/dramix_room"), new BigRoom(manager, "arcana/big/parasecta_room")};
        }
        if (seed != (newSeed = level.m_7328_())) {
            dungeonNoise = NormalNoise.m_230504_((RandomSource)new XoroshiroRandomSource(newSeed), (int)1, (double[])new double[]{1.5});
            seed = newSeed;
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                ArcanaDungeon.setBlock(level, pos.m_7918_(x, 32, z), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "ancient_stone"))).m_49966_());
                ArcanaDungeon.setBlock(level, pos.m_7918_(x, 33, z), ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "ancient_stone_breakable"))).m_49966_());
            }
        }
        if (this.generate(level, random, pos, (byte)0)) {
            if (this.generate(level, random, pos.m_7918_(0, 8, 0), (byte)1)) {
                if (this.generate(level, random, pos.m_7918_(0, 16, 0), (byte)2)) {
                    this.generate(level, random, pos.m_7918_(0, 24, 0), (byte)3);
                }
            } else {
                this.generate(level, random, pos.m_7918_(0, 24, 0), (byte)3);
            }
        } else if (this.generate(level, random, pos.m_7918_(0, 16, 0), (byte)2)) {
            this.generate(level, random, pos.m_7918_(0, 24, 0), (byte)3);
        }
        return true;
    }

    public boolean generate(WorldGenLevel level, RandomSource random, BlockPos pos, byte layer) {
        int chunkX = pos.m_123341_() / 16;
        int chunkZ = pos.m_123343_() / 16;
        int y = layer * 256;
        if (layer < 3) {
            if (ArcanaDungeon.wantsBigRoom(chunkX, y, chunkZ)) {
                byte doorValue = (byte)(ArcanaDungeon.getDoorValue((chunkX - (chunkX < 0 ? 1 : 0)) / 2, y, (chunkZ - (chunkZ < 0 ? 1 : 0)) / 2) % 4);
                bigRooms[doorValue == 1 ? 1 : (doorValue == 2 ? 2 : 0)].gen(level, random, pos, chunkX % 2, chunkZ % 2);
            } else {
                byte roomShape = ArcanaDungeon.getRoomShape(chunkX, y, chunkZ);
                byte doorAmount = ArcanaDungeon.getDoorAmount(chunkX, y, chunkZ);
                if (random.m_188503_(16) == 0 && !ArcanaDungeon.wantsBigRoom(chunkX, y + 256, chunkZ)) {
                    this.genVertical(level, random, pos, roomShape, ArcanaDungeon.getRoomShape(chunkX, y + 256, chunkZ), doorAmount);
                } else {
                    this.genRegular(level, random, pos, roomShape, doorAmount);
                    return true;
                }
            }
            return false;
        }
        byte doorAmount = ArcanaDungeon.getDoorAmount(chunkX, y, chunkZ);
        if (doorAmount != 0 && random.m_188503_(92) == 0) {
            this.genEntrance(level, random, pos, ArcanaDungeon.getRoomShape(chunkX, y, chunkZ));
        } else {
            this.genRegular(level, random, pos, ArcanaDungeon.getRoomShape(chunkX, y, chunkZ), doorAmount);
        }
        return true;
    }

    private void genEntrance(WorldGenLevel level, RandomSource random, BlockPos pos, byte roomShape) {
        StructureRegistry.placeStructure(entranceRoom, level, random, pos.m_7918_(1, 0, 1), Rotation.NONE);
        ArcanaDungeon.genWalls(level, random, pos, ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "ancient_bricks"))).m_49966_(), roomShape, null);
        int y = 8;
        while (!level.m_8055_(pos.m_7918_(6, y, 6)).m_60795_()) {
            StructureRegistry.placeStructure(stairs, level, random, pos.m_7918_(6, y, 6), Rotation.NONE);
            y += 4;
        }
        StructureRegistry.placeStructure(stairsTop, level, random, pos.m_7918_(5, y - 1, 5), Rotation.NONE);
    }

    private void genVertical(WorldGenLevel level, RandomSource random, BlockPos pos, byte roomShape, byte upperRoomShape, byte doorAmount) {
        if (doorAmount == 2) {
            if (ArcanaDungeon.getsNorthEntrance(roomShape)) {
                if (ArcanaDungeon.hasEastDoor(roomShape)) {
                    verticalRooms[4].gen(level, random, pos, Rotation.NONE, roomShape, upperRoomShape);
                } else if (ArcanaDungeon.getsWestEntrance(roomShape)) {
                    verticalRooms[4].gen(level, random, pos, Rotation.COUNTERCLOCKWISE_90, roomShape, upperRoomShape);
                } else {
                    verticalRooms[0].gen(level, random, pos, Rotation.NONE, roomShape, upperRoomShape);
                }
            } else if (ArcanaDungeon.hasEastDoor(roomShape)) {
                if (ArcanaDungeon.hasSouthDoor(roomShape)) {
                    verticalRooms[4].gen(level, random, pos, Rotation.CLOCKWISE_90, roomShape, upperRoomShape);
                } else {
                    verticalRooms[0].gen(level, random, pos, Rotation.CLOCKWISE_90, roomShape, upperRoomShape);
                }
            } else {
                verticalRooms[4].gen(level, random, pos, Rotation.CLOCKWISE_180, roomShape, upperRoomShape);
            }
        } else {
            verticalRooms[1 + random.m_188503_(3)].gen(level, random, pos, Rotation.m_221990_((RandomSource)random), roomShape, upperRoomShape);
        }
    }

    private void genRegular(WorldGenLevel level, RandomSource random, BlockPos pos, byte roomShape, byte doorAmount) {
        if (random.m_188503_(6) == 0) {
            adaptiveRooms[random.m_188503_(adaptiveRooms.length)].gen(level, random, pos, Rotation.m_221990_((RandomSource)random), roomShape);
        } else if (doorAmount == 0) {
            hidden[random.m_188503_(hidden.length)].gen(level, random, pos, Rotation.NONE, roomShape);
        } else if (doorAmount == 1) {
            deadends[random.m_188503_(deadends.length)].gen(level, random, pos, ArcanaDungeon.getsNorthEntrance(roomShape) ? Rotation.NONE : (ArcanaDungeon.hasEastDoor(roomShape) ? Rotation.CLOCKWISE_90 : (ArcanaDungeon.hasSouthDoor(roomShape) ? Rotation.CLOCKWISE_180 : Rotation.COUNTERCLOCKWISE_90)), roomShape);
        } else if (doorAmount == 2) {
            if (ArcanaDungeon.getsNorthEntrance(roomShape)) {
                if (ArcanaDungeon.hasEastDoor(roomShape)) {
                    corners[random.m_188503_(corners.length)].gen(level, random, pos, Rotation.NONE, roomShape);
                } else if (ArcanaDungeon.getsWestEntrance(roomShape)) {
                    corners[random.m_188503_(corners.length)].gen(level, random, pos, Rotation.COUNTERCLOCKWISE_90, roomShape);
                } else {
                    hallways[random.m_188503_(hallways.length)].gen(level, random, pos, Rotation.NONE, roomShape);
                }
            } else if (ArcanaDungeon.hasEastDoor(roomShape)) {
                if (ArcanaDungeon.hasSouthDoor(roomShape)) {
                    corners[random.m_188503_(corners.length)].gen(level, random, pos, Rotation.CLOCKWISE_90, roomShape);
                } else {
                    hallways[random.m_188503_(hallways.length)].gen(level, random, pos, Rotation.CLOCKWISE_90, roomShape);
                }
            } else {
                corners[random.m_188503_(corners.length)].gen(level, random, pos, Rotation.CLOCKWISE_180, roomShape);
            }
        } else if (doorAmount == 3) {
            junctions[random.m_188503_(junctions.length)].gen(level, random, pos, !ArcanaDungeon.hasSouthDoor(roomShape) ? Rotation.NONE : (!ArcanaDungeon.getsWestEntrance(roomShape) ? Rotation.CLOCKWISE_90 : (!ArcanaDungeon.getsNorthEntrance(roomShape) ? Rotation.CLOCKWISE_180 : Rotation.COUNTERCLOCKWISE_90)), roomShape);
        } else {
            crossroads[random.m_188503_(crossroads.length)].gen(level, random, pos, Rotation.NONE, roomShape);
        }
    }

    public static boolean wantsBigRoom(int chunkX, int y, int chunkZ) {
        int xPart = chunkX % 2;
        int zPart = chunkZ % 2;
        return ArcanaDungeon.getDoorAmount(chunkX, y, chunkZ) == 0 || ArcanaDungeon.getDoorAmount(chunkX + 1 + (chunkX > -1 ? -2 : 2) * xPart, y, chunkZ) == 0 || ArcanaDungeon.getDoorAmount(chunkX, y, chunkZ + 1 + (chunkZ > -1 ? -2 : 2) * zPart) == 0 || ArcanaDungeon.getDoorAmount(chunkX + 1 + (chunkX > -1 ? -2 : 2) * xPart, y, chunkZ + 1 + (chunkZ > -1 ? -2 : 2) * zPart) == 0;
    }

    public static byte getRoomShape(int chunkX, int y, int chunkZ) {
        byte doorValue = ArcanaDungeon.getDoorValue(chunkX, y, chunkZ);
        byte hasXDoor = (byte)(doorValue % 2);
        byte hasZDoor = (byte)(doorValue / 2 % 2);
        byte hasXEntrance = (byte)(ArcanaDungeon.getDoorValue(chunkX - 1, y, chunkZ) % 2);
        byte hasZEntrance = (byte)(ArcanaDungeon.getDoorValue(chunkX, y, chunkZ - 1) / 2 % 2);
        return (byte)(hasXDoor + hasZDoor * 2 + hasXEntrance * 4 + hasZEntrance * 8);
    }

    public static byte getDoorAmount(int chunkX, int y, int chunkZ) {
        byte doorValue = ArcanaDungeon.getDoorValue(chunkX, y, chunkZ);
        byte hasXDoor = (byte)(doorValue % 2);
        byte hasZDoor = (byte)(doorValue / 2 % 2);
        byte hasXEntrance = (byte)(ArcanaDungeon.getDoorValue(chunkX - 1, y, chunkZ) % 2);
        byte hasZEntrance = (byte)(ArcanaDungeon.getDoorValue(chunkX, y, chunkZ - 1) / 2 % 2);
        return (byte)(hasXDoor + hasZDoor + hasXEntrance + hasZEntrance);
    }

    public static boolean getsWestEntrance(byte roomShape) {
        return roomShape / 4 % 2 == 1;
    }

    public static boolean getsNorthEntrance(byte roomShape) {
        return roomShape / 8 % 2 == 1;
    }

    public static boolean hasEastDoor(byte doorValue) {
        return doorValue % 2 == 1;
    }

    public static boolean hasEastDoor(int chunkX, int y, int chunkZ) {
        return ArcanaDungeon.getDoorValue(chunkX, y, chunkZ) % 2 == 1;
    }

    public static boolean hasSouthDoor(byte doorValue) {
        return doorValue / 2 % 2 == 1;
    }

    public static boolean hasSouthDoor(int chunkX, int y, int chunkZ) {
        return ArcanaDungeon.getDoorValue(chunkX, y, chunkZ) / 2 % 2 == 1;
    }

    public static byte getDoorValue(int chunkX, int y, int chunkZ) {
        byte value = 0;
        for (int steps = 0; value == 0 && steps < 16; steps = (int)((byte)(steps + 1))) {
            value = (byte)(Math.abs(dungeonNoise.m_75380_((double)(chunkX - 111 * steps), (double)(y + 112 * steps), (double)(chunkZ - 113 * steps))) * 15.7);
        }
        return value;
    }

    public static void placeRoom(StructureTemplate room, WorldGenLevel level, RandomSource random, BlockPos pos, Rotation rotation, byte getsWalls) {
        boolean b = rotation == Rotation.CLOCKWISE_180;
        pos = pos.m_7918_(b || rotation == Rotation.CLOCKWISE_90 ? 15 - getsWalls : (int)getsWalls, 0, b || rotation == Rotation.COUNTERCLOCKWISE_90 ? 15 - getsWalls : (int)getsWalls);
        room.m_230328_((ServerLevelAccessor)level, pos, pos, StructureRegistry.defaultSettings.m_74379_(rotation), random, 2);
    }

    public static void setBlock(WorldGenLevel level, BlockPos pos, BlockState block) {
        level.m_7731_(pos, block, 3);
    }

    public static void genDoors(WorldGenLevel level, RandomSource random, BlockPos pos, byte roomShape, @Nullable StructureTemplate door) {
        boolean b;
        boolean bl = b = door == null;
        if (ArcanaDungeon.hasEastDoor(roomShape)) {
            StructureRegistry.placeStructure(b ? (random.m_188503_(25) == 0 ? doors[random.m_188503_(doors.length)] : doorway) : door, level, random, pos.m_7918_(15, 1, 6), Rotation.CLOCKWISE_90);
        }
        if (ArcanaDungeon.hasSouthDoor(roomShape)) {
            StructureRegistry.placeStructure(b ? (random.m_188503_(25) == 0 ? doors[random.m_188503_(doors.length)] : doorway) : door, level, random, pos.m_7918_(9, 1, 15), Rotation.CLOCKWISE_180);
        }
        if (ArcanaDungeon.getsWestEntrance(roomShape)) {
            StructureRegistry.placeStructure(b ? (random.m_188503_(25) == 0 ? doors[random.m_188503_(doors.length)] : doorway) : door, level, random, pos.m_7918_(0, 1, 9), Rotation.COUNTERCLOCKWISE_90);
        }
        if (ArcanaDungeon.getsNorthEntrance(roomShape)) {
            StructureRegistry.placeStructure(b ? (random.m_188503_(25) == 0 ? doors[random.m_188503_(doors.length)] : doorway) : door, level, random, pos.m_7918_(6, 1, 0), Rotation.NONE);
        }
    }

    public static void genWalls(WorldGenLevel level, RandomSource random, BlockPos pos, BlockState wallBlock, byte roomShape, @Nullable StructureTemplate door) {
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 16; ++x) {
                ArcanaDungeon.setBlock(level, pos.m_7918_(x, y, 0), wallBlock);
                ArcanaDungeon.setBlock(level, pos.m_7918_(x, y, 15), wallBlock);
            }
            for (int z = 1; z < 15; ++z) {
                ArcanaDungeon.setBlock(level, pos.m_7918_(0, y, z), wallBlock);
                ArcanaDungeon.setBlock(level, pos.m_7918_(15, y, z), wallBlock);
            }
        }
        ArcanaDungeon.genDoors(level, random, pos, roomShape, door);
    }

    class Room {
        public final StructureTemplate room;
        public final BlockState wallBlock;

        public Room(StructureTemplateManager manager, @Nullable String location, BlockState wallBlock) {
            this.room = manager.m_230359_(new ResourceLocation("divinerpg", location));
            this.wallBlock = wallBlock;
        }

        public void gen(WorldGenLevel level, RandomSource random, BlockPos pos, Rotation rotation, byte roomShape) {
            boolean b;
            boolean bl = b = this.wallBlock != null;
            if (b) {
                ArcanaDungeon.genWalls(level, random, pos, this.wallBlock, roomShape, null);
            }
            ArcanaDungeon.placeRoom(this.room, level, random, pos, rotation, b ? (byte)1 : 0);
        }
    }

    class VerticalRoom {
        public final StructureTemplate room;
        public final StructureTemplate door;
        public final BlockState wallBlock;

        public VerticalRoom(StructureTemplateManager manager, @Nullable String location, @Nullable BlockState wallBlock, StructureTemplate upperRoomDoor) {
            this.room = manager.m_230359_(new ResourceLocation("divinerpg", location));
            this.wallBlock = wallBlock;
            this.door = upperRoomDoor;
        }

        public void gen(WorldGenLevel level, RandomSource random, BlockPos pos, Rotation rotation, byte roomShape, byte upperRoomShape) {
            boolean b;
            boolean bl = b = this.wallBlock != null;
            if (b) {
                ArcanaDungeon.genWalls(level, random, pos, this.wallBlock, roomShape, null);
                ArcanaDungeon.genWalls(level, random, pos.m_7918_(0, 8, 0), this.wallBlock, upperRoomShape, this.door);
            }
            ArcanaDungeon.placeRoom(this.room, level, random, pos, rotation, b ? (byte)1 : 0);
        }
    }

    class BigRoom {
        public final StructureTemplate room;

        public BigRoom(StructureTemplateManager manager, String room) {
            this.room = manager.m_230359_(new ResourceLocation("divinerpg", room));
        }

        public void gen(WorldGenLevel level, RandomSource random, BlockPos pos, int xPart, int zPart) {
            if (xPart == 0) {
                if (zPart == 0) {
                    ArcanaDungeon.placeRoom(this.room, level, random, pos, Rotation.NONE, (byte)0);
                } else {
                    ArcanaDungeon.placeRoom(this.room, level, random, pos, Rotation.COUNTERCLOCKWISE_90, (byte)0);
                }
            } else if (zPart == 0) {
                ArcanaDungeon.placeRoom(this.room, level, random, pos, Rotation.CLOCKWISE_90, (byte)0);
            } else {
                ArcanaDungeon.placeRoom(this.room, level, random, pos, Rotation.CLOCKWISE_180, (byte)0);
            }
        }
    }
}

