/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.tree;

import divinerpg.world.feature.config.tree.TreeConfig;
import divinerpg.world.feature.tree.DivineTree;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraftforge.registries.ForgeRegistries;

public class AuroraoakTree
extends DivineTree {
    protected void gradualGrowth(WorldGenLevel level, RandomSource random, BlockPos.MutableBlockPos pos, BlockState log, BlockState leaves, int maxY, float curvatureChance, float splitChance, boolean replace) {
        this.setBlock(level, (BlockPos)pos, log, replace);
        for (int y = 0; y <= maxY; ++y) {
            this.setBlock(level, (BlockPos)pos.m_122184_(random.m_188501_() < curvatureChance ? random.m_188503_(3) - 1 : 0, 1, random.m_188501_() < curvatureChance ? random.m_188503_(3) - 1 : 0), log, replace);
            if (!(random.m_188501_() < splitChance)) continue;
            this.gradualGrowth(level, random, new BlockPos.MutableBlockPos(pos.m_123341_() + random.m_188503_(3) - 1, pos.m_123342_(), pos.m_123343_() + random.m_188503_(3) - 1), log, leaves, maxY - y, curvatureChance + 0.08f, splitChance, replace);
        }
        this.growLeaves(level, random, (BlockPos)pos.m_122184_(0, 1, 0), leaves);
    }

    @Override
    protected boolean defaultGrowOn(BlockState state) {
        return state.m_204336_(BlockTags.f_144279_) || state.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "frozen_grass"))) || state.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "frozen_dirt"))) || state.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "frozen_stone"))) || state.m_60713_(Blocks.f_50354_) || state.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "cobbled_frozen_stone")));
    }

    @Override
    public boolean hasSpace(BlockState state) {
        return state.m_204336_(BlockTags.f_144279_) || super.hasSpace(state);
    }

    @Override
    public boolean place(TreeConfig config, WorldGenLevel level, ChunkGenerator chunkGen, RandomSource random, BlockPos pos) {
        if (this.canBeHere(level, random, pos, config)) {
            int treeType;
            int treeHeight;
            int extraHeight;
            if (level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_144279_)) {
                pos = pos.m_7495_();
            }
            if (this.heightCheck(level, pos, extraHeight = (treeHeight = (treeType = random.m_188503_(4)) == 0 ? 3 + random.m_188503_(3) : 4 + random.m_188503_(7)) + 2, 1)) {
                BlockState log = config.log;
                BlockState leaves = config.leaves;
                if (treeType == 0) {
                    this.grow(level, pos, log, 1, 0, true);
                    this.grow(level, random, pos.m_7494_(), log, 1, 0, true, 0.25f);
                    this.grow(level, pos, log, treeHeight, true);
                    this.grow(level, pos.m_7918_(0, treeHeight + 1, 0), leaves, extraHeight -= treeHeight);
                    this.grow(level, pos.m_7918_(0, treeHeight - 1, 0), leaves, extraHeight + 2, 1, 0);
                    int branchY = treeHeight - random.m_188503_(4);
                    int r = random.m_188503_(3);
                    extraHeight = treeHeight - branchY;
                    this.grow(level, random, pos.m_7918_(0, branchY - 1, 0), log, 1, 0, 0.2f);
                    this.growBranch(level, random, pos.m_7918_(-1, branchY, -1), log, leaves, r > extraHeight ? 0 : extraHeight - r, extraHeight, extraHeight > 1, false);
                    branchY = treeHeight - random.m_188503_(4);
                    r = random.m_188503_(3);
                    extraHeight = treeHeight - branchY;
                    this.growBranch(level, random, pos.m_7918_(1, branchY, 1), log, leaves, r > extraHeight ? 0 : extraHeight - r, extraHeight, extraHeight > 1, true);
                } else {
                    this.gradualGrowth(level, random, pos.m_122032_(), log, leaves, treeHeight, 0.2f, 0.1f, true);
                }
                return true;
            }
        }
        return false;
    }

    private void growBranch(WorldGenLevel level, RandomSource random, BlockPos pos, BlockState log, BlockState leaves, int height, int treeHeight, boolean shift, boolean direction) {
        if (height < 0) {
            return;
        }
        this.grow(level, pos, log, height, true);
        this.grow(level, pos.m_7918_(0, height + 1, 0), leaves, treeHeight - height);
        this.grow(level, shift ? pos.m_7918_(0, 1, 0) : pos, leaves, treeHeight - (shift ? 1 : 0), 1, 0);
        int r = random.m_188503_(3);
        int s = random.m_188503_(3) - 1;
        if (treeHeight > r) {
            this.growBranch(level, random, pos.m_7918_(direction ? 1 : -1, r, direction ? 1 : -1), log, leaves, height - r + s, treeHeight - r + s, false, direction);
        }
    }

    protected void growLeaves(WorldGenLevel level, RandomSource random, BlockPos pos, BlockState leaves) {
        int type = random.m_188503_(4);
        if (type == 3) {
            type = random.m_188503_(4);
        }
        this.grow(level, pos, leaves, 1, 1);
        this.grow(level, pos, leaves, 2, 2);
        if (type > 0) {
            this.grow(level, pos, leaves, 2, 0);
            if (type > 1) {
                this.grow(level, pos, leaves, 3, 0);
                if (type == 3) {
                    this.grow(level, pos, leaves, 4, 1);
                    this.grow(level, pos, leaves, 4, -1);
                    this.grow(level, pos.m_7918_(0, 2, 0), leaves, 2, 2);
                    this.grow(level, pos.m_7918_(0, 3, 0), leaves, 3, 0);
                    this.setBlock(level, pos.m_7918_(0, 4, 0), leaves, false);
                }
            }
        }
        this.grow(level, pos.m_7918_(0, 2, 0), leaves, 2, 0);
        pos = pos.m_7495_();
        this.grow(level, pos, leaves, 2 + (type == 3 ? 2 : type));
        this.grow(level, pos, leaves, 2, 1, 0);
        this.grow(level, pos.m_7495_(), leaves, 2, 0);
        if (type == 3) {
            this.grow(level, pos, leaves, 2, 1, 1);
            this.grow(level, pos, leaves, 2, 2, 1);
            this.grow(level, pos, leaves, 2, 2, 0);
            this.grow(level, pos, leaves, 2, 2, -1);
            this.grow(level, pos.m_7495_(), leaves, 2, 2);
            this.grow(level, pos.m_7918_(0, -2, 0), leaves, 3, 0);
        }
    }
}

