/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.tree;

import divinerpg.world.feature.config.tree.TreeConfig;
import divinerpg.world.feature.tree.SkythernTree;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.registries.ForgeRegistries;

public class FirewoodTree
extends SkythernTree {
    protected Direction direction;

    protected void directionalWideGrow(WorldGenLevel world, BlockPos pos, BlockState state, int width, int offset) {
        if (this.direction == Direction.UP || this.direction == Direction.DOWN) {
            this.wideGrow(world, pos, state, width, offset);
        } else if (this.direction == Direction.NORTH || this.direction == Direction.SOUTH) {
            this.m_5974_((LevelWriter)world, pos.m_7918_(offset, width + 1, 0), state);
            this.m_5974_((LevelWriter)world, pos.m_7918_(1 - offset, -width, 0), state);
            this.m_5974_((LevelWriter)world, pos.m_7918_(-width, offset, 0), state);
            this.m_5974_((LevelWriter)world, pos.m_7918_(width + 1, 1 - offset, 0), state);
        } else {
            this.m_5974_((LevelWriter)world, pos.m_7918_(0, width + 1, offset), state);
            this.m_5974_((LevelWriter)world, pos.m_7918_(0, -width, 1 - offset), state);
            this.m_5974_((LevelWriter)world, pos.m_7918_(0, offset, -width), state);
            this.m_5974_((LevelWriter)world, pos.m_7918_(0, 1 - offset, width + 1), state);
        }
    }

    @Override
    public boolean canBeHere(WorldGenLevel level, RandomSource random, BlockPos pos, TreeConfig config) {
        BlockState state = level.m_8055_(pos);
        if (config.growableOn.isEmpty() && this.defaultGrowOn(state)) {
            return this.searchForSpace(level, random, pos);
        }
        for (RuleTest test : config.growableOn) {
            if (!test.m_213865_(state, random)) continue;
            return this.searchForSpace(level, random, pos);
        }
        return false;
    }

    protected boolean searchForSpace(WorldGenLevel level, RandomSource random, BlockPos pos) {
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        for (int i = 0; i < n; ++i) {
            Direction dir;
            this.direction = dir = directionArray[i];
            if (!level.m_8055_(pos.m_121945_(this.direction)).m_60795_()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean defaultGrowOn(BlockState state) {
        return state.m_60713_((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "dream_stone"))) || state.m_204336_(BlockTags.f_144274_);
    }

    protected void placeBigTree(TreeConfig config, WorldGenLevel level, RandomSource random, BlockPos pos) {
        int treeHeight;
        this.wideGrow(level, pos, config.log, treeHeight, 0, 0);
        pos = pos.m_7918_(0, treeHeight, 0);
        this.wideGrow(level, pos, config.leaves, 2, 0, 0);
        this.wideGrow(level, pos, config.leaves, 1, 1, 0);
        this.wideGrow(level, pos, config.leaves, 1, 1, 1);
        this.wideGrow(level, pos, config.leaves, 1, 1, 2);
        this.wideGrow(level, pos, config.leaves, 2, -1);
        this.wideGrow(level, pos, config.leaves, 2, 0);
        this.wideGrow(level, pos, config.leaves, 2, 1);
        this.wideGrow(level, pos, config.leaves, 2, 2);
        this.wideGrow(level, pos, config.leaves, 2, 3);
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (treeHeight = 5 + random.m_188503_(8); random.m_188499_() && treeHeight > 0; --treeHeight) {
            mutable.m_122173_(Direction.DOWN);
            if (random.m_188499_()) {
                this.wideGrow(level, (BlockPos)mutable, config.leaves, 2, -1);
            }
            if (random.m_188499_()) {
                this.wideGrow(level, (BlockPos)mutable, config.leaves, 2, 0);
            }
            if (random.m_188499_()) {
                this.wideGrow(level, (BlockPos)mutable, config.leaves, 2, 1);
            }
            if (random.m_188499_()) {
                this.wideGrow(level, (BlockPos)mutable, config.leaves, 2, 2);
            }
            if (!random.m_188499_()) continue;
            this.wideGrow(level, (BlockPos)mutable, config.leaves, 2, 3);
        }
    }

    @Override
    public boolean place(TreeConfig config, WorldGenLevel level, ChunkGenerator chunkGen, RandomSource random, BlockPos pos) {
        if (this.canBeHere(level, random, pos, config)) {
            if (this.direction == Direction.UP && random.m_188503_(8) == 0) {
                this.placeBigTree(config, level, random, pos);
            } else if (random.m_188503_(3) == 0) {
                for (int size = 0; size < 3 + random.m_188503_(5); ++size) {
                    pos = pos.m_121945_(this.direction);
                    this.directionalWideGrow(level, pos, config.log, 0, 0);
                    if (!(random.m_188501_() < 0.2f)) continue;
                    this.direction = Direction.m_235672_((RandomSource)random);
                }
                this.directionalWideGrow(level, pos, config.leaves, 1, 0);
                this.directionalWideGrow(level, pos, config.leaves, 1, 1);
                pos = pos.m_121945_(this.direction);
                this.directionalWideGrow(level, pos, config.leaves, 0, 0);
                this.setBlock(level, pos.m_121945_(Direction.m_235672_((RandomSource)random)), config.leaves, false);
                this.setBlock(level, pos.m_121945_(this.direction), config.leaves, false);
            } else {
                for (int size = 0; size < 3 + random.m_188503_(9); ++size) {
                    pos = pos.m_121945_(this.direction);
                    this.setBlock(level, pos, config.log, true);
                    if (!(random.m_188501_() < 0.3f)) continue;
                    this.direction = Direction.m_235672_((RandomSource)random);
                }
                this.setBlock(level, pos.m_7494_(), config.leaves, false);
                this.setBlock(level, pos.m_122012_(), config.leaves, false);
                this.setBlock(level, pos.m_122029_(), config.leaves, false);
                this.setBlock(level, pos.m_122019_(), config.leaves, false);
                this.setBlock(level, pos.m_122024_(), config.leaves, false);
                this.setBlock(level, pos.m_7495_(), config.leaves, false);
            }
            return true;
        }
        return false;
    }
}

