/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.meter;

import com.github.almostreliable.energymeter.meter.MeterEntity;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class MeterBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final DirectionProperty BOTTOM = DirectionProperty.m_61546_((String)"bottom", (Predicate)Direction.Plane.HORIZONTAL);
    static final BooleanProperty IO = BooleanProperty.m_61465_((String)"io");

    public MeterBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(2.0f).m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_7820_().m_122424_();
        Direction bottom = context.m_8125_();
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)BOTTOM, (Comparable)(facing == Direction.DOWN ? bottom : bottom.m_122424_()))).m_61124_((Property)IO, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{BOTTOM});
        builder.m_61104_(new Property[]{IO});
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighbor, boolean isMoving) {
        super.m_6861_(state, level, pos, block, neighbor, isMoving);
        if (!state.m_155947_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MeterEntity) {
            MeterEntity entity = (MeterEntity)blockEntity;
            BlockState neighborState = level.m_8055_(neighbor);
            ResourceLocation registryName = BuiltInRegistries.f_256975_.m_7981_((Object)neighborState.m_60734_());
            if (!(neighborState.m_60795_() || neighborState.m_155947_() || registryName.m_135827_().equals("pipez"))) {
                return;
            }
            BlockPos vector = neighbor.m_121996_((Vec3i)pos);
            Direction direction = Direction.m_122378_((int)vector.m_123341_(), (int)vector.m_123342_(), (int)vector.m_123343_());
            if (direction == null) {
                return;
            }
            entity.updateCache(direction);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.m_5776_() || player.m_6144_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof MenuProvider) {
            MenuProvider entity = (MenuProvider)tile;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)entity, (BlockPos)pos);
            }
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MeterEntity(pos, state);
    }

    @Nullable
    public <E extends BlockEntity> BlockEntityTicker<E> m_142354_(Level level, BlockState state, BlockEntityType<E> entity) {
        if (level.f_46443_) {
            return null;
        }
        return (pLevel, pPos, pState, pEntity) -> {
            if (pEntity instanceof MeterEntity) {
                MeterEntity meter = (MeterEntity)pEntity;
                meter.tick();
            }
        };
    }
}

