/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.api.gaia;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class BlockPatternExtend {
    private static final Direction[] FLAT_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private final Predicate<BlockInWorld>[][][] pattern;
    private final int depth;
    private final int height;
    private final int width;

    public BlockPatternExtend(Predicate<BlockInWorld>[][][] pattern) {
        this.pattern = pattern;
        this.depth = pattern.length;
        if (this.depth > 0) {
            this.height = pattern[0].length;
            this.width = this.height > 0 ? pattern[0][0].length : 0;
        } else {
            this.height = 0;
            this.width = 0;
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    @VisibleForTesting
    public Predicate<BlockInWorld>[][][] getPattern() {
        return this.pattern;
    }

    @Nullable
    @VisibleForTesting
    public BlockPatternMatchSuccess matches(LevelReader level, BlockPos pos, Direction finger, Direction thumb) {
        LoadingCache<BlockPos, BlockInWorld> loadingcache = BlockPatternExtend.createLevelCache(level, false);
        return this.matches(pos, finger, thumb, loadingcache);
    }

    @Nullable
    private BlockPatternMatchSuccess matches(BlockPos pos, Direction finger, Direction thumb, LoadingCache<BlockPos, BlockInWorld> cache) {
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                for (int k = 0; k < this.depth; ++k) {
                    if (this.pattern[k][j][i].test((BlockInWorld)cache.getUnchecked((Object)BlockPatternExtend.translateAndRotate(pos, finger, thumb, i, j, k)))) continue;
                    return null;
                }
            }
        }
        return new BlockPatternMatchSuccess(pos, finger, thumb, cache, this.width, this.height, this.depth);
    }

    @VisibleForTesting
    public MatchResult matchesWithFailResult(LevelReader level, BlockPos pos, Direction finger, Direction thumb) {
        LoadingCache<BlockPos, BlockInWorld> loadingcache = BlockPatternExtend.createLevelCache(level, false);
        HashMap<BlockPos, Pair<Predicate<BlockInWorld>, BlockInWorld>> failCache = new HashMap<BlockPos, Pair<Predicate<BlockInWorld>, BlockInWorld>>();
        return this.matchesWithFailResult(pos, finger, thumb, loadingcache, failCache);
    }

    private MatchResult matchesWithFailResult(BlockPos pos, Direction finger, Direction thumb, LoadingCache<BlockPos, BlockInWorld> cache, Map<BlockPos, Pair<Predicate<BlockInWorld>, BlockInWorld>> failCache) {
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                for (int k = 0; k < this.depth; ++k) {
                    Predicate<BlockInWorld> predicate = this.pattern[k][j][i];
                    BlockPos checkPos = BlockPatternExtend.translateAndRotate(pos, finger, thumb, i, j, k);
                    BlockInWorld block = (BlockInWorld)cache.getUnchecked((Object)checkPos);
                    if (predicate.test(block)) continue;
                    failCache.put(checkPos, (Pair<Predicate<BlockInWorld>, BlockInWorld>)Pair.of(predicate, (Object)block));
                }
            }
        }
        if (!failCache.isEmpty()) {
            return new BlockPatternMatchFail(failCache, finger, thumb);
        }
        return new BlockPatternMatchSuccess(pos, finger, thumb, cache, this.width, this.height, this.depth);
    }

    @Nullable
    public BlockPatternMatchSuccess find(LevelReader level, BlockPos pos) {
        LoadingCache<BlockPos, BlockInWorld> loadingcache = BlockPatternExtend.createLevelCache(level, false);
        int i = Math.max(Math.max(this.width, this.height), this.depth);
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos, (BlockPos)pos.m_7918_(i - 1, i - 1, i - 1))) {
            for (Direction direction : Direction.values()) {
                for (Direction direction1 : Direction.values()) {
                    BlockPatternMatchSuccess matches;
                    if (direction1 == direction || direction1 == direction.m_122424_() || (matches = this.matches(blockpos, direction, direction1, loadingcache)) == null) continue;
                    return matches;
                }
            }
        }
        return null;
    }

    @Deprecated
    public MatchResult findWithFailResult(LevelReader level, BlockPos pos) {
        LoadingCache<BlockPos, BlockInWorld> loadingcache = BlockPatternExtend.createLevelCache(level, false);
        int i = Math.max(Math.max(this.width, this.height), this.depth);
        ArrayList<BlockPatternMatchFail> fails = new ArrayList<BlockPatternMatchFail>();
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos, (BlockPos)pos.m_7918_(i - 1, i - 1, i - 1))) {
            for (Direction direction : Direction.values()) {
                for (Direction direction1 : Direction.values()) {
                    if (direction1 == direction || direction1 == direction.m_122424_()) continue;
                    HashMap<BlockPos, Pair<Predicate<BlockInWorld>, BlockInWorld>> failCache = new HashMap<BlockPos, Pair<Predicate<BlockInWorld>, BlockInWorld>>();
                    MatchResult matches = this.matchesWithFailResult(blockpos, direction, direction1, loadingcache, failCache);
                    if (matches instanceof BlockPatternMatchSuccess) {
                        BlockPatternMatchSuccess success = (BlockPatternMatchSuccess)matches;
                        return success;
                    }
                    if (!(matches instanceof BlockPatternMatchFail)) continue;
                    BlockPatternMatchFail fail = (BlockPatternMatchFail)matches;
                    fails.add(fail);
                }
            }
        }
        return fails.stream().min(Comparator.comparingInt(BlockPatternMatchFail::size)).orElse(null);
    }

    @Deprecated
    public MatchResult findFlatWithFailResult(LevelReader level, BlockPos pos) {
        LoadingCache<BlockPos, BlockInWorld> loadingcache = BlockPatternExtend.createLevelCache(level, false);
        int i = Math.max(Math.max(this.width, this.height), this.depth);
        ArrayList<BlockPatternMatchFail> fails = new ArrayList<BlockPatternMatchFail>();
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos, (BlockPos)pos.m_7918_(i - 1, i - 1, i - 1))) {
            for (Direction direction : FLAT_DIRECTIONS) {
                HashMap<BlockPos, Pair<Predicate<BlockInWorld>, BlockInWorld>> failCache = new HashMap<BlockPos, Pair<Predicate<BlockInWorld>, BlockInWorld>>();
                MatchResult matches = this.matchesWithFailResult(blockpos, Direction.DOWN, direction, loadingcache, failCache);
                if (matches instanceof BlockPatternMatchSuccess) {
                    BlockPatternMatchSuccess success = (BlockPatternMatchSuccess)matches;
                    return success;
                }
                if (!(matches instanceof BlockPatternMatchFail)) continue;
                BlockPatternMatchFail fail = (BlockPatternMatchFail)matches;
                fails.add(fail);
            }
        }
        return fails.stream().min(Comparator.comparingInt(BlockPatternMatchFail::size)).orElse(null);
    }

    @Nullable
    public BlockPatternMatchSuccess findFlat(LevelReader level, BlockPos pos) {
        LoadingCache<BlockPos, BlockInWorld> loadingcache = BlockPatternExtend.createLevelCache(level, false);
        int i = Math.max(Math.max(this.width, this.height), this.depth);
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos, (BlockPos)pos.m_7918_(i - 1, i - 1, i - 1))) {
            for (Direction direction : FLAT_DIRECTIONS) {
                BlockPatternMatchSuccess match = this.matches(blockpos, Direction.DOWN, direction, loadingcache);
                if (match == null) continue;
                return match;
            }
        }
        return null;
    }

    public static LoadingCache<BlockPos, BlockInWorld> createLevelCache(LevelReader level, boolean forceLoad) {
        return CacheBuilder.newBuilder().build((CacheLoader)new BlockCacheLoader(level, forceLoad));
    }

    protected static BlockPos translateAndRotate(BlockPos pos, Direction finger, Direction thumb, int palmOffset, int thumbOffset, int fingerOffset) {
        if (finger != thumb && finger != thumb.m_122424_()) {
            Vec3i vec3i = new Vec3i(finger.m_122429_(), finger.m_122430_(), finger.m_122431_());
            Vec3i vec3i1 = new Vec3i(thumb.m_122429_(), thumb.m_122430_(), thumb.m_122431_());
            Vec3i vec3i2 = vec3i.m_7724_(vec3i1);
            return pos.m_7918_(vec3i1.m_123341_() * -thumbOffset + vec3i2.m_123341_() * palmOffset + vec3i.m_123341_() * fingerOffset, vec3i1.m_123342_() * -thumbOffset + vec3i2.m_123342_() * palmOffset + vec3i.m_123342_() * fingerOffset, vec3i1.m_123343_() * -thumbOffset + vec3i2.m_123343_() * palmOffset + vec3i.m_123343_() * fingerOffset);
        }
        throw new IllegalArgumentException("Invalid forwards & up combination");
    }

    public static class BlockPatternMatchSuccess
    extends MatchResult {
        private final BlockPos frontTopLeft;
        private final LoadingCache<BlockPos, BlockInWorld> cache;
        private final int width;
        private final int height;
        private final int depth;

        public BlockPatternMatchSuccess(BlockPos frontTopLeft, Direction forwards, Direction up, LoadingCache<BlockPos, BlockInWorld> cache, int width, int height, int depth) {
            super(forwards, up);
            this.frontTopLeft = frontTopLeft;
            this.cache = cache;
            this.width = width;
            this.height = height;
            this.depth = depth;
        }

        public BlockPos getFrontTopLeft() {
            return this.frontTopLeft;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getDepth() {
            return this.depth;
        }

        public BlockInWorld getBlock(int palmOffset, int thumbOffset, int fingerOffset) {
            return (BlockInWorld)this.cache.getUnchecked((Object)BlockPatternExtend.translateAndRotate(this.frontTopLeft, this.getForwards(), this.getUp(), palmOffset, thumbOffset, fingerOffset));
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("up", (Object)this.getUp()).add("forwards", (Object)this.getForwards()).add("frontTopLeft", (Object)this.frontTopLeft).toString();
        }
    }

    public static class MatchResult {
        private final Direction forwards;
        private final Direction up;

        public MatchResult(Direction forwards, Direction up) {
            this.forwards = forwards;
            this.up = up;
        }

        public Direction getForwards() {
            return this.forwards;
        }

        public Direction getUp() {
            return this.up;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("up", (Object)this.getUp()).add("forwards", (Object)this.getForwards()).toString();
        }
    }

    public static class BlockPatternMatchFail
    extends MatchResult {
        private final Map<BlockPos, Pair<Predicate<BlockInWorld>, BlockInWorld>> failedBlocks;

        public BlockPatternMatchFail(Map<BlockPos, Pair<Predicate<BlockInWorld>, BlockInWorld>> failedBlocks, Direction finger, Direction thumb) {
            super(finger, thumb);
            this.failedBlocks = failedBlocks;
        }

        public Map<BlockPos, Pair<Predicate<BlockInWorld>, BlockInWorld>> getFailedBlocks() {
            return this.failedBlocks;
        }

        public int size() {
            return this.failedBlocks.size();
        }
    }

    static class BlockCacheLoader
    extends CacheLoader<BlockPos, BlockInWorld> {
        private final LevelReader level;
        private final boolean loadChunks;

        public BlockCacheLoader(LevelReader level, boolean loadChunks) {
            this.level = level;
            this.loadChunks = loadChunks;
        }

        public BlockInWorld load(BlockPos pos) {
            return new BlockInWorld(this.level, pos, this.loadChunks);
        }
    }
}

