/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.api.item;

import io.github.lounode.extrabotany.common.item.relic.void_archives.VoidArchivesItem;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.Relic;
import vazkii.botania.xplat.XplatAbstractions;

public interface VoidArchivesVariant {
    public static final VoidArchivesVariant DEFAULT = () -> "default";

    public String getId();

    default public void onActive(ItemStack stack) {
    }

    default public void onInactive(ItemStack stack) {
    }

    default public boolean isActive(ItemStack stack) {
        return VoidArchivesItem.getVariant(stack).getId().equals(this.getId());
    }

    default public boolean isMaster(ItemStack stack, Player player) {
        Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
        return relic != null && relic.isRightPlayer(player);
    }

    default public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    default public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
    }

    default public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
    }

    default public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
    }

    default public void onDestroyed(ItemEntity itemEntity) {
    }

    default public InteractionResult useOn(UseOnContext context) {
        return InteractionResult.PASS;
    }

    default public float getDestroySpeed(ItemStack stack, BlockState state) {
        return 1.0f;
    }

    default public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        return stack;
    }

    default public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        return false;
    }

    default public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        return false;
    }

    default public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return false;
    }

    default public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        return false;
    }

    default public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        return InteractionResult.PASS;
    }

    default public Component getName(ItemStack stack) {
        return Component.m_237115_((String)"item.extrabotany.void_archives");
    }

    default public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    default public int getUseDuration(ItemStack stack) {
        return 0;
    }

    default public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
    }

    default public boolean useOnRelease(ItemStack stack) {
        return false;
    }
}

