/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.client.gui;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.github.lounode.extrabotany.client.gui.GaiaLerpingBossEvent;
import io.github.lounode.extrabotany.common.bossevents.GaiaBossEvent;
import io.github.lounode.extrabotany.network.clientbound.ColorfulBossEventPacket;
import io.github.lounode.extrabotany.network.clientbound.GaiaBossEventPacket;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.joml.Matrix4f;
import vazkii.botania.client.core.helper.CoreShaders;
import vazkii.botania.client.core.helper.RenderHelper;

public class ColorfulBossBarOverlay {
    public static final ResourceLocation BAR_TEXTURE = ResourceLocation.m_135820_((String)"botania:textures/gui/boss_bar.png");
    private static final ResourceLocation GUI_BARS_LOCATION = ResourceLocation.m_135820_((String)"textures/gui/bars.png");
    private static final int BAR_WIDTH = 182;
    private static final int BAR_HEIGHT = 5;
    private static final int OVERLAY_OFFSET = 80;
    private final Minecraft minecraft;
    final Map<UUID, GaiaLerpingBossEvent> events = Maps.newLinkedHashMap();

    public ColorfulBossBarOverlay(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public void render(GuiGraphics gui) {
        if (this.events.isEmpty()) {
            return;
        }
        int guiWidth = gui.m_280182_();
        int x = guiWidth / 2 - 91;
        int y = 12;
        for (GaiaLerpingBossEvent event : this.events.values()) {
            int frameU = 0;
            int frameV = 0;
            int frameWidth = 185;
            int frameHeight = 15;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Component name = event.m_18861_();
            int centerX = this.minecraft.m_91268_().m_85445_() / 2;
            gui.m_280653_(this.minecraft.f_91062_, name, centerX, y - 10, 10617228);
            int healthU = 0;
            int healthV = frameV + frameHeight;
            int healthWidth = 181;
            int healthHeight = 7;
            int healthX = x + (frameWidth - healthWidth) / 2;
            int healthY = y + (frameHeight - healthHeight) / 2;
            RenderHelper.drawTexturedModalRect((GuiGraphics)gui, (ResourceLocation)BAR_TEXTURE, (int)x, (int)y, (int)frameU, (int)frameV, (int)frameWidth, (int)frameHeight);
            ColorfulBossBarOverlay.drawHealthBar(gui, event, healthX, healthY, healthU, healthV, (int)((float)healthWidth * event.m_142717_()), healthHeight);
            int px = x + 160;
            int py = y + 12;
            if (event.displayPlayerCount()) {
                ColorfulBossBarOverlay.drawPlayerCount(event.getPlayerCount(), gui, px, py);
            }
            if ((y += frameHeight * 2) < gui.m_280206_() / 3) continue;
            break;
        }
    }

    public static void drawPlayerCount(int playerCount, GuiGraphics gui, int x, int y) {
        PoseStack ps = gui.m_280168_();
        ps.m_85836_();
        Minecraft mc = Minecraft.m_91087_();
        ItemStack stack = new ItemStack((ItemLike)Items.f_42680_);
        gui.m_280480_(stack, x, y);
        gui.m_280488_(mc.f_91062_, Integer.toString(playerCount), x + 15, y + 4, 0xFFFFFF);
        ps.m_85849_();
    }

    public static void drawBar(GuiGraphics guiGraphics, int x, int y, BossEvent bossEvent) {
        ColorfulBossBarOverlay.drawBar(guiGraphics, x, y, bossEvent, 182, 0);
        int i = (int)(bossEvent.m_142717_() * 183.0f);
        if (i > 0) {
            ColorfulBossBarOverlay.drawBar(guiGraphics, x, y, bossEvent, i, 5);
        }
    }

    public static void drawBar(GuiGraphics guiGraphics, int x, int y, BossEvent bossEvent, int width, int height) {
        guiGraphics.m_280218_(GUI_BARS_LOCATION, x, y, 0, bossEvent.m_18862_().ordinal() * 5 * 2 + height, width, 5);
        if (bossEvent.m_18863_() != BossEvent.BossBarOverlay.PROGRESS) {
            RenderSystem.enableBlend();
            guiGraphics.m_280218_(GUI_BARS_LOCATION, x, y, 0, 80 + (bossEvent.m_18863_().ordinal() - 1) * 5 * 2 + height, width, 5);
            RenderSystem.disableBlend();
        }
    }

    public static void drawHealthBar(GuiGraphics gui, GaiaBossEvent bossEvent, int x, int y, int u, int v, int w, int h) {
        BossEvent event = (BossEvent)bossEvent;
        ShaderInstance shader = CoreShaders.dopplegangerBar();
        if (shader != null) {
            float grainIntensity = bossEvent.getGrainIntensity();
            shader.m_173356_("BotaniaGrainIntensity").m_5985_(grainIntensity);
            shader.m_173356_("BotaniaHpFract").m_5985_(event.m_142717_());
        }
        float minU = (float)u / 256.0f;
        float maxU = (float)(u + w) / 256.0f;
        float minV = (float)v / 256.0f;
        float maxV = (float)(v + h) / 256.0f;
        Matrix4f matrix = gui.m_280168_().m_85850_().m_252922_();
        RenderSystem.setShader(CoreShaders::dopplegangerBar);
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        builder.m_252986_(matrix, (float)x, (float)(y + h), 0.0f).m_7421_(minU, maxV).m_5752_();
        builder.m_252986_(matrix, (float)(x + w), (float)(y + h), 0.0f).m_7421_(maxU, maxV).m_5752_();
        builder.m_252986_(matrix, (float)(x + w), (float)y, 0.0f).m_7421_(maxU, minV).m_5752_();
        builder.m_252986_(matrix, (float)x, (float)y, 0.0f).m_7421_(minU, minV).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }

    public void update(ColorfulBossEventPacket packet) {
        packet.dispatch(new GaiaBossEventPacket.Handler(){

            @Override
            public void updatePlayerCount(UUID uuid, int playerCount) {
                ColorfulBossBarOverlay.this.events.get(uuid).setPlayerCount(playerCount);
            }

            @Override
            public void updateGrainTime(UUID uuid, int time) {
                ColorfulBossBarOverlay.this.events.get(uuid).setGrainTime(time);
            }

            @Override
            public void add(UUID uuid, Component name, float progress, BossEvent.BossBarColor bossBarColor, BossEvent.BossBarOverlay overlay, boolean darkenScreen, boolean playMusic, boolean createWorldFog) {
                ColorfulBossBarOverlay.this.events.put(uuid, new GaiaLerpingBossEvent(uuid, name, progress, bossBarColor, overlay, darkenScreen, playMusic, createWorldFog));
            }

            @Override
            public void remove(UUID uuid) {
                ColorfulBossBarOverlay.this.events.remove(uuid);
            }

            @Override
            public void updateProgress(UUID uuid, float progress) {
                ColorfulBossBarOverlay.this.events.get(uuid).m_142711_(progress);
            }

            @Override
            public void updateName(UUID uuid, Component name) {
                ColorfulBossBarOverlay.this.events.get(uuid).m_6456_(name);
            }

            @Override
            public void updateStyle(UUID uuid, BossEvent.BossBarColor bossBarColor, BossEvent.BossBarOverlay overlay) {
                LerpingBossEvent lerpingbossevent = ColorfulBossBarOverlay.this.events.get(uuid);
                lerpingbossevent.m_6451_(bossBarColor);
                lerpingbossevent.m_5648_(overlay);
            }

            @Override
            public void updateProperties(UUID uuid, boolean darkenScreen, boolean playMusic, boolean createWorldFog) {
                LerpingBossEvent lerpingbossevent = ColorfulBossBarOverlay.this.events.get(uuid);
                lerpingbossevent.m_7003_(darkenScreen);
                lerpingbossevent.m_7005_(playMusic);
                lerpingbossevent.m_7006_(createWorldFog);
            }
        });
    }

    public void reset() {
        this.events.clear();
    }

    public boolean shouldPlayMusic() {
        if (!this.events.isEmpty()) {
            for (BossEvent bossEvent : this.events.values()) {
                if (!bossEvent.m_18865_()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean shouldDarkenScreen() {
        if (!this.events.isEmpty()) {
            for (BossEvent bossEvent : this.events.values()) {
                if (!bossEvent.m_18864_()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean shouldCreateWorldFog() {
        if (!this.events.isEmpty()) {
            for (BossEvent bossEvent : this.events.values()) {
                if (!bossEvent.m_18866_()) continue;
                return true;
            }
        }
        return false;
    }
}

