/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.client.integration.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import io.github.lounode.extrabotany.api.recipe.ManaOutputRecipe;
import io.github.lounode.extrabotany.api.recipe.PedestalRecipe;
import io.github.lounode.extrabotany.client.integration.emi.ExtrabotanyEmiRecipe;
import io.github.lounode.extrabotany.client.integration.emi.recipe.PedestalEmiRecipe;
import io.github.lounode.extrabotany.common.block.ExtraBotanyBlocks;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.common.crafting.ExtraBotanyRecipeTypes;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import java.util.Comparator;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.StringUtils;

@EmiEntrypoint
public class EmiExtrabotanyPlugin
implements EmiPlugin {
    private static final Comparator<EmiRecipe> BY_ID = Comparator.comparing(EmiRecipe::getId, Comparator.nullsLast(Comparator.naturalOrder()));
    private static final Comparator<EmiRecipe> BY_GROUP = Comparator.comparing(emiRecipe -> {
        String string;
        if (emiRecipe instanceof ExtrabotanyEmiRecipe) {
            ExtrabotanyEmiRecipe ber = (ExtrabotanyEmiRecipe)((Object)emiRecipe);
            string = ber.getGroup();
        } else {
            string = "";
        }
        return string;
    });
    private static final Comparator<EmiRecipe> BY_CATALYST = Comparator.comparing(emiRecipe -> emiRecipe.getCatalysts().stream().flatMap(emiIngredient -> emiIngredient.getEmiStacks().stream()).map(emiStack -> emiStack.getId().toString()).filter(StringUtils::isNotEmpty).findFirst().orElse(""));
    private static final Comparator<EmiRecipe> BY_SMASH_TOOLS = (l, r) -> {
        if (l instanceof PedestalRecipe) {
            PedestalRecipe lp = (PedestalRecipe)l;
            if (r instanceof PedestalRecipe) {
                PedestalRecipe rp = (PedestalRecipe)r;
                Ingredient left = lp.getSmashTools();
                Ingredient right = rp.getSmashTools();
                return left.toString().compareTo(right.toString());
            }
        }
        return 0;
    };
    private static final Comparator<EmiRecipe> BY_MANA_OUTPUT = Comparator.comparing(emiRecipe -> {
        Integer n;
        if (emiRecipe instanceof ManaOutputRecipe) {
            ManaOutputRecipe recipe = (ManaOutputRecipe)emiRecipe;
            n = recipe.getManaOutput();
        } else {
            n = 0;
        }
        return n;
    }).reversed();
    public static final EmiRecipeCategory PEDESTAL_SMASH = EmiExtrabotanyPlugin.createCategory("pedestal_smash", (EmiRenderable)EmiStack.of((ItemLike)ExtraBotanyBlocks.livingrockPedestal), BY_SMASH_TOOLS.thenComparing(BY_GROUP).thenComparing(BY_ID));
    public static final EmiRecipeCategory STONESIA = EmiExtrabotanyPlugin.createCategory("stonesia", (EmiRenderable)EmiStack.of((ItemLike)ExtrabotanyFlowerBlocks.stonesia), BY_MANA_OUTPUT.thenComparing(BY_GROUP).thenComparing(BY_ID));

    public void register(EmiRegistry registry) {
        registry.addCategory(PEDESTAL_SMASH);
        registry.addCategory(STONESIA);
        for (Block pedestal : ExtraBotanyBlocks.ALL_PEDESTALS) {
            registry.addWorkstation(PEDESTAL_SMASH, (EmiIngredient)EmiStack.of((ItemLike)pedestal));
        }
        registry.addWorkstation(STONESIA, (EmiIngredient)EmiStack.of((ItemLike)ExtrabotanyFlowerBlocks.stonesia));
        registry.addWorkstation(STONESIA, (EmiIngredient)EmiStack.of((ItemLike)ExtrabotanyFlowerBlocks.stonesiaFloating));
        registry.setDefaultComparison((Object)ExtraBotanyItems.manaCocktail, Comparison.compareNbt());
        registry.setDefaultComparison((Object)ExtraBotanyItems.infiniteWine, Comparison.compareNbt());
        registry.setDefaultComparison((Object)ExtraBotanyItems.holyWaterGrenade, Comparison.compareNbt());
        for (PedestalRecipe recipe : registry.getRecipeManager().m_44013_(ExtraBotanyRecipeTypes.PEDESTAL_SMASH_TYPE)) {
            registry.addRecipe((EmiRecipe)new PedestalEmiRecipe(recipe));
        }
    }

    private static EmiRecipeCategory createCategory(String idPath, EmiRenderable icon, Comparator<EmiRecipe> comp) {
        return new EmiRecipeCategory(ResourceLocationHelper.prefix(idPath), icon, icon, comp);
    }
}

