/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.client.patchouli.processor;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.level.Level;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.mixin.AccessorSmithingTransformRecipe;
import vazkii.patchouli.mixin.AccessorSmithingTrimRecipe;

public class SmithingProcessor
implements IComponentProcessor {
    SmithingRecipe recipe;

    public void setup(Level level, IVariableProvider variables) {
        ResourceLocation id = ResourceLocation.m_135820_((String)variables.get("recipe").asString());
        this.recipe = (SmithingRecipe)PatchouliUtils.getRecipe((Level)level, (RecipeType)RecipeType.f_44113_, (ResourceLocation)id);
    }

    public IVariable process(Level level, String key) {
        if (this.recipe == null) {
            return null;
        }
        return switch (key) {
            case "base" -> PatchouliUtils.interweaveIngredients(List.of(this.getBase(this.recipe)));
            case "template" -> PatchouliUtils.interweaveIngredients(List.of(this.getTemplate(this.recipe)));
            case "addition" -> PatchouliUtils.interweaveIngredients(List.of(this.getAddition(this.recipe)));
            case "output" -> IVariable.from((Object)this.getRecipeOutput(level, this.recipe));
            case "symbol" -> IVariable.from((Object)this.recipe.m_8042_());
            case "heading" -> IVariable.from((Object)this.getRecipeOutput(level, this.recipe).m_41786_());
            default -> null;
        };
    }

    private Ingredient getBase(SmithingRecipe recipe) {
        if (recipe instanceof SmithingTrimRecipe) {
            return ((AccessorSmithingTrimRecipe)recipe).getBase();
        }
        if (recipe instanceof SmithingTransformRecipe) {
            return ((AccessorSmithingTransformRecipe)recipe).getBase();
        }
        return Ingredient.f_43901_;
    }

    private Ingredient getAddition(SmithingRecipe recipe) {
        if (recipe instanceof SmithingTrimRecipe) {
            return ((AccessorSmithingTrimRecipe)recipe).getAddition();
        }
        if (recipe instanceof SmithingTransformRecipe) {
            return ((AccessorSmithingTransformRecipe)recipe).getAddition();
        }
        return Ingredient.f_43901_;
    }

    private Ingredient getTemplate(SmithingRecipe recipe) {
        if (recipe instanceof SmithingTrimRecipe) {
            return ((AccessorSmithingTrimRecipe)recipe).getTemplate();
        }
        if (recipe instanceof SmithingTransformRecipe) {
            return ((AccessorSmithingTransformRecipe)recipe).getTemplate();
        }
        return Ingredient.f_43901_;
    }

    protected ItemStack getRecipeOutput(Level level, SmithingRecipe recipe) {
        if (recipe == null || level == null) {
            return ItemStack.f_41583_;
        }
        return recipe.m_8043_(level.m_9598_());
    }
}

