/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import java.util.Arrays;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class HasArmorSetTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("has_armor_set");
    public static final HasArmorSetTrigger INSTANCE = new HasArmorSetTrigger();

    public ResourceLocation m_7295_() {
        return ID;
    }

    public void trigger(ServerPlayer player) {
        super.m_66234_(player, instance -> instance.matches((Player)player));
    }

    protected TriggerInstance createInstance(JsonObject json, ContextAwarePredicate predicate, DeserializationContext context) {
        JsonObject armorJson = json.getAsJsonObject("armor");
        ItemPredicate[] predicates = new ItemPredicate[]{ItemPredicate.m_45051_((JsonElement)armorJson.get("head")), ItemPredicate.m_45051_((JsonElement)armorJson.get("chest")), ItemPredicate.m_45051_((JsonElement)armorJson.get("legs")), ItemPredicate.m_45051_((JsonElement)armorJson.get("feet"))};
        return new TriggerInstance(predicate, predicates);
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate[] armorPredicates;

        public TriggerInstance(ContextAwarePredicate predicate, ItemPredicate[] armorPredicates) {
            super(ID, predicate);
            this.armorPredicates = armorPredicates;
        }

        public static TriggerInstance forArmorSet(ItemStack[] armorSet) {
            ItemPredicate[] predicates = (ItemPredicate[])Arrays.stream(armorSet).map(item -> ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item.m_41720_()}).m_45077_()).toArray(ItemPredicate[]::new);
            return new TriggerInstance(ContextAwarePredicate.f_285567_, predicates);
        }

        public boolean matches(Player player) {
            if (player.m_6844_(EquipmentSlot.CHEST).m_150930_(ExtraBotanyItems.sanguinePleiadesCombatMaidSuit)) {
                return this.matchesDarkened(player);
            }
            return this.armorPredicates[0].m_45049_(player.m_6844_(EquipmentSlot.HEAD)) && this.armorPredicates[1].m_45049_(player.m_6844_(EquipmentSlot.CHEST)) && this.armorPredicates[2].m_45049_(player.m_6844_(EquipmentSlot.LEGS)) && this.armorPredicates[3].m_45049_(player.m_6844_(EquipmentSlot.FEET));
        }

        private boolean matchesDarkened(Player player) {
            return player.m_6844_(EquipmentSlot.HEAD).m_150930_(ExtraBotanyItems.pleiadesCombatMaidHeadgear) && this.armorPredicates[0].m_45049_(player.m_6844_(EquipmentSlot.HEAD)) && player.m_6844_(EquipmentSlot.LEGS).m_150930_(ExtraBotanyItems.pleiadesCombatMaidSkirt) && this.armorPredicates[2].m_45049_(player.m_6844_(EquipmentSlot.LEGS)) && player.m_6844_(EquipmentSlot.FEET).m_150930_(ExtraBotanyItems.pleiadesCombatMaidBoots) && this.armorPredicates[3].m_45049_(player.m_6844_(EquipmentSlot.FEET));
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject json = super.m_7683_(context);
            JsonObject armorJson = new JsonObject();
            armorJson.add("head", this.armorPredicates[0].m_45048_());
            armorJson.add("chest", this.armorPredicates[1].m_45048_());
            armorJson.add("legs", this.armorPredicates[2].m_45048_());
            armorJson.add("feet", this.armorPredicates[3].m_45048_());
            json.add("armor", (JsonElement)armorJson);
            return json;
        }
    }
}

