/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ItemUsedTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("item_used");
    public static final ItemUsedTrigger INSTANCE = new ItemUsedTrigger();

    public ResourceLocation m_7295_() {
        return ID;
    }

    public void trigger(ServerPlayer player, ItemStack stack, int count) {
        this.m_66234_(player, instance -> instance.matches(stack, count));
    }

    protected TriggerInstance createInstance(JsonObject json, ContextAwarePredicate predicate, DeserializationContext context) {
        ItemPredicate itemPredicate = ItemPredicate.m_45051_((JsonElement)json.get("item"));
        MinMaxBounds.Ints countPredicate = MinMaxBounds.Ints.m_55373_((JsonElement)json.get("count"));
        return new TriggerInstance(predicate, itemPredicate, countPredicate);
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate item;
        private final MinMaxBounds.Ints count;

        public TriggerInstance(ContextAwarePredicate predicate, ItemPredicate item, MinMaxBounds.Ints count) {
            super(ID, predicate);
            this.item = item;
            this.count = count;
        }

        public static TriggerInstance itemUsed(ItemPredicate item, MinMaxBounds.Ints count) {
            return new TriggerInstance(ContextAwarePredicate.f_285567_, item, count);
        }

        public boolean matches(ItemStack stack, int count) {
            return this.item.m_45049_(stack) && this.count.m_55390_(count);
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject json = super.m_7683_(context);
            json.add("item", this.item.m_45048_());
            json.add("count", this.count.m_55328_());
            return json;
        }
    }
}

