/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block;

import io.github.lounode.extrabotany.api.block.PedestalVariant;
import io.github.lounode.extrabotany.common.block.block_entity.ExtraBotanyBlockEntities;
import io.github.lounode.extrabotany.common.block.block_entity.PedestalBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;

public class PedestalBlock
extends BotaniaWaterloggedBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), Block.m_49796_((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)14.0, (double)13.0, (double)14.0, (double)20.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)20.0, (double)3.0), Block.m_49796_((double)2.0, (double)14.0, (double)3.0, (double)3.0, (double)20.0, (double)13.0), Block.m_49796_((double)13.0, (double)14.0, (double)3.0, (double)14.0, (double)20.0, (double)13.0)})});
    public final PedestalVariant variant;
    public static final BooleanProperty HAS_ITEM = BooleanProperty.m_61465_((String)"has_item");

    protected PedestalBlock(PedestalVariant v, BlockBehaviour.Properties builder) {
        super(builder);
        this.variant = v;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HAS_ITEM, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @NotNull
    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof PedestalBlockEntity)) {
            return InteractionResult.PASS;
        }
        PedestalBlockEntity pedestal = (PedestalBlockEntity)blockEntity;
        return pedestal.use(state, world, pos, player, hand, hit);
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new PedestalBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.f_46443_) {
            return PedestalBlock.createTickerHelper(type, ExtraBotanyBlockEntities.PEDESTAL, PedestalBlockEntity::clientTick);
        }
        return PedestalBlock.createTickerHelper(type, ExtraBotanyBlockEntities.PEDESTAL, PedestalBlockEntity::serverTick);
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof SimpleInventoryBlockEntity) {
                SimpleInventoryBlockEntity inventory = (SimpleInventoryBlockEntity)be;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)inventory.getItemHandler());
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof PedestalBlockEntity)) {
            return 0;
        }
        PedestalBlockEntity pedestal = (PedestalBlockEntity)blockEntity;
        return pedestal.getAnalogOutputSignal();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HAS_ITEM});
    }

    public static enum Variant implements PedestalVariant
    {
        LIVINGROCK,
        CALCITE;

    }
}

