/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.functional;

import io.github.lounode.extrabotany.api.block.Pedestal;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.common.lib.ExtraBotanyTags;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import io.github.lounode.extrabotany.common.util.SoundEventUtil;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.helper.PlayerHelper;

public class AnnoyingFlowerBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final String TAG_COOLDOWN = "cooldown";
    private static final String TAG_FOOD = "food";
    private static final int RANGE = 3;
    public static final int MAX_MANA = 1000;
    public static final int FISHING_COST = 300;
    public static final int COOLDOWN_AFTER_WORK = 900;
    public static final int FOOD_BOOST_TIMES = 3;
    public static final double FOOD_BOOST_COOLDOWN_MULTIPLIER = 0.4;
    public static final int FOOD_BOOST_MAX = 12;
    @Nullable
    private BlockPos cachedPedestalPos;
    private int cooldown;
    private int boostLeft;

    public AnnoyingFlowerBlockEntity(BlockPos pos, BlockState state) {
        super(ExtrabotanyFlowerBlocks.ANNOYINGFLOWER, pos, state);
    }

    public void tickFlower() {
        boolean boosted;
        super.tickFlower();
        if (this.m_58904_().m_5776_()) {
            return;
        }
        if (this.ticksExisted % 20 == 0) {
            this.sync();
        }
        this.tryEatChicken();
        if (this.getCooldown() > 0) {
            this.setCooldown(this.getCooldown() - 1);
            return;
        }
        if (this.getMaxMana() - this.getFishingCost() < 0) {
            return;
        }
        if (!this.hasWater()) {
            return;
        }
        boolean bl = boosted = this.getBoostLeft() > 0;
        if (boosted) {
            this.setBoostLeft(this.getBoostLeft() - 1);
        }
        RandomSource rand = this.m_58904_().m_213780_();
        ItemStack reward = this.getFishingLoot(boosted);
        int bound = 7;
        ItemEntity entity = new ItemEntity(this.m_58904_(), (double)(this.getEffectivePos().m_123341_() - 3 + rand.m_188503_(bound)), (double)(this.getEffectivePos().m_123342_() + 2), (double)(this.getEffectivePos().m_123343_() - 3 + rand.m_188503_(bound)), reward);
        this.addMana(-this.getFishingCost());
        int cooldown = this.getCooldownAfterWork();
        if (boosted) {
            cooldown = (int)((double)cooldown * this.getFoodBoostCooldownMultiplier());
        }
        this.setCooldown(cooldown);
        this.m_58904_().m_7967_((Entity)entity);
        this.m_58904_().m_5594_(null, this.getEffectivePos(), SoundEvents.f_11940_, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.sync();
        if (boosted) {
            List players = PlayerHelper.getRealPlayersIn((Level)this.m_58904_(), (AABB)new AABB(this.m_58899_()).m_82400_(16.0));
            for (Player player : players) {
                if (PlayerHelper.hasAdvancement((ServerPlayer)((ServerPlayer)player), (ResourceLocation)ResourceLocationHelper.prefix("main/muromi_san"))) continue;
                PlayerHelper.grantCriterion((ServerPlayer)((ServerPlayer)player), (ResourceLocation)ResourceLocationHelper.prefix("main/muromi_san"), (String)"code_triggered");
            }
        }
    }

    public void tryEatChicken() {
        for (ItemEntity item : this.m_58904_().m_45976_(ItemEntity.class, new AABB(this.getEffectivePos().m_7918_(-3, -3, -3), this.getEffectivePos().m_7918_(4, 4, 4)))) {
            ItemStack stack;
            if (!DelayHelper.canInteractWith((SpecialFlowerBlockEntity)this, (ItemEntity)item) || !(stack = item.m_32055_()).m_204117_(ExtraBotanyTags.Items.ANNOYING_FLOWER_EATABLE)) continue;
            EntityHelper.shrinkItem((ItemEntity)item);
            this.m_58904_().m_5594_(null, this.getEffectivePos(), SoundEvents.f_11947_, SoundSource.BLOCKS, 1.0f, SoundEventUtil.randomPitch(this.m_58904_()));
            this.m_58904_().m_142346_(null, GameEvent.f_223702_, this.m_58899_());
            int boostTime = Math.max(0, this.getBoostLeft() + this.getFoodBoostTimes());
            boostTime = Math.min(this.getFoodBoostMax(), boostTime);
            this.setBoostLeft(boostTime);
            this.sync();
            return;
        }
    }

    public ItemStack getFishingLoot(boolean boosted) {
        ServerLevel level = (ServerLevel)this.m_58904_();
        BlockPos pos = this.getEffectivePos();
        LootParams params = new LootParams.Builder(level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)Items.f_42523_.m_7968_()).m_287235_(LootContextParamSets.f_81414_);
        LootContext.Builder builder = new LootContext.Builder(params);
        ResourceLocation lootTable = boosted ? BuiltInLootTables.f_78722_ : BuiltInLootTables.f_78720_;
        ObjectArrayList loot = level.m_7654_().m_278653_().m_278676_(lootTable).m_287195_(params);
        return loot.isEmpty() ? ItemStack.f_41583_ : (ItemStack)loot.get(0);
    }

    public boolean hasWater() {
        BlockPos pos = this.getEffectivePos();
        if (this.cachedPedestalPos != null) {
            Pedestal pedestal;
            BlockEntity tile = this.m_58904_().m_7702_(this.cachedPedestalPos);
            if (tile instanceof Pedestal && (pedestal = (Pedestal)tile).getItem().m_150930_(Items.f_42447_)) {
                return true;
            }
            this.cachedPedestalPos = null;
        }
        for (BlockPos pos_ : BlockPos.m_121940_((BlockPos)pos.m_7918_(-3, 0, -3), (BlockPos)pos.m_7918_(3, 3, 3))) {
            Pedestal pedestal;
            BlockEntity tile = this.m_58904_().m_7702_(pos_);
            if (!(tile instanceof Pedestal) || !(pedestal = (Pedestal)tile).getItem().m_150930_(Items.f_42447_)) continue;
            this.cachedPedestalPos = pos_.m_7949_();
            return true;
        }
        return false;
    }

    public double getFoodBoostCooldownMultiplier() {
        return ExtraBotanyConfig.common().annoyingflowerFoodBoostCooldownMultiplier();
    }

    public int getFoodBoostMax() {
        return ExtraBotanyConfig.common().annoyingflowerFoodBoostMax();
    }

    public int getFoodBoostTimes() {
        return ExtraBotanyConfig.common().annoyingflowerFoodBoostTimes();
    }

    public int getCooldownAfterWork() {
        return ExtraBotanyConfig.common().annoyingflowerCooldown();
    }

    public int getFishingCost() {
        return ExtraBotanyConfig.common().annoyingflowerFishingCost();
    }

    public int getMaxMana() {
        return ExtraBotanyConfig.common().annoyingflowerMaxMana();
    }

    public int getColor() {
        return 0;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((BlockPos)this.getEffectivePos(), (int)3);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public int getBoostLeft() {
        return this.boostLeft;
    }

    public void setBoostLeft(int boostLeft) {
        this.boostLeft = boostLeft;
    }

    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_COOLDOWN, this.getCooldown());
        cmp.m_128405_(TAG_FOOD, this.getBoostLeft());
    }

    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.setCooldown(cmp.m_128451_(TAG_COOLDOWN));
        this.setBoostLeft(cmp.m_128451_(TAG_FOOD));
    }

    public static class WandHud
    extends BindableSpecialFlowerBlockEntity.BindableFlowerWandHud<AnnoyingFlowerBlockEntity> {
        public WandHud(AnnoyingFlowerBlockEntity flower) {
            super((BindableSpecialFlowerBlockEntity)flower);
        }

        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            MutableComponent component = Component.m_237110_((String)"message.extrabotany.gui.food_level", (Object[])new Object[]{((AnnoyingFlowerBlockEntity)this.flower).getBoostLeft()});
            int halfWidth = (mc.f_91062_.m_92852_((FormattedText)component) + 24) / 2;
            int centerX = mc.m_91268_().m_85445_() / 2;
            int centerY = mc.m_91268_().m_85446_() / 2;
            super.renderHUD(gui, mc, halfWidth + 2, halfWidth + 2, 48);
            gui.m_280430_(mc.f_91062_, (Component)component, centerX - halfWidth + 12, centerY + 34, 0xFFFFFF);
        }
    }
}

