/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.functional;

import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.common.util.PlayerUtil;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.xplat.BotaniaConfig;

public class WoodieniaBlockEntity
extends FunctionalFlowerBlockEntity {
    public static final String TAG_COOLDOWN = "cooldown";
    public static final String TAG_OWNER_UUID = "ownerUUID";
    private int cooldown;
    @Nullable
    private UUID ownerUUID;

    public WoodieniaBlockEntity(BlockPos pos, BlockState state) {
        super(ExtrabotanyFlowerBlocks.WOODIENIA, pos, state);
    }

    public boolean acceptsRedstone() {
        return true;
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().m_5776_()) {
            return;
        }
        if (this.ticksExisted % 20 == 0) {
            this.sync();
        }
        if (this.redstoneSignal > 0) {
            return;
        }
        if (this.getCooldown() > 0) {
            --this.cooldown;
            return;
        }
        if (this.getMana() < this.getManaPerUse()) {
            return;
        }
        BlockPos breakCoords = this.getValidBreakPos();
        if (breakCoords == null) {
            return;
        }
        Player player = null;
        if (this.getOwnerUUID().isPresent()) {
            player = PlayerUtil.createFakePlayer((ServerLevel)this.m_58904_(), this.getOwnerUUID().get());
        }
        WoodieniaBlockEntity.breakBlock(this.m_58904_(), breakCoords, player);
        this.setCooldown(this.getAfterEatCooldown());
        this.addMana(-this.getManaPerUse());
        this.sync();
    }

    @Nullable
    public BlockPos getValidBreakPos() {
        Object pos_2;
        HashMap<BlockPos, Float> coordsMap = new HashMap<BlockPos, Float>();
        Random rng = new Random();
        BlockPos pos = this.getEffectivePos();
        for (Object pos_2 : BlockPos.m_121940_((BlockPos)pos.m_7918_(-this.getRange().m_123341_(), 0, -this.getRange().m_123343_()), (BlockPos)pos.m_7918_(this.getRange().m_123341_(), this.getRange().m_123342_(), this.getRange().m_123343_()))) {
            BlockState state = this.m_58904_().m_8055_((BlockPos)pos_2);
            if (!state.m_204336_(BlockTags.f_13106_)) continue;
            coordsMap.put(pos_2.m_7949_(), Float.valueOf(2.0f * rng.nextFloat()));
        }
        if (coordsMap.isEmpty()) {
            return null;
        }
        float maxDistance = 0.0f;
        pos_2 = coordsMap.values().iterator();
        while (pos_2.hasNext()) {
            float distance = ((Float)pos_2.next()).floatValue();
            maxDistance = Math.max(maxDistance, distance);
        }
        float finalMaxDistance = maxDistance;
        coordsMap.values().removeIf(dist -> dist.floatValue() < finalMaxDistance - 1.0f);
        ArrayList coords = new ArrayList(coordsMap.keySet());
        BlockPos breakCoords = (BlockPos)coords.get(this.f_58857_.m_213780_().m_188503_(coords.size()));
        return breakCoords;
    }

    protected static void breakBlock(Level level, BlockPos pos, @Nullable Player player) {
        BlockState state = level.m_8055_(pos);
        if (player != null) {
            ToolCommons.removeBlockWithDrops((Player)player, (ItemStack)ItemStack.f_41583_, (Level)level, (BlockPos)pos, b -> true);
        } else {
            level.m_46961_(pos, true);
        }
        if (BotaniaConfig.common().blockBreakParticles()) {
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
        level.m_142346_(null, GameEvent.f_157794_, pos);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (placer instanceof Player) {
            Player player = (Player)placer;
            this.setOwnerUUID(player.m_36316_().getId());
        }
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int ticks) {
        this.cooldown = ticks;
    }

    public int getAfterEatCooldown() {
        return ExtraBotanyConfig.common().woodieniaCooldown();
    }

    public int getManaPerUse() {
        return ExtraBotanyConfig.common().woodieniaWorkManaCost();
    }

    public Vec3i getRange() {
        int[] range = ExtraBotanyConfig.common().woodieniaRange();
        return new Vec3i(range[0], range[1], range[2]);
    }

    public int getMaxMana() {
        return ExtraBotanyConfig.common().woodieniaMaxMana();
    }

    public int getColor() {
        return 0x664422;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Rectangle(this.getEffectivePos(), new AABB(this.getEffectivePos().m_7918_(-this.getRange().m_123341_(), 0, -this.getRange().m_123343_()), this.getEffectivePos().m_7918_(this.getRange().m_123341_() + 1, 0, this.getRange().m_123343_() + 1)));
    }

    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_COOLDOWN, this.getCooldown());
        this.getOwnerUUID().ifPresent(uuid -> cmp.m_128362_(TAG_OWNER_UUID, uuid));
    }

    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.cooldown = cmp.m_128451_(TAG_COOLDOWN);
        if (cmp.m_128441_(TAG_OWNER_UUID)) {
            this.setOwnerUUID(cmp.m_128342_(TAG_OWNER_UUID));
        }
    }

    public Optional<UUID> getOwnerUUID() {
        return this.ownerUUID == null ? Optional.empty() : Optional.of(this.ownerUUID);
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
    }
}

