/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.generating;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;

public class BloodEnchantressBlockEntity
extends GeneratingFlowerBlockEntity {
    private static final String TAG_BURN_TIME = "burnTime";
    private static final int RANGE = 1;
    public static final int MAX_MANA = 800;
    public static final int DENY_PRODUCE_LEVEL = 35;
    public static final int PRODUCE_MANA = 22;
    private int burnTime;
    private final LoadingCache<UUID, Integer> inhibitionEntityMap = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build(CacheLoader.from(() -> 0));

    public BloodEnchantressBlockEntity(BlockPos pos, BlockState state) {
        super(ExtrabotanyFlowerBlocks.BLOOD_ENCHANTRESS, pos, state);
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().m_5776_()) {
            return;
        }
        if (this.getBurnTime() > 0) {
            this.generateTick();
            this.setBurnTime(this.getBurnTime() - 1);
            return;
        }
        if (this.getMana() >= this.getMaxMana()) {
            return;
        }
        int inhibitionLevel = this.getInhibition();
        if (inhibitionLevel > 35) {
            return;
        }
        List<LivingEntity> entities = this.m_58904_().m_45976_(LivingEntity.class, new AABB(this.getEffectivePos()).m_82400_(1.0)).stream().filter(LivingEntity::m_6084_).toList();
        if (entities.isEmpty()) {
            return;
        }
        for (LivingEntity entity : entities) {
            int entityDamagedTime = (Integer)this.inhibitionEntityMap.getUnchecked((Object)entity.m_20148_());
            if (entityDamagedTime > 4 && entity.m_217043_().m_188499_()) continue;
            if (entityDamagedTime > 10) break;
            if (!entity.m_6469_(this.m_58904_().m_269111_().m_269264_(), 3.0f)) continue;
            this.addMana((int)(264.0f * (1.0f - 0.04f * (float)entityDamagedTime - 0.02f * (float)inhibitionLevel)));
            this.inhibitionEntityMap.put((Object)entity.m_20148_(), (Object)(entityDamagedTime + 1));
            this.setBurnTime(this.getBurnTime() + 20);
            this.sync();
        }
    }

    public void generateTick() {
        if (this.getMana() >= this.getMaxMana()) {
            return;
        }
        this.addMana(this.getProduceMana());
        this.sync();
    }

    public int getInhibition() {
        List<LivingEntity> entities = this.m_58904_().m_45976_(LivingEntity.class, new AABB(this.getEffectivePos()).m_82400_(1.0)).stream().filter(LivingEntity::m_6084_).toList();
        int inhibitionLevel = 0;
        for (LivingEntity entity : entities) {
            int entityDamagedTime = (Integer)this.inhibitionEntityMap.getUnchecked((Object)entity.m_20148_());
            inhibitionLevel += entityDamagedTime;
        }
        return inhibitionLevel;
    }

    public int getProduceMana() {
        return ExtraBotanyConfig.common().bloodEnchantressProduceMana();
    }

    public int getMaxMana() {
        return ExtraBotanyConfig.common().bloodEnchantressMaxMana();
    }

    public int getColor() {
        return 0x8B0000;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((BlockPos)this.getEffectivePos(), (int)1);
    }

    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_BURN_TIME, this.getBurnTime());
    }

    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.setBurnTime(cmp.m_128451_(TAG_BURN_TIME));
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }
}

