/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.generating;

import io.github.lounode.extrabotany.api.recipe.EdelweissRecipe;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.common.crafting.ExtraBotanyRecipeTypes;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.helper.PlayerHelper;

public class EdelweissBlockEntity
extends GeneratingFlowerBlockEntity {
    private static final String TAG_COOLDOWN = "cooldown";
    private static final int RANGE = 1;
    public static final int MAX_MANA = 12800;
    public static final int COOLDOWN = 40;
    private int cooldown;

    public EdelweissBlockEntity(BlockPos pos, BlockState state) {
        super(ExtrabotanyFlowerBlocks.EDELWEISS, pos, state);
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().m_5776_()) {
            return;
        }
        if (this.getCooldown() > 0) {
            this.setCooldown(this.getCooldown() - 1);
            return;
        }
        if (this.getMana() >= this.getMaxMana()) {
            return;
        }
        List<Entity> entitiesNearby = this.m_58904_().m_45976_(Entity.class, new AABB(this.getEffectivePos()).m_82400_(1.0)).stream().filter(entity -> this.getManaFromEntity((Entity)entity) > 0).toList();
        if (entitiesNearby.isEmpty()) {
            return;
        }
        Entity toEat = entitiesNearby.get(this.m_58904_().m_213780_().m_188503_(entitiesNearby.size()));
        int mana = this.getManaFromEntity(toEat);
        toEat.m_146870_();
        if (EntityType.f_20528_ == toEat.m_6095_()) {
            this.grantAdvancementToNearby();
            Vec3 pos = toEat.m_20182_();
            ((ServerLevel)this.m_58904_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50127_.m_49966_()), pos.f_82479_, pos.f_82480_, pos.f_82481_, 20, 0.5, 0.5, 0.5, 0.1);
            this.m_58904_().m_5594_(null, this.getEffectivePos(), SoundEvents.f_12474_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        this.addMana(mana);
        this.setCooldown(this.getAfterWorkCooldown());
        this.m_58904_().m_5594_(null, this.getEffectivePos(), SoundEvents.f_11911_, SoundSource.BLOCKS, 0.01f, 0.5f + (float)Math.random() * 0.5f);
        this.sync();
    }

    public void grantAdvancementToNearby() {
        List players = PlayerHelper.getRealPlayersIn((Level)this.m_58904_(), (AABB)new AABB(this.m_58899_()).m_82400_(16.0));
        for (Player player : players) {
            if (PlayerHelper.hasAdvancement((ServerPlayer)((ServerPlayer)player), (ResourceLocation)ResourceLocationHelper.prefix("main/its_only_the_fairy_tale"))) continue;
            PlayerHelper.grantCriterion((ServerPlayer)((ServerPlayer)player), (ResourceLocation)ResourceLocationHelper.prefix("main/its_only_the_fairy_tale"), (String)"code_triggered");
        }
    }

    public int getManaFromEntity(Entity entity) {
        for (Recipe recipe : ExtraBotanyRecipeTypes.getRecipes(this.m_58904_(), ExtraBotanyRecipeTypes.EDELWEISS_RECIPE_TYPE).values()) {
            EdelweissRecipe recipe2;
            if (!(recipe instanceof EdelweissRecipe) || !(recipe2 = (EdelweissRecipe)recipe).getInput().m_7484_(entity.m_6095_())) continue;
            return recipe2.getManaOutput();
        }
        return 0;
    }

    public int getAfterWorkCooldown() {
        return ExtraBotanyConfig.common().edelweissCooldown();
    }

    public int getMaxMana() {
        return ExtraBotanyConfig.common().edelweissMaxMana();
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public int getColor() {
        return 4286945;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((BlockPos)this.getEffectivePos(), (int)1);
    }

    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.setCooldown(cmp.m_128451_(TAG_COOLDOWN));
    }

    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_COOLDOWN, this.getCooldown());
    }
}

