/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.generating;

import io.github.lounode.extrabotany.api.block.PassiveFlower;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.xplat.EXplatAbstractions;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;

public class TwinstarBlockEntity
extends GeneratingFlowerBlockEntity
implements PassiveFlower {
    public static final int RANGE = 1;
    public static final int MAX_MANA = 1000;
    public static final int TEMPERATURE_MIN = 0;
    public static final int TEMPERATURE_MAX = Integer.MAX_VALUE;
    public static final int COOLDOWN = 8;
    private int passiveDecayTicks;

    public TwinstarBlockEntity(BlockPos pos, BlockState state) {
        super(ExtrabotanyFlowerBlocks.TWINSTAR, pos, state);
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().m_5776_()) {
            return;
        }
        this.checkToDecay((SpecialFlowerBlockEntity)this);
        if (this.getMana() >= this.getMaxMana()) {
            return;
        }
        if (this.ticksExisted % 8 != 0) {
            return;
        }
        int mana = this.getGenerateMana();
        if (mana <= 0) {
            return;
        }
        this.addMana(mana);
        this.sync();
    }

    public int getGenerateMana() {
        int thermoelectric = this.getThermoelectric();
        return (int)((float)thermoelectric / 100.0f);
    }

    public int getThermoelectric() {
        BlockPos _pos = this.getEffectivePos();
        int tempMax = 0;
        int tempMin = Integer.MAX_VALUE;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)_pos.m_7918_(-1, 0, -1), (BlockPos)_pos.m_7918_(1, 0, 1))) {
            Fluid fluid = this.m_58904_().m_6425_(pos).m_76152_();
            if (fluid.m_6212_(Fluids.f_76191_)) continue;
            int temp = EXplatAbstractions.INSTANCE.getFluidTemperature(fluid);
            tempMax = Math.max(tempMax, temp);
            tempMin = Math.min(tempMin, temp);
        }
        if (tempMax == 0 && tempMin == Integer.MAX_VALUE) {
            return 0;
        }
        return Math.min(this.getTemperatureMax(), tempMax) - Math.min(this.getTemperatureMin(), tempMin);
    }

    public int getTemperatureMax() {
        return ExtraBotanyConfig.common().twinstarMaxTemperature();
    }

    public int getTemperatureMin() {
        return ExtraBotanyConfig.common().twinstarMinTemperature();
    }

    public int getMaxMana() {
        return ExtraBotanyConfig.common().twinstarMaxMana();
    }

    public int getColor() {
        return 16575580;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((BlockPos)this.getEffectivePos(), (int)1);
    }

    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.setPassiveDecayTicks(cmp.m_128451_("passiveDecayTicks"));
    }

    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_("passiveDecayTicks", this.getPassiveDecayTicks());
    }

    @Override
    public int getPassiveDecayTicks() {
        return this.passiveDecayTicks;
    }

    @Override
    public void setPassiveDecayTicks(int ticks) {
        this.passiveDecayTicks = ticks;
    }
}

