/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.bossevents;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.github.lounode.extrabotany.common.bossevents.ColorfulBossEvent;
import io.github.lounode.extrabotany.network.clientbound.ColorfulBossEventPacket;
import io.github.lounode.extrabotany.xplat.EXplatAbstractions;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;

public class ServerColorfulBossEvent
extends ColorfulBossEvent {
    private final Set<ServerPlayer> players = Sets.newHashSet();
    private boolean visible = true;

    public ServerColorfulBossEvent(Component name, BossEvent.BossBarColor color, BossEvent.BossBarOverlay overlay) {
        super(Mth.m_14002_(), name, color, overlay);
    }

    public void m_142711_(float progress) {
        if (progress != this.f_146638_) {
            super.m_142711_(progress);
            this.broadcast(ColorfulBossEventPacket::createUpdateProgressPacket);
        }
    }

    public void m_6451_(BossEvent.BossBarColor color) {
        if (color != this.f_18842_) {
            super.m_6451_(color);
            this.broadcast(ColorfulBossEventPacket::createUpdateStylePacket);
        }
    }

    public void m_5648_(BossEvent.BossBarOverlay overlay) {
        if (overlay != this.f_18843_) {
            super.m_5648_(overlay);
            this.broadcast(ColorfulBossEventPacket::createUpdateStylePacket);
        }
    }

    public BossEvent m_7003_(boolean darkenSky) {
        if (darkenSky != this.f_18844_) {
            super.m_7003_(darkenSky);
            this.broadcast(ColorfulBossEventPacket::createUpdatePropertiesPacket);
        }
        return this;
    }

    public BossEvent m_7005_(boolean playEndBossMusic) {
        if (playEndBossMusic != this.f_18845_) {
            super.m_7005_(playEndBossMusic);
            this.broadcast(ColorfulBossEventPacket::createUpdatePropertiesPacket);
        }
        return this;
    }

    public BossEvent m_7006_(boolean createFog) {
        if (createFog != this.f_18846_) {
            super.m_7006_(createFog);
            this.broadcast(ColorfulBossEventPacket::createUpdatePropertiesPacket);
        }
        return this;
    }

    public void m_6456_(Component name) {
        if (!Objects.equal((Object)name, (Object)this.f_18840_)) {
            super.m_6456_(name);
            this.broadcast(ColorfulBossEventPacket::createUpdateNamePacket);
        }
    }

    protected void broadcast(Function<BossEvent, ColorfulBossEventPacket> packetGetter) {
        if (this.visible) {
            ColorfulBossEventPacket packet = packetGetter.apply(this);
            for (ServerPlayer serverplayer : this.players) {
                EXplatAbstractions.INSTANCE.sendToPlayer(serverplayer, packet);
            }
        }
    }

    public void addPlayer(ServerPlayer player) {
        if (this.players.add(player) && this.visible) {
            EXplatAbstractions.INSTANCE.sendToPlayer(player, ColorfulBossEventPacket.createAddPacket(this));
        }
    }

    public void removePlayer(ServerPlayer player) {
        if (this.players.remove(player) && this.visible) {
            EXplatAbstractions.INSTANCE.sendToPlayer(player, ColorfulBossEventPacket.createRemovePacket(this.m_18860_()));
        }
    }

    public void removeAllPlayers() {
        if (!this.players.isEmpty()) {
            for (ServerPlayer serverplayer : Lists.newArrayList(this.players)) {
                this.removePlayer(serverplayer);
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (visible != this.visible) {
            this.visible = visible;
            for (ServerPlayer serverplayer : this.players) {
                EXplatAbstractions.INSTANCE.sendToPlayer(serverplayer, visible ? ColorfulBossEventPacket.createAddPacket(this) : ColorfulBossEventPacket.createRemovePacket(this.m_18860_()));
            }
        }
    }

    public Set<ServerPlayer> getPlayers() {
        return this.players;
    }
}

