/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.crafting.recipe;

import io.github.lounode.extrabotany.common.brew.BrewUtil;
import io.github.lounode.extrabotany.common.item.brew.ManaCocktailItem;
import io.github.lounode.extrabotany.common.item.lens.PotionLens;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;
import vazkii.botania.common.item.lens.LensItem;

public final class PotionLensChangePotionRecipe
extends CustomRecipe {
    public static final NoOpRecipeSerializer<PotionLensChangePotionRecipe> SERIALIZER = new NoOpRecipeSerializer(PotionLensChangePotionRecipe::new);

    public PotionLensChangePotionRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.MISC);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        boolean findPotionLens = false;
        boolean findCocktail = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ManaCocktailItem cocktail;
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof LensItem && LensItem.getLens((ItemStack)stack) instanceof PotionLens) {
                if (findPotionLens) {
                    return false;
                }
                findPotionLens = true;
                continue;
            }
            Item item = stack.m_41720_();
            if (item instanceof ManaCocktailItem && (cocktail = (ManaCocktailItem)item).getSwigsLeft(stack) >= cocktail.getSwigs()) {
                if (findCocktail) {
                    return false;
                }
                findCocktail = true;
                continue;
            }
            return false;
        }
        return findPotionLens && findCocktail;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack lensItem = ItemStack.f_41583_;
        ItemStack cocktailItem = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof LensItem && LensItem.getLens((ItemStack)stack) instanceof PotionLens) {
                lensItem = stack;
                continue;
            }
            Item item = stack.m_41720_();
            if (!(item instanceof ManaCocktailItem)) continue;
            ManaCocktailItem cocktail = (ManaCocktailItem)item;
            cocktailItem = stack;
        }
        if (lensItem == ItemStack.f_41583_ || cocktailItem == ItemStack.f_41583_) {
            return ItemStack.f_41583_;
        }
        Brew brewFromCocktail = BrewUtil.getBrew(cocktailItem);
        if (brewFromCocktail == BotaniaBrews.fallbackBrew) {
            return ItemStack.f_41583_;
        }
        ItemStack result = lensItem.m_41777_();
        result.m_41764_(1);
        BrewUtil.setBrew(result, brewFromCocktail);
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width > 1 || height > 1;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

