/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.entity;

import io.github.lounode.extrabotany.common.ExtraBotanyDamageTypes;
import io.github.lounode.extrabotany.common.entity.ExtraBotanyEntityType;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.common.helper.PlayerHelper;

public class AuraFireEntity
extends ThrowableProjectile {
    private static final String TAG_GRAVITY = "gravity";
    private static final String TAG_TICKS_EXISTED = "ticksExisted";
    private static final String TAG_MAX_LIVING_TIME = "maxLivingTime";
    private static final String TAG_DAMAGE = "Damage";
    private static final EntityDataAccessor<Float> GRAVITY = SynchedEntityData.m_135353_(AuraFireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> MAX_LIVING_TIME = SynchedEntityData.m_135353_(AuraFireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(AuraFireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final float ADVANCEMENT_REQUIRE = 40.0f;
    private static final int LONG_LIVING = -1;
    private static final float BASE_DAMAGE = 4.0f;
    private static final float DAMAGE_ROUND = 1.0f;
    private static final int ABSORPTION_MAX = 10;
    private int _ticksExisted = 0;

    public AuraFireEntity(EntityType<? extends AuraFireEntity> entityType, Level level) {
        super(entityType, level);
    }

    public AuraFireEntity(Level level, double x, double y, double z, float rotX, float rotY) {
        super(ExtraBotanyEntityType.AURA_FIRE, x, y, z, level);
        this.m_19915_(rotY, rotX);
        this.m_20256_(AuraFireEntity.calculateVelocity(this.m_146909_(), this.m_146908_()));
    }

    public AuraFireEntity(LivingEntity shooter) {
        super(ExtraBotanyEntityType.AURA_FIRE, shooter, shooter.m_9236_());
        this.m_19915_(shooter.m_146908_() + 180.0f, -shooter.m_146909_());
        this.m_20256_(AuraFireEntity.calculateVelocity(this.m_146909_(), this.m_146908_()));
        this.setDamage((float)(4.0 + shooter.m_21133_(Attributes.f_22281_)));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(GRAVITY, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(MAX_LIVING_TIME, (Object)80);
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(4.0f));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_(TAG_GRAVITY, this.m_7139_());
        tag.m_128405_(TAG_TICKS_EXISTED, this.getTicksExisted());
        tag.m_128405_(TAG_MAX_LIVING_TIME, this.getMaxLivingTime());
        tag.m_128350_(TAG_DAMAGE, this.getDamage());
    }

    public void m_7378_(CompoundTag cmp) {
        super.m_7378_(cmp);
        this.setTicksExisted(cmp.m_128451_(TAG_TICKS_EXISTED));
        this.setMaxLivingTime(cmp.m_128451_(TAG_MAX_LIVING_TIME));
        this.setGravity(cmp.m_128457_(TAG_GRAVITY));
        this.setDamage(cmp.m_128457_(TAG_DAMAGE));
    }

    public void m_8119_() {
        this.setTicksExisted(this.getTicksExisted() + 1);
        super.m_8119_();
        this.particles();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.getMaxLivingTime() != -1 && this.getTicksExisted() > this.getMaxLivingTime()) {
            this.m_146870_();
        }
        Entity owner = this.m_19749_();
        AABB axis = new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19790_, this.f_19791_, this.f_19792_).m_82400_(1.0);
        List<LivingEntity> entities = this.m_9236_().m_45976_(LivingEntity.class, axis).stream().filter(e -> owner == null || e != owner).filter(e -> {
            if (owner instanceof Player) {
                Player player = (Player)owner;
                if (e instanceof Player) {
                    Player other = (Player)e;
                    return player.m_7099_(other);
                }
            }
            return true;
        }).filter(e -> e.f_20916_ == 0).toList();
        for (LivingEntity entity : entities) {
            float damage = this.getDamage();
            DamageSource source = this.createDamageSource((Entity)entity, owner);
            if (!entity.m_6469_(source, damage)) continue;
            this.handlePostDamage(owner, damage);
            this.m_146870_();
            break;
        }
    }

    private void handlePostDamage(Entity owner, float damage) {
        if (!(owner instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)owner;
        player.m_7911_(Math.min(10.0f, player.m_6103_() + 1.0f));
        if (damage >= 40.0f) {
            PlayerHelper.grantCriterion((ServerPlayer)player, (ResourceLocation)ResourceLocationHelper.prefix("main/one_punch"), (String)"code_triggered");
        }
    }

    private DamageSource createDamageSource(Entity target, Entity owner) {
        return ExtraBotanyDamageTypes.Sources.jingweiDamage(target.m_9236_().m_9598_(), owner);
    }

    protected void particles() {
        if (!this.m_6084_() || !this.m_9236_().f_46443_) {
            return;
        }
        for (int i = 1; i <= 5; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + Math.random() * (double)0.4f - (double)0.2f, this.m_20186_() + Math.random() * (double)0.4f - (double)0.2f, this.m_20189_() + Math.random() * (double)0.4f - (double)0.2f, 0.0, 0.0, 0.0);
        }
    }

    public static Vec3 calculateVelocity(float xRot, float yRot) {
        float f = 0.4f;
        double mx = (double)(Mth.m_14031_((float)(yRot / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(xRot / 180.0f * (float)Math.PI)) * f) / 2.0;
        double mz = (double)(-(Mth.m_14089_((float)(yRot / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(xRot / 180.0f * (float)Math.PI)) * f)) / 2.0;
        double my = (double)(Mth.m_14031_((float)(xRot / 180.0f * (float)Math.PI)) * f) / 2.0;
        return new Vec3(mx, my, mz);
    }

    public void setTicksExisted(int ticks) {
        this._ticksExisted = ticks;
    }

    public int getTicksExisted() {
        return this._ticksExisted;
    }

    public void setGravity(float gravity) {
        this.f_19804_.m_135381_(GRAVITY, (Object)Float.valueOf(gravity));
    }

    protected float m_7139_() {
        return ((Float)this.f_19804_.m_135370_(GRAVITY)).floatValue();
    }

    public void setMaxLivingTime(int time) {
        this.f_19804_.m_135381_(MAX_LIVING_TIME, (Object)time);
    }

    public int getMaxLivingTime() {
        return (Integer)this.f_19804_.m_135370_(MAX_LIVING_TIME);
    }

    public void setLongLiving() {
        this.f_19804_.m_135381_(MAX_LIVING_TIME, (Object)-1);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public boolean m_20077_() {
        return false;
    }

    public boolean m_204031_(TagKey<Fluid> fluid, double mag) {
        return false;
    }
}

