/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.entity;

import com.mojang.serialization.Codec;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;

public class ExtraBotanyMemoryType {
    public static final Map<ResourceLocation, MemoryModuleType<?>> ALL = new LinkedHashMap();
    public static final MemoryModuleType<Integer> TELEPORT_DELAY_BASE = ExtraBotanyMemoryType.register(ResourceLocationHelper.prefix("teleport_delay_base"), Codec.INT);
    public static final MemoryModuleType<Integer> TELEPORT_DELAY = ExtraBotanyMemoryType.register(ResourceLocationHelper.prefix("teleport_delay"), Codec.INT);
    public static final MemoryModuleType<Float> TELEPORT_RANGE = ExtraBotanyMemoryType.register(ResourceLocationHelper.prefix("teleport_range"), Codec.FLOAT);
    public static final MemoryModuleType<Integer> LANDMINE_COUNT = ExtraBotanyMemoryType.register(ResourceLocationHelper.prefix("landmine_count"), Codec.INT);
    public static final MemoryModuleType<Integer> PIXIES_MAX = ExtraBotanyMemoryType.register(ResourceLocationHelper.prefix("pixies_max"), Codec.INT);
    public static final MemoryModuleType<Integer> MOB_SPAWN_TICKS = ExtraBotanyMemoryType.register(ResourceLocationHelper.prefix("mob_spawn_ticks"), Codec.INT);

    private static <T> MemoryModuleType<T> register(ResourceLocation id, Codec<T> codec) {
        MemoryModuleType type = new MemoryModuleType(Optional.of(codec));
        ALL.put(id, type);
        return type;
    }

    public static void registerMemories(BiConsumer<MemoryModuleType<?>, ResourceLocation> consumer) {
        for (Map.Entry<ResourceLocation, MemoryModuleType<?>> memory : ALL.entrySet()) {
            consumer.accept(memory.getValue(), memory.getKey());
        }
    }
}

