/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.entity;

import io.github.lounode.extrabotany.common.brew.BrewUtil;
import io.github.lounode.extrabotany.common.entity.ExtraBotanyEntityType;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.brew.Brew;

public class HolyWaterGrenadeEntity
extends ThrownPotion {
    public static final double SPLASH_RANGE = 4.0;
    private static final double SPLASH_RANGE_SQ = 16.0;

    public HolyWaterGrenadeEntity(EntityType<? extends HolyWaterGrenadeEntity> entityType, Level level) {
        super(entityType, level);
    }

    public HolyWaterGrenadeEntity(Level level, LivingEntity shooter) {
        this(level, shooter.m_20185_(), shooter.m_20188_() - (double)0.1f, shooter.m_20189_());
        this.m_5602_((Entity)shooter);
    }

    public HolyWaterGrenadeEntity(Level level, double x, double y, double z) {
        this(ExtraBotanyEntityType.HOLY_WATER_GRENADE, level);
        this.m_6034_(x, y, z);
    }

    protected Item m_7881_() {
        return ExtraBotanyItems.holyWaterGrenade;
    }

    protected void m_8060_(BlockHitResult result) {
        BlockState blockstate = this.m_9236_().m_8055_(result.m_82425_());
        blockstate.m_60669_(this.m_9236_(), blockstate, result, (Projectile)this);
    }

    protected void m_6532_(HitResult result) {
        HitResult.Type hitresult$type = result.m_6662_();
        if (hitresult$type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)result);
            this.m_9236_().m_214171_(GameEvent.f_157777_, result.m_82450_(), GameEvent.Context.m_223719_((Entity)this, (BlockState)null));
        } else if (hitresult$type == HitResult.Type.BLOCK) {
            BlockHitResult blockhitresult = (BlockHitResult)result;
            this.m_8060_(blockhitresult);
            BlockPos blockpos = blockhitresult.m_82425_();
            this.m_9236_().m_220407_(GameEvent.f_157777_, blockpos, GameEvent.Context.m_223719_((Entity)this, (BlockState)this.m_9236_().m_8055_(blockpos)));
        }
        if (!this.m_9236_().f_46443_) {
            Brew brew = this.getBrew();
            List<MobEffectInstance> list = BrewUtil.getPotionEffects(brew);
            this.m_37547_(list, result.m_6662_() == HitResult.Type.ENTITY ? ((EntityHitResult)result).m_82443_() : null);
            int i = BrewUtil.hasInstantEffects(brew) ? 2007 : 2002;
            this.m_9236_().m_46796_(i, this.m_20183_(), BrewUtil.getColor(brew));
            this.m_146870_();
        }
    }

    public void m_37547_(List<MobEffectInstance> effectInstances, @Nullable Entity target) {
        AABB effectAura = this.m_20191_().m_82377_(4.0, 2.0, 4.0);
        List nearby = this.m_9236_().m_45976_(LivingEntity.class, effectAura);
        if (nearby.isEmpty()) {
            return;
        }
        Entity source = this.m_150173_();
        for (LivingEntity victim : nearby) {
            double distanceToSqr;
            if (!victim.m_5801_() || (distanceToSqr = this.m_20280_((Entity)victim)) > 16.0) continue;
            double d1 = victim == target ? 1.0 : 1.0 - Math.sqrt(distanceToSqr) / 4.0;
            boolean isSource = victim == source;
            for (MobEffectInstance tmpInstance : effectInstances) {
                MobEffect mobeffect = tmpInstance.m_19544_();
                boolean isBeneficial = mobeffect.m_19486_();
                if (isBeneficial && !isSource || !isBeneficial && isSource) continue;
                if (mobeffect.m_8093_()) {
                    mobeffect.m_19461_((Entity)this, this.m_19749_(), victim, tmpInstance.m_19564_(), d1);
                    continue;
                }
                int durationAdjustByDistance = tmpInstance.m_267696_(originalDuration -> (int)(d1 * (double)originalDuration + 0.5));
                MobEffectInstance apply = new MobEffectInstance(mobeffect, durationAdjustByDistance, tmpInstance.m_19564_(), tmpInstance.m_19571_(), tmpInstance.m_19572_());
                if (apply.m_267633_(20)) continue;
                victim.m_147207_(apply, source);
            }
        }
    }

    public Brew getBrew() {
        return BrewUtil.getBrew(this.m_7846_());
    }
}

