/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.entity;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.handler.BotaniaSounds;

public class MagicLandMineEntity
extends Entity {
    public static final int EXPLODE_COUNTDOWN = 55;
    public static final float EXPLODE_DAMAGE = 10.0f;
    private static final String TAG_OWNER = "Owner";
    private static final String TAG_DAMAGE = "Damage";
    private static final String TAG_EXPLODE_COUNTDOWN = "ExplodeCountDown";
    private static final EntityDataAccessor<Integer> COUNTDOWN = SynchedEntityData.m_135353_(MagicLandMineEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;
    private float damage;

    public MagicLandMineEntity(EntityType<? extends MagicLandMineEntity> type, Level level) {
        super(type, level);
        this.setDamage(10.0f);
        this.setExplodeCountDown(55);
    }

    public void m_8119_() {
        this.m_20256_(Vec3.f_82478_);
        super.m_8119_();
        this.particle();
        int countDown = this.getExplodeCountDown();
        if (countDown > 0) {
            this.setExplodeCountDown(countDown - 1);
            return;
        }
        this.explode();
    }

    public void explode() {
        this.explodeParticle();
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), BotaniaSounds.gaiaTrap, SoundSource.NEUTRAL, 1.0f, 1.0f);
            List<Player> players = this.getVictimPlayers();
            for (Player player : players) {
                if (player.m_5833_() || player.m_7500_()) continue;
                player.m_6469_(this.m_269291_().m_269104_((Entity)this, this.getOwner()), this.getDamage());
                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 25, 0));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 120, 2));
            }
            this.m_146870_();
        }
    }

    protected void explodeParticle() {
        float m = 0.35f;
        float r = 0.2f;
        float g = 0.4f;
        float b = 0.2f;
        for (int i = 0; i < 25; ++i) {
            WispParticleData data = WispParticleData.wisp((float)0.5f, (float)r, (float)g, (float)b);
            this.m_9236_().m_7106_((ParticleOptions)data, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), (double)((float)(Math.random() - 0.5) * m), (double)((float)(Math.random() - 0.5) * m), (double)((float)(Math.random() - 0.5) * m));
        }
    }

    protected void particle() {
        float range = this.m_20205_() / 2.0f;
        float r = 0.2f;
        float g = 0.0f;
        float b = 0.2f;
        for (int i = 0; i < 6; ++i) {
            WispParticleData data = WispParticleData.wisp((float)0.4f, (float)r, (float)g, (float)b, (float)1.0f);
            this.m_9236_().m_7106_((ParticleOptions)data, this.m_20185_() - (double)range + Math.random() * (double)range * 2.0, this.m_20186_(), this.m_20189_() - (double)range + Math.random() * (double)range * 2.0, 0.0, (double)0.015f, 0.0);
        }
    }

    public List<? extends LivingEntity> getVictims(Class<? extends LivingEntity> entityClass) {
        return this.m_9236_().m_45976_(entityClass, this.m_20191_());
    }

    public List<Player> getVictimPlayers() {
        return this.getVictims(Player.class);
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage >= 0.0f ? damage : 0.0f;
    }

    public void setOwner(@Nullable Entity owner) {
        if (owner != null) {
            this.ownerUUID = owner.m_20148_();
            this.cachedOwner = owner;
        }
    }

    @Nullable
    public Entity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedOwner = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public int getExplodeCountDown() {
        return (Integer)this.f_19804_.m_135370_(COUNTDOWN);
    }

    public void setExplodeCountDown(int explodeCountDown) {
        this.f_19804_.m_135381_(COUNTDOWN, (Object)explodeCountDown);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(COUNTDOWN, (Object)55);
    }

    protected void m_7378_(@NotNull CompoundTag cmp) {
        if (cmp.m_128403_(TAG_OWNER)) {
            this.ownerUUID = cmp.m_128342_(TAG_OWNER);
            this.cachedOwner = null;
        }
        this.setDamage(cmp.m_128457_(TAG_DAMAGE));
        this.setExplodeCountDown(cmp.m_128451_(TAG_EXPLODE_COUNTDOWN));
    }

    protected void m_7380_(@NotNull CompoundTag cmp) {
        if (this.ownerUUID != null) {
            cmp.m_128362_(TAG_OWNER, this.ownerUUID);
        }
        cmp.m_128350_(TAG_DAMAGE, this.getDamage());
        cmp.m_128405_(TAG_EXPLODE_COUNTDOWN, this.getExplodeCountDown());
    }
}

