/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.entity;

import io.github.lounode.extrabotany.common.entity.ExtraBotanyEntityType;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.helper.VecHelper;

public class SkullMissileEntity
extends ThrowableProjectile {
    public static final int MAX_LIVING_TIME = 100;
    private static final String TAG_FIRE = "Fire";
    private static final String TAG_TICKS_EXISTED = "ticksExisted";
    private static final String TAG_TARGET = "Target";
    private boolean fire;
    private int _ticksExisted = 0;
    private double lockX;
    private double lockY = -2.147483648E9;
    private double lockZ;
    @Nullable
    private UUID targetUUID;
    @Nullable
    private Entity cachedTarget;

    public SkullMissileEntity(EntityType<? extends SkullMissileEntity> entityType, Level level) {
        super(entityType, level);
    }

    public SkullMissileEntity(Level level, double x, double y, double z) {
        super(ExtraBotanyEntityType.SKULL_MISSILE, x, y, z, level);
    }

    public SkullMissileEntity(Level level, LivingEntity shooter) {
        super(ExtraBotanyEntityType.SKULL_MISSILE, shooter, level);
    }

    public void m_8119_() {
        super.m_8119_();
        this.particle();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.getTarget().isEmpty() || this.getTicksExisted() > 100) {
            this.m_146870_();
            return;
        }
        this.getTarget().ifPresent(target -> {
            if (this.lockY == -2.147483648E9) {
                this.lockX = target.m_20185_();
                this.lockY = target.m_20186_();
                this.lockZ = target.m_20189_();
            }
            Vec3 thisVec = VecHelper.fromEntityCenter((Entity)this);
            Vec3 targetVec = new Vec3(this.lockX, this.lockY, this.lockZ);
            Vec3 diffVec = targetVec.m_82546_(thisVec);
            Vec3 motionVec = diffVec.m_82541_().m_82490_(0.6);
            this.m_20256_(motionVec);
            if (this.getTicksExisted() < 10) {
                this.m_20334_(this.m_20184_().m_7096_(), Math.abs(this.m_20184_().m_7098_()), this.m_20184_().m_7094_());
            }
        });
        this.setTicksExisted(this.getTicksExisted() + 1);
    }

    public boolean findTarget() {
        Optional<Entity> target = this.getTarget();
        if (target.isPresent()) {
            Entity entity = target.get();
            if (entity.m_6084_()) {
                return true;
            }
            this.setTarget(null);
        }
        double range = 15.0;
        AABB bounds = new AABB(this.m_20097_()).m_82400_(range);
        DamageSource source = this.getDamageSource();
        Predicate<Entity> vulnerableTo = e -> !e.m_6673_(source);
        List entities = this.m_9236_().m_6443_(Player.class, bounds, EntitySelector.f_20403_.and(vulnerableTo));
        Entity found = null;
        if (!entities.isEmpty()) {
            found = (Entity)entities.get(this.m_9236_().f_46441_.m_188503_(entities.size()));
            this.setTarget(found);
        }
        return found != null;
    }

    protected void m_8060_(BlockHitResult hit) {
        super.m_8060_(hit);
        if (this.m_9236_().m_5776_()) {
            return;
        }
        BlockState state = this.m_9236_().m_8055_(hit.m_82425_());
        if (state.m_60734_() instanceof BushBlock) {
            return;
        }
        if (state.m_204336_(BlockTags.f_13035_)) {
            return;
        }
        this.m_146870_();
    }

    protected void m_5790_(EntityHitResult hit) {
        super.m_5790_(hit);
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.getTarget().ifPresent(target -> {
            if (hit.m_82443_() == target) {
                target.m_6469_(this.getDamageSource(), 12.0f);
                this.m_146870_();
            }
        });
    }

    protected DamageSource getDamageSource() {
        Entity owner = this.m_19749_();
        if (owner instanceof LivingEntity) {
            DamageSource damageSource;
            LivingEntity livingOwner = (LivingEntity)owner;
            if (owner instanceof Player) {
                Player playerOwner = (Player)owner;
                damageSource = this.m_269291_().m_269075_(playerOwner);
            } else {
                damageSource = this.m_269291_().m_269333_(livingOwner);
            }
            return damageSource;
        }
        return this.m_269291_().m_269264_();
    }

    public void setTarget(@Nullable Entity target) {
        this.cachedTarget = target;
        this.targetUUID = target == null ? null : target.m_20148_();
    }

    public Optional<Entity> getTarget() {
        Level level;
        if (this.cachedTarget != null && !this.cachedTarget.m_213877_()) {
            return Optional.of(this.cachedTarget);
        }
        if (this.targetUUID != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.cachedTarget = serverLevel.m_8791_(this.targetUUID);
            return this.cachedTarget != null ? Optional.of(this.cachedTarget) : Optional.empty();
        }
        return Optional.empty();
    }

    protected void particle() {
        if (!this.m_9236_().m_5776_()) {
            return;
        }
        double lastTickPosX = this.f_19790_;
        double lastTickPosY = this.f_19791_;
        double lastTickPosZ = this.f_19792_;
        Vec3 thisVec = VecHelper.fromEntityCenter((Entity)this);
        Vec3 oldPos = new Vec3(lastTickPosX, lastTickPosY, lastTickPosZ);
        Vec3 diff = thisVec.m_82546_(oldPos);
        Vec3 step = diff.m_82541_().m_82490_(0.05);
        int steps = (int)(diff.m_82553_() / step.m_82553_());
        Vec3 particlePos = oldPos;
        SparkleParticleData data = SparkleParticleData.corrupt((float)0.8f, (float)1.0f, (float)0.0f, (float)1.0f, (int)2);
        for (int i = 0; i < steps; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)data, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
            if (this.m_9236_().f_46441_.m_188503_(steps) <= 1) {
                this.m_9236_().m_7106_((ParticleOptions)data, particlePos.f_82479_ + (Math.random() - 0.5) * 0.4, particlePos.f_82480_ + (Math.random() - 0.5) * 0.4, particlePos.f_82481_ + (Math.random() - 0.5) * 0.4, 0.0, 0.0, 0.0);
            }
            particlePos = particlePos.m_82549_(step);
        }
    }

    protected void m_8097_() {
    }

    protected void m_7380_(CompoundTag cmp) {
        super.m_7380_(cmp);
        cmp.m_128379_(TAG_FIRE, this.isFire());
        cmp.m_128405_(TAG_TICKS_EXISTED, this.getTicksExisted());
        this.getTarget().ifPresent(target -> cmp.m_128362_(TAG_TARGET, target.m_20148_()));
    }

    protected void m_7378_(CompoundTag cmp) {
        super.m_7378_(cmp);
        this.setFire(cmp.m_128471_(TAG_FIRE));
        this.setTicksExisted(cmp.m_128451_(TAG_TICKS_EXISTED));
        if (cmp.m_128403_(TAG_TARGET)) {
            this.targetUUID = cmp.m_128342_(TAG_TARGET);
            this.cachedTarget = null;
        }
    }

    public void setFire(boolean fire) {
        this.fire = fire;
    }

    public boolean isFire() {
        return this.fire;
    }

    public void setTicksExisted(int ticks) {
        this._ticksExisted = ticks;
    }

    public int getTicksExisted() {
        return this._ticksExisted;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }
}

