/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.entity.gaia;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.github.lounode.extrabotany.api.gaia.GaiaArena;
import io.github.lounode.extrabotany.common.bossevents.ServerGaiaBossEvent;
import io.github.lounode.extrabotany.common.entity.ExtraBotanyEntityType;
import io.github.lounode.extrabotany.common.entity.gaia.GaiaAI;
import io.github.lounode.extrabotany.common.proxy.Proxy;
import io.github.lounode.extrabotany.common.telemetry.ExtraBotanyTelemetry;
import io.github.lounode.extrabotany.network.clientbound.SpawnGaiaPacket;
import io.github.lounode.extrabotany.xplat.EXplatAbstractions;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Unit;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;

public class Gaia
extends Monster {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final float MAX_HP = 320.0f;
    public static final float DAMAGE_CAP = 32.0f;
    private static final String TAG_INVUL_TIME = "InvulTime";
    private static final String TAG_HOME = "Home";
    private static final String TAG_PLAYER_COUNT = "PlayerCount";
    private static final String TAG_ARENA = "Arena";
    private static final String TAG_PLAYER_ATTACKED = "PlayersAttacked";
    private static final EntityDataAccessor<Integer> INVUL_TIME = SynchedEntityData.m_135353_(Gaia.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected int playerCount = 0;
    protected ServerGaiaBossEvent bossEvent;
    private final Set<UUID> playersWhoAttacked = new HashSet<UUID>();
    @NotNull
    private GlobalPos home;
    @Nullable
    private GaiaArena arena;

    public Gaia(EntityType<? extends Gaia> type, Level world) {
        super(type, world);
        this.f_21364_ = 825;
        this.m_21153_(this.m_21233_());
        this.setHome(GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)ManaBurst.NO_SOURCE));
        this.bossEvent = (ServerGaiaBossEvent)new ServerGaiaBossEvent(type.m_20676_(), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.PROGRESS).m_7006_(true);
        if (world.f_46443_) {
            Proxy.INSTANCE.addBoss((LivingEntity)this);
        }
    }

    public Gaia(EntityType<? extends Gaia> type, Level world, BlockPos source) {
        this(type, world);
        this.setHome(GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)source));
    }

    public Gaia(Level world, BlockPos source) {
        this(ExtraBotanyEntityType.GAIA_LEGACY, world, source);
    }

    public static AttributeSupplier.Builder createGaiaAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22276_, 320.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return GaiaAI.makeBrain(this, dynamic);
    }

    public Brain<Gaia> m_6274_() {
        return super.m_6274_();
    }

    public static boolean spawn(Player player, ItemStack stack, Level world, BlockPos pos) {
        GaiaArena arena = GaiaArena.of(GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)pos));
        if (!arena.checksVanilla(player, world, pos)) {
            return false;
        }
        if (!world.m_5776_()) {
            int playerCount;
            stack.m_41774_(1);
            Gaia gaia = new Gaia(world, pos);
            gaia.setArena(arena);
            gaia.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 3, (double)pos.m_123343_() + 0.5);
            gaia.m_6274_().m_21882_(MemoryModuleType.f_217786_, (Object)Unit.INSTANCE, 160L);
            gaia.setInvulTime(160);
            gaia.bossEvent.m_142711_(0.0f);
            gaia.m_21153_(1.0f);
            List<Player> playersAround = arena.getPlayersAround(world);
            gaia.playerCount = playerCount = playersAround.size();
            gaia.bossEvent.setPlayerCount(playerCount);
            float healthMultiplier = 1.0f;
            if (playerCount > 1) {
                healthMultiplier += (float)playerCount * 0.25f;
            }
            gaia.m_21051_(Attributes.f_22276_).m_22100_((double)(320.0f * healthMultiplier));
            gaia.m_21051_(Attributes.f_22284_).m_22100_(15.0);
            gaia.m_5496_(BotaniaSounds.gaiaSummon, 0.1f, 1.0f);
            gaia.m_6518_((ServerLevelAccessor)world, world.m_6436_(gaia.m_20183_()), MobSpawnType.EVENT, null, null);
            world.m_7967_((Entity)gaia);
            for (Player nearbyPlayer : playersAround) {
                if (!(nearbyPlayer instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)nearbyPlayer;
                CriteriaTriggers.f_10580_.m_68256_(serverPlayer, (Entity)gaia);
            }
        }
        return true;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        if (this.getHome().m_122646_() == ManaBurst.NO_SOURCE) {
            this.setHome(GlobalPos.m_122643_((ResourceKey)level.m_6018_().m_46472_(), (BlockPos)this.findSafeHomePos()));
        }
        this.initMemories(level, difficulty, reason, spawnData, dataTag);
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    private BlockPos findSafeHomePos() {
        BlockPos spawnPos = this.m_20097_();
        Level level = this.m_9236_();
        for (int i = 0; i <= 10; ++i) {
            BlockPos checkPos = spawnPos.m_6625_(i);
            if (!level.m_8055_(checkPos).m_280296_()) continue;
            return checkPos.m_7494_();
        }
        return spawnPos;
    }

    protected void initMemories(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        GaiaAI.initMemories(this, level.m_6018_(), this.getHome().m_122646_());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, this.getArenaRange() * 1.5f));
    }

    protected void m_8024_() {
        ServerLevel serverlevel = (ServerLevel)this.m_9236_();
        serverlevel.m_46473_().m_6180_("gaiaBrain");
        this.m_6274_().m_21865_(serverlevel, (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
        this.updateAI();
        int invul = this.getInvulTime();
        if (invul > 0) {
            this.setInvulTime(invul - 1);
        }
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.m_20159_()) {
            this.m_8127_();
        }
        List<Player> players = this.getPlayersAround();
        for (Player player : players) {
            if (player.m_5803_()) {
                player.m_5796_();
            }
            if (player.m_20159_()) {
                player.m_8127_();
            }
            this.getArena().ifPresent(arena -> player.m_150110_().f_35935_ &= player.m_150110_().f_35937_);
        }
    }

    protected void updateAI() {
        GaiaAI.updateActivity(this);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.arena != null && this.m_6084_() && !this.m_21525_()) {
            this.arena.tick(this);
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        Entity e = source.m_7639_();
        if (e instanceof Player) {
            Player player = (Player)e;
            if (PlayerHelper.isTruePlayer((Entity)e) && this.getInvulTime() == 0) {
                this.markPlayerAttacked(player);
                return super.m_6469_(source, Math.min(this.getDamageCap(), amount));
            }
        }
        return false;
    }

    protected void m_6475_(@NotNull DamageSource source, float amount) {
        super.m_6475_(source, Math.min(this.getDamageCap(), amount));
        Entity attacker = source.m_7640_();
        if (attacker != null) {
            Vec3 thisVector = VecHelper.fromEntityCenter((Entity)this);
            Vec3 playerVector = VecHelper.fromEntityCenter((Entity)attacker);
            Vec3 motionVector = thisVector.m_82546_(playerVector).m_82541_().m_82490_(0.75);
            if (this.m_21223_() > 0.0f) {
                this.m_20334_(-motionVector.f_82479_, 0.5, -motionVector.f_82481_);
            }
        }
        this.f_19802_ = Math.max(this.f_19802_, 20);
    }

    public void m_6667_(@NotNull DamageSource source) {
        super.m_6667_(source);
        LivingEntity lastAttacker = this.m_21232_();
        this.getArena().ifPresent(arena -> {
            arena.cleanup(this.m_9236_());
            ExtraBotanyTelemetry.Event.onGaiaBattleFinish(this);
        });
        if (!this.m_9236_().f_46443_) {
            for (UUID u : this.getPlayersWhoAttacked()) {
                DamageSource currSource;
                Player player = this.m_9236_().m_46003_(u);
                if (!PlayerHelper.isTruePlayer((Entity)player)) continue;
                DamageSource damageSource = currSource = player == lastAttacker ? source : player.m_269291_().m_269075_(player);
                if (player == lastAttacker) continue;
                CriteriaTriggers.f_10568_.m_48104_((ServerPlayer)player, (Entity)this, currSource);
            }
        }
        this.m_5496_(BotaniaSounds.gaiaDeath, 1.0f, (1.0f + (this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.2f) * 0.7f);
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0, 0.0, 0.0);
    }

    protected void m_7625_(@NotNull DamageSource source, boolean wasRecentlyHit) {
        for (UUID u : this.playersWhoAttacked) {
            Player player = this.m_9236_().m_46003_(u);
            if (!PlayerHelper.isTruePlayer((Entity)player)) continue;
            Player saveLastAttacker = this.f_20888_;
            Vec3 savePos = this.m_20182_();
            this.f_20888_ = player;
            this.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            super.m_7625_(player.m_269291_().m_269075_(player), wasRecentlyHit);
            this.m_6034_(savePos.m_7096_(), savePos.m_7098_(), savePos.m_7094_());
            this.f_20888_ = saveLastAttacker;
        }
    }

    protected float m_21161_(DamageSource source, float damage) {
        return super.m_21161_(source, Math.min(32.0f, damage));
    }

    public void m_5634_(float amount) {
        if (this.getInvulTime() == 0) {
            super.m_5634_(amount);
        }
    }

    public void m_6074_() {
        this.m_21153_(0.0f);
        this.bossEvent.m_142711_(0.0f);
        this.getArena().ifPresent(arena -> arena.cleanup(this.m_9236_()));
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (this.m_9236_().f_46443_) {
            Proxy.INSTANCE.removeBoss((LivingEntity)this);
        }
        super.m_142687_(reason);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossEvent.addPlayer(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.removePlayer(player);
    }

    protected void m_6138_() {
        if (this.getInvulTime() == 0) {
            super.m_6138_();
        }
    }

    public boolean m_6785_(double dist) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_6094_() {
        return super.m_6094_() && this.getInvulTime() == 0;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    protected boolean m_7341_(Entity vehicle) {
        return false;
    }

    public boolean m_213824_() {
        return true;
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public List<Player> getPlayersAround() {
        return PlayerHelper.getRealPlayersIn((Level)this.m_9236_(), (AABB)this.getArenaBB());
    }

    @NotNull
    private AABB getArenaBB() {
        double range = this.getArena().map(GaiaArena::radius).orElse(Float.valueOf(this.getArenaRange())).floatValue() + 3.0f;
        BlockPos source = this.getHome().m_122646_();
        return new AABB((double)source.m_123341_() + 0.5, (double)source.m_123342_() + 0.5, (double)source.m_123343_() + 0.5, (double)source.m_123341_() + 0.5, (double)source.m_123342_() + 0.5, (double)source.m_123343_() + 0.5).m_82400_(range);
    }

    public int getPlayerCount() {
        return this.playerCount;
    }

    public Optional<GaiaArena> getArena() {
        return Optional.ofNullable(this.arena);
    }

    protected void setArena(@Nullable GaiaArena arena) {
        this.arena = arena;
    }

    public void setInvulTime(int time) {
        this.f_19804_.m_135381_(INVUL_TIME, (Object)time);
        this.bossEvent.setGrainTime(time);
    }

    public int getInvulTime() {
        return (Integer)this.f_19804_.m_135370_(INVUL_TIME);
    }

    @NotNull
    public GlobalPos getHome() {
        return this.home;
    }

    protected void setHome(@NotNull GlobalPos pos) {
        this.home = pos;
    }

    public Set<UUID> getPlayersWhoAttacked() {
        return this.playersWhoAttacked;
    }

    public void markPlayerAttacked(Player player) {
        if (PlayerHelper.isTruePlayer((Entity)player)) {
            this.playersWhoAttacked.add(player.m_20148_());
        }
    }

    public float getArenaRange() {
        return this.getArena().map(GaiaArena::radius).orElse(Float.valueOf(12.0f)).floatValue();
    }

    public float getDamageCap() {
        return 32.0f;
    }

    public int getEmergeTime() {
        return 160;
    }

    public void syncDataFormServer(GaiaSpawnData data) {
        this.playerCount = data.getPlayerCount();
        this.setHome(data.getHome());
        if (!ManaBurst.NO_SOURCE.equals((Object)data.getArena().center().m_122646_())) {
            this.setArena(data.getArena());
            Proxy.INSTANCE.runOnClient(() -> () -> DopplegangerMusic.play(this));
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        GaiaSpawnData spawnData = new GaiaSpawnData();
        spawnData.setHome(this.getHome());
        spawnData.setPlayerCount(this.getPlayerCount());
        spawnData.setArena(this.getArena().orElse(GaiaArena.of(GlobalPos.m_122643_((ResourceKey)this.m_9236_().m_46472_(), (BlockPos)ManaBurst.NO_SOURCE))));
        return EXplatAbstractions.INSTANCE.toVanillaClientboundPacket(new SpawnGaiaPacket(new ClientboundAddEntityPacket((Entity)this), spawnData));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(INVUL_TIME, (Object)0);
    }

    public void m_7380_(CompoundTag cmp) {
        super.m_7380_(cmp);
        cmp.m_128405_(TAG_INVUL_TIME, this.getInvulTime());
        GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.getHome()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> cmp.m_128365_(TAG_HOME, tag));
        this.getArena().flatMap(arena -> GaiaArena.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, arena).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(tag -> cmp.m_128365_(TAG_ARENA, tag));
        cmp.m_128405_(TAG_PLAYER_COUNT, this.playerCount);
        if (!this.getPlayersWhoAttacked().isEmpty()) {
            ListTag players = new ListTag();
            for (UUID uuid : this.getPlayersWhoAttacked()) {
                players.add((Object)NbtUtils.m_129226_((UUID)uuid));
            }
            cmp.m_128365_(TAG_PLAYER_ATTACKED, (Tag)players);
        }
    }

    public void m_7378_(CompoundTag cmp) {
        super.m_7378_(cmp);
        this.setInvulTime(cmp.m_128451_(TAG_INVUL_TIME));
        if (cmp.m_128441_(TAG_HOME)) {
            this.setHome(GlobalPos.f_122633_.parse((DynamicOps)NbtOps.f_128958_, (Object)cmp.m_128423_(TAG_HOME)).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(GlobalPos.m_122643_((ResourceKey)this.m_9236_().m_46472_(), (BlockPos)ManaBurst.NO_SOURCE)));
        } else {
            this.setHome(GlobalPos.m_122643_((ResourceKey)this.m_9236_().m_46472_(), (BlockPos)ManaBurst.NO_SOURCE));
        }
        if (cmp.m_128441_(TAG_ARENA)) {
            this.setArena(GaiaArena.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)cmp.m_128423_(TAG_ARENA)).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null));
        }
        this.playerCount = cmp.m_128441_(TAG_PLAYER_COUNT) ? cmp.m_128451_(TAG_PLAYER_COUNT) : 1;
        if (cmp.m_128425_(TAG_PLAYER_ATTACKED, 9)) {
            ListTag uuids = cmp.m_128437_(TAG_PLAYER_ATTACKED, 9);
            this.getPlayersWhoAttacked().clear();
            for (Tag uuid : uuids) {
                this.playersWhoAttacked.add(NbtUtils.m_129233_((Tag)uuid));
            }
        }
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    public SoundEvent getBGM() {
        return BotaniaSounds.gaiaMusic2;
    }

    public static class GaiaSpawnData {
        private int playerCount;
        private GlobalPos home;
        private UUID bossInfoUUID;
        private GaiaArena arena;

        public GaiaArena getArena() {
            return this.arena;
        }

        public void setArena(GaiaArena arena) {
            this.arena = arena;
        }

        public int getPlayerCount() {
            return this.playerCount;
        }

        public void setPlayerCount(int playerCount) {
            this.playerCount = playerCount;
        }

        public GlobalPos getHome() {
            return this.home;
        }

        public void setHome(GlobalPos home) {
            this.home = home;
        }

        public UUID getBossInfoUUID() {
            return this.bossInfoUUID;
        }

        public void setBossInfoUUID(UUID bossInfoUUID) {
            this.bossInfoUUID = bossInfoUUID;
        }
    }

    private static class DopplegangerMusic
    extends AbstractTickableSoundInstance {
        private final Gaia guardian;

        private DopplegangerMusic(Gaia guardian) {
            super(guardian.getBGM(), SoundSource.RECORDS, SoundInstance.m_235150_());
            this.guardian = guardian;
            this.f_119575_ = guardian.getHome().m_122646_().m_123341_();
            this.f_119576_ = guardian.getHome().m_122646_().m_123342_();
            this.f_119577_ = guardian.getHome().m_122646_().m_123343_();
            this.f_119578_ = true;
        }

        public static void play(Gaia guardian) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new DopplegangerMusic(guardian));
        }

        public void m_7788_() {
            if (!this.guardian.m_6084_()) {
                this.m_119609_();
            }
        }
    }
}

