/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.entity.gaia;

import com.mojang.serialization.Dynamic;
import io.github.lounode.extrabotany.api.gaia.GaiaArena;
import io.github.lounode.extrabotany.common.entity.ExtraBotanyEntityType;
import io.github.lounode.extrabotany.common.entity.gaia.Gaia;
import io.github.lounode.extrabotany.common.entity.gaia.GaiaIIIAI;
import io.github.lounode.extrabotany.common.sounds.ExtraBotanySounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.handler.BotaniaSounds;

public class GaiaIII
extends Gaia {
    public static final float ARENA_RANGE = 15.0f;
    public static final int ARENA_HEIGHT = 7;
    public static final float MAX_HP = 600.0f;
    private static final float DAMAGE_CAP = 30.0f;

    public GaiaIII(EntityType<? extends GaiaIII> type, Level world) {
        super(type, world);
        this.f_21364_ = 1000;
    }

    public GaiaIII(EntityType<? extends GaiaIII> type, Level world, BlockPos source) {
        super(type, world, source);
    }

    public GaiaIII(Level world, BlockPos source) {
        this((EntityType<? extends GaiaIII>)ExtraBotanyEntityType.GAIA_III, world, source);
    }

    public static boolean spawn(Player player, ItemStack stack, Level world, BlockPos pos) {
        GaiaArena arena = GaiaArena.of(GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)pos), 15.0f, 7);
        if (!arena.checksModern(player, world, stack)) {
            return false;
        }
        if (!arena.checkInventory(world)) {
            if (!world.m_5776_()) {
                player.m_213846_((Component)Component.m_237115_((String)"message.extrabotany.chat.unsafe_inventory").m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        if (!world.m_5776_()) {
            int playerCount;
            GaiaIII gaia = new GaiaIII(world, pos);
            gaia.setArena(arena);
            gaia.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 3, (double)pos.m_123343_() + 0.5);
            gaia.m_6274_().m_21882_(MemoryModuleType.f_217786_, (Object)Unit.INSTANCE, 200L);
            gaia.setInvulTime(200);
            gaia.m_21153_(1.0f);
            gaia.bossEvent.m_142711_(0.0f);
            List<Player> playersAround = arena.getPlayersAround(world);
            gaia.playerCount = playerCount = playersAround.size();
            gaia.bossEvent.setPlayerCount(playerCount);
            float healthMultiplier = 1.0f;
            if (playerCount > 1) {
                healthMultiplier += (float)playerCount * 0.25f;
            }
            gaia.m_21051_(Attributes.f_22276_).m_22100_((double)(600.0f * healthMultiplier));
            gaia.m_21051_(Attributes.f_22284_).m_22100_(30.0);
            gaia.m_5496_(BotaniaSounds.gaiaSummon, 0.05f, 1.0f);
            gaia.m_6518_((ServerLevelAccessor)world, world.m_6436_(gaia.m_20183_()), MobSpawnType.EVENT, null, null);
            world.m_7967_((Entity)gaia);
            for (Player nearbyPlayer : playersAround) {
                if (!(nearbyPlayer instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)nearbyPlayer;
                CriteriaTriggers.f_10580_.m_68256_(serverPlayer, (Entity)gaia);
            }
        }
        return true;
    }

    public static AttributeSupplier.Builder createGaiaAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22276_, 600.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Override
    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return GaiaIIIAI.makeBrain(this, dynamic);
    }

    @Override
    protected void initMemories(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        GaiaIIIAI.initMemories(this, level.m_6018_(), this.getHome().m_122646_());
    }

    @Override
    protected void updateAI() {
        GaiaIIIAI.updateActivity(this);
    }

    public ResourceLocation m_7582_() {
        return this.m_6095_().m_20677_();
    }

    @Override
    public float getDamageCap() {
        return 30.0f;
    }

    @Override
    public int getEmergeTime() {
        return 200;
    }

    @Override
    public SoundEvent getBGM() {
        return ExtraBotanySounds.MUSIC_GAIA3;
    }
}

