/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.entity.gaia.behavior;

import com.google.common.collect.ImmutableMap;
import io.github.lounode.extrabotany.common.entity.gaia.Gaia;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.common.lib.BotaniaTags;

public class GaiaSmashBlocksAround<E extends Gaia>
extends Behavior<E> {
    protected static final TagKey<Block> BLACKLIST = BotaniaTags.Blocks.GAIA_BREAK_BLACKLIST;
    protected static final List<ResourceLocation> CHEATY_BLOCKS = Arrays.asList(ResourceLocation.m_214293_((String)"openblocks", (String)"beartrap"), ResourceLocation.m_214293_((String)"thaumictinkerer", (String)"magnet"));

    public GaiaSmashBlocksAround() {
        super((Map)ImmutableMap.of());
    }

    protected boolean canStillUse(ServerLevel level, E entity, long gameTime) {
        return true;
    }

    protected void tick(ServerLevel level, E gaia, long gameTime) {
        this.smashBlocksAround((Gaia)((Object)gaia), Mth.m_14107_((double)gaia.m_20185_()), Mth.m_14107_((double)gaia.m_20186_()), Mth.m_14107_((double)gaia.m_20189_()), 1);
    }

    protected void smashBlocksAround(Gaia gaia, int centerX, int centerY, int centerZ, int radius) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius + 1; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    int x = centerX + dx;
                    int y = centerY + dy;
                    int z = centerZ + dz;
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = gaia.m_9236_().m_8055_(pos);
                    Block block = state.m_60734_();
                    if (state.m_60800_((BlockGetter)gaia.m_9236_(), pos) == -1.0f) continue;
                    if (CHEATY_BLOCKS.contains(BuiltInRegistries.f_256975_.m_7981_((Object)block))) {
                        gaia.m_9236_().m_46961_(pos, true);
                        continue;
                    }
                    if (state.m_204336_(BLACKLIST) || y < gaia.getHome().m_122646_().m_123342_() || Math.abs(gaia.getHome().m_122646_().m_123341_() - x) == 4 && Math.abs(gaia.getHome().m_122646_().m_123343_() - z) == 4) continue;
                    gaia.m_9236_().m_46961_(pos, true);
                }
            }
        }
    }
}

