/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.impl;

import io.github.lounode.eventwrapper.event.level.LevelEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventBusSubscriberWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import io.github.lounode.extrabotany.api.level.Wind;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WindImpl
implements Wind {
    private static final Map<Level, LevelWind> WIND_MAP = new LinkedHashMap<Level, LevelWind>();

    @Override
    public double getWindLevel(Level level, Vec3 position) {
        if (!WIND_MAP.containsKey(level)) {
            WIND_MAP.put(level, new LevelWind(level));
        }
        return WIND_MAP.get(level).getWindLevel(position);
    }

    public static class LevelWind {
        protected final Level level;
        public int ticksExisted;
        private int baseStrength;
        private double peakHeight;
        private static final double CENTER_OFFSET_RANGE = 10.0;
        private static final int UPDATE_PEAK_HEIGHT_INTERVAL = 36000;
        private static final int UPDATE_STRENGTH_INTERVAL = 200;

        public LevelWind(Level level) {
            this.level = level;
            this.baseStrength = 5 + level.f_46441_.m_188503_(10);
            this.updatePeakHeight();
        }

        public void tick() {
            if (this.ticksExisted % 200 == 0) {
                int delta = this.level.f_46441_.m_188503_(3) - 1;
                this.baseStrength = Math.max(1, Math.min(20, this.baseStrength + delta));
            }
            if (this.ticksExisted % 36000 == 0) {
                this.updatePeakHeight();
            }
            ++this.ticksExisted;
        }

        private void updatePeakHeight() {
            double seaLevel = this.level.m_5736_();
            double maxHeight = this.level.m_151558_();
            double center = (seaLevel + maxHeight) / 2.0;
            this.peakHeight = center + (this.level.f_46441_.m_188500_() * 2.0 - 1.0) * 10.0;
        }

        public double getWindLevel(Vec3 position) {
            double height = position.m_7098_();
            double seaLevel = this.level.m_5736_();
            double maxHeight = this.level.m_151558_();
            double range = maxHeight - seaLevel;
            double delta = height - this.peakHeight;
            double sigma = 20.0;
            double heightMultiplier = Math.exp(-Math.pow(delta / sigma, 2.0));
            double result = (double)this.baseStrength * (0.5 + heightMultiplier * 1.5);
            double rainOffset = 1.0;
            if (this.level.m_46471_()) {
                rainOffset += 0.25;
            }
            if (this.level.m_46470_()) {
                rainOffset += 0.25;
            }
            return result * rainOffset;
        }
    }

    @EventBusSubscriberWrapper
    public static class EventHandler {
        @SubscribeEventWrapper
        public static void onLevelLoad(LevelEventWrapper.Load event) {
            Level level = (Level)event.getLevel();
            if (!WIND_MAP.containsKey(level)) {
                WIND_MAP.put(level, new LevelWind(level));
            }
        }

        public static void onLevelUnLoad(LevelEventWrapper.Unload event) {
            Level level = (Level)event.getLevel();
            WIND_MAP.remove(level);
        }

        public static void onLevelTick(Level level) {
            if (WIND_MAP.containsKey(level)) {
                LevelWind wind = WIND_MAP.get(level);
                wind.tick();
            }
        }
    }
}

