/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item;

import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import io.github.lounode.extrabotany.network.clientbound.ManaReaderPacket;
import io.github.lounode.extrabotany.xplat.EXplatAbstractions;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;

public class ManaReaderItem
extends Item {
    private static final int ADVANCE_REQUIRE = 1000;

    public ManaReaderItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockPos pos;
        Player player = ctx.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Level world = ctx.m_43725_();
        BlockEntity tile = world.m_7702_(pos = ctx.m_8083_());
        if (!ManaReaderItem.canReadMana(tile)) {
            return InteractionResult.PASS;
        }
        if (world.f_46443_) {
            player.m_5496_(BotaniaSounds.ding, 0.6f, 0.1f + world.f_46441_.m_188501_() * 0.5f);
            return InteractionResult.SUCCESS;
        }
        int manaValue = ManaReaderItem.tryReadMana(tile);
        if (manaValue < 0) {
            return InteractionResult.SUCCESS;
        }
        EXplatAbstractions.INSTANCE.sendToPlayer((ServerPlayer)player, new ManaReaderPacket(manaValue));
        ItemStack stack = ctx.m_43722_();
        int currentCount = ItemNBTHelper.getInt((ItemStack)stack, (String)"count", (int)0) + 1;
        ItemNBTHelper.setInt((ItemStack)stack, (String)"count", (int)currentCount);
        if (currentCount >= 1000) {
            PlayerHelper.grantCriterion((ServerPlayer)((ServerPlayer)player), (ResourceLocation)ResourceLocationHelper.prefix("main/senbon_zakura"), (String)"code_triggered");
        }
        return InteractionResult.SUCCESS;
    }

    public static boolean canReadMana(BlockEntity tile) {
        return tile instanceof ManaReceiver || tile instanceof GeneratingFlowerBlockEntity || tile instanceof FunctionalFlowerBlockEntity;
    }

    public static int tryReadMana(BlockEntity tile) {
        int mana = -1;
        if (tile instanceof ManaReceiver) {
            ManaReceiver receiver = (ManaReceiver)tile;
            mana = receiver.getCurrentMana();
        } else if (tile instanceof GeneratingFlowerBlockEntity) {
            GeneratingFlowerBlockEntity genFlower = (GeneratingFlowerBlockEntity)tile;
            mana = genFlower.getMana();
        } else if (tile instanceof FunctionalFlowerBlockEntity) {
            FunctionalFlowerBlockEntity funcFlower = (FunctionalFlowerBlockEntity)tile;
            mana = funcFlower.getMana();
        }
        return mana;
    }
}

