/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item;

import io.github.lounode.extrabotany.api.item.RewardBag;
import io.github.lounode.extrabotany.client.LootDataPoolClient;
import io.github.lounode.extrabotany.common.loot.RewardBagManager;
import io.github.lounode.extrabotany.common.sounds.ExtraBotanySounds;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.helper.ItemNBTHelper;

public class RewardBagItem
extends Item
implements RewardBag {
    public static final String TAG_LOOT_TABLE = "LootTable";
    private final ResourceLocation lootTable;

    public RewardBagItem(Item.Properties properties, ResourceLocation lootTable) {
        super(properties);
        this.lootTable = lootTable;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (!level.m_5776_()) {
            LootTable table = level.m_7654_().m_278653_().m_278676_(RewardBagItem.getLoot(stack));
            LootParams.Builder parameter = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_287239_(player.m_36336_());
            LootParams lootparams = parameter.m_287235_(LootContextParamSets.f_81411_);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            table.m_287276_(lootparams, player.m_287233_(), itemStack -> player.m_19983_(itemStack).m_32061_());
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.getSound(), SoundSource.PLAYERS, 0.8f, 1.0f);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        ResourceLocation tableKey = RewardBagItem.getLoot(stack);
        if (tableKey == null) {
            return;
        }
        List<RewardBagManager.LootData> datas = LootDataPoolClient.getData(tableKey);
        if (datas == null) {
            return;
        }
        for (RewardBagManager.LootData data : datas) {
            tooltip.add((Component)Component.m_237113_((String)(Component.m_237115_((String)data.item().m_5524_()).getString() + " " + data.chance() + "%")));
        }
    }

    @Nullable
    public static ResourceLocation getLoot(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof RewardBagItem) {
            RewardBagItem bag = (RewardBagItem)item;
            String tableKey = ItemNBTHelper.getString((ItemStack)stack, (String)TAG_LOOT_TABLE, (String)"");
            if (!tableKey.isEmpty()) {
                return ResourceLocation.m_135820_((String)tableKey).m_246208_("reward_bags/");
            }
            return bag.getLootTable().m_246208_("reward_bags/");
        }
        return null;
    }

    @Override
    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public SoundEvent getSound() {
        return ExtraBotanySounds.REWARD_BAG_OPEN;
    }
}

