/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.brew;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lounode.extrabotany.common.entity.HolyWaterGrenadeEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.BrewItem;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class HolyWaterGrenadeItem
extends Item
implements BrewItem,
CustomCreativeTabContents {
    private static final String TAG_BREW_KEY = "brewKey";

    public HolyWaterGrenadeItem(Item.Properties properties) {
        super(properties);
    }

    public void addToCreativeTab(Item me, CreativeModeTab.Output output) {
        for (Brew brew : BotaniaAPI.instance().getBrewRegistry()) {
            if (brew == BotaniaBrews.fallbackBrew) continue;
            ItemStack stack = new ItemStack((ItemLike)this);
            HolyWaterGrenadeItem.setBrew(stack, brew);
            output.m_246342_(stack);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (!level.m_5776_()) {
            level.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12437_, SoundSource.PLAYERS, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
            HolyWaterGrenadeEntity grenade = new HolyWaterGrenadeEntity(level, (LivingEntity)player);
            grenade.m_37446_(stack);
            grenade.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), -20.0f, 0.5f, 1.0f);
            level.m_7967_((Entity)grenade);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        HolyWaterGrenadeItem.addPotionTooltip(this.getBrew(stack).getPotionEffects(stack), list, 1.0f);
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return Component.m_237110_((String)this.m_5524_(), (Object[])new Object[]{Component.m_237115_((String)this.getBrew(stack).getTranslationKey(stack))});
    }

    public static void addPotionTooltip(List<MobEffectInstance> list, List<Component> lores, float durationFactor) {
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            lores.add((Component)Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY));
        } else {
            for (MobEffectInstance mobEffectInstance : list) {
                MutableComponent iformattabletextcomponent = Component.m_237115_((String)mobEffectInstance.m_19576_());
                MobEffect effect = mobEffectInstance.m_19544_();
                Map map = effect.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), effect.m_7048_(mobEffectInstance.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                        list1.add(new Pair((Object)((Attribute)entry.getKey()), (Object)attributemodifier1));
                    }
                }
                if (mobEffectInstance.m_19564_() > 0) {
                    iformattabletextcomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{iformattabletextcomponent, Component.m_237115_((String)("potion.potency." + mobEffectInstance.m_19564_()))});
                }
                if (mobEffectInstance.m_19557_() > 20) {
                    iformattabletextcomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{iformattabletextcomponent, MobEffectUtil.m_267641_((MobEffectInstance)mobEffectInstance, (float)durationFactor)});
                }
                lores.add((Component)iformattabletextcomponent.m_130940_(effect.m_19483_().m_19497_()));
            }
        }
        if (!list1.isEmpty()) {
            lores.add((Component)Component.m_237119_());
            lores.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            ArrayList<MutableComponent> loresToAdd1 = new ArrayList<MutableComponent>();
            for (Pair pair : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.m_22218_();
                double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                if (!(d0 < 0.0)) continue;
                loresToAdd1.add(Component.m_237110_((String)("attribute.modifier.take." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
            if (!loresToAdd1.isEmpty()) {
                lores.add((Component)Component.m_237119_());
                lores.add((Component)Component.m_237115_((String)"tooltip.extrabotany.buff_for_enemy").m_130940_(ChatFormatting.DARK_RED));
                lores.addAll(loresToAdd1);
            }
            ArrayList<MutableComponent> arrayList = new ArrayList<MutableComponent>();
            for (Pair pair : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.m_22218_();
                double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                if (!(d0 > 0.0)) continue;
                arrayList.add(Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
            }
            if (!arrayList.isEmpty()) {
                lores.add((Component)Component.m_237119_());
                lores.add((Component)Component.m_237115_((String)"tooltip.extrabotany.buff_for_self").m_130940_(ChatFormatting.GREEN));
                lores.addAll(arrayList);
            }
        }
    }

    public Brew getBrew(ItemStack stack) {
        String key = ItemNBTHelper.getString((ItemStack)stack, (String)TAG_BREW_KEY, (String)"");
        return (Brew)BotaniaAPI.instance().getBrewRegistry().m_7745_(ResourceLocation.m_135820_((String)key));
    }

    public static void setBrew(ItemStack stack, @Nullable Brew brew) {
        ResourceLocation id = brew != null ? BotaniaAPI.instance().getBrewRegistry().m_7981_((Object)brew) : ResourceLocationHelper.prefix((String)"fallback");
        HolyWaterGrenadeItem.setBrew(stack, id);
    }

    public static void setBrew(ItemStack stack, ResourceLocation brew) {
        ItemNBTHelper.setString((ItemStack)stack, (String)TAG_BREW_KEY, (String)brew.toString());
    }

    @NotNull
    public static String getSubtype(ItemStack stack) {
        return stack.m_41782_() ? ItemNBTHelper.getString((ItemStack)stack, (String)TAG_BREW_KEY, (String)"none") : "none";
    }
}

